/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntry;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryAssociationType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroup;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductRelatedProductGroup;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.booking.air.AgencyMemo;
import com.gridnine.xtrip.common.model.booking.air.AgencyMemoItem;
import com.gridnine.xtrip.common.model.booking.air.AgencyMemoItemType;
import com.gridnine.xtrip.common.model.booking.air.AgencyMemoType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class AgencyMemoProductMigrationTask
extends BaseLongRunningTask<Serializable> {
    private final Set<String> toProceed = new LinkedHashSet<String>();

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.AgencyMemoProductMigrationTask_createClaims, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        for (Element element : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(element.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("create of agency memo products started");
        this.updateUids();
        int count = this.toProceed.size();
        this.log.debug(String.format("uids updated, remains " + count, new Object[0]));
        String equivalentCurrencyCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null);
        int n = 0;
        for (String item : this.toProceed) {
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            ++n;
            String agencyMemoTitle = item;
            try {
                Airline airline;
                DictionaryReference airlineReference;
                Object blankOwnerContainer;
                EntityContainer agencyMemoContainer = EntityStorage.get().load(AgencyMemo.class, item);
                AgencyMemo agencyMemo = (AgencyMemo)agencyMemoContainer.getEntity();
                agencyMemoTitle = agencyMemo.toString();
                byte progress = (byte)(100 * n / count);
                this.log.debug(String.format("processing agency memo %s, %s of %s (%s%%)", agencyMemoTitle, String.valueOf(n), String.valueOf(count), String.valueOf(progress)));
                if (n % 10 == 0) {
                    callback.updateProgress(progress);
                }
                AgencyMemoProduct agencyMemoProduct = new AgencyMemoProduct();
                agencyMemoProduct.setBlankOwner(agencyMemo.getBlankOwner());
                agencyMemoProduct.setSupplier(agencyMemo.getSupplier());
                agencyMemoProduct.setAgency(agencyMemo.getAgency());
                String airlineCode = null;
                if (agencyMemo.getBlankOwner() != null && (blankOwnerContainer = EntityStorage.get().resolve(agencyMemo.getBlankOwner())) != null && (airlineReference = ((Organization)blankOwnerContainer.getEntity()).getAirline()) != null && (airline = (Airline)DictionaryCache.get().resolveReference(airlineReference)) != null) {
                    airlineCode = airline.getAirlineNumber();
                }
                agencyMemoProduct.setType(this.getType(agencyMemo.getType()));
                agencyMemoProduct.setAirlineCode(airlineCode);
                agencyMemoProduct.setSystemNumber(agencyMemo.getSystemNumber());
                agencyMemoProduct.setIssueDate(agencyMemo.getIssueDate());
                agencyMemoProduct.setAcceptDate(agencyMemo.getAcceptDate());
                agencyMemoProduct.setSourceReportDate(agencyMemo.getSourceReportDate());
                agencyMemoProduct.setTargetReportDate(agencyMemo.getTargetReportDate());
                agencyMemoProduct.setIncludeToReport(true);
                blankOwnerContainer = agencyMemo.getItems().iterator();
                while (blankOwnerContainer.hasNext()) {
                    AgencyMemoItem agencyMemoItem = (AgencyMemoItem)blankOwnerContainer.next();
                    AgencyMemoProductEntryType type = this.getType(agencyMemoItem.getType());
                    Money amount = agencyMemoItem.getAmount();
                    Object equivalentAmount = null;
                    if (amount != null && amount.getValue() != null && amount.getCurrency() != null && TextUtil.isSame((String)amount.getCurrency(), (String)equivalentCurrencyCode)) {
                        equivalentAmount = amount.getValue();
                    }
                    AgencyMemoProductEntryAssociationType associationType = agencyMemoItem.getRelatedProductNumbers().isEmpty() ? AgencyMemoProductEntryAssociationType.REPORT : AgencyMemoProductEntryAssociationType.PRODUCT;
                    List relatedProductNumbers = agencyMemoItem.getRelatedProductNumbers();
                    ArrayList<Object> entries = new ArrayList<Object>();
                    if (associationType == AgencyMemoProductEntryAssociationType.REPORT) {
                        AgencyMemoProductEntry entry = new AgencyMemoProductEntry();
                        entry.setProduct(agencyMemoProduct);
                        entry.setContractType(ContractType.VENDOR);
                        entry.setType(type);
                        entry.setAssociationType(associationType);
                        entry.setRelatedProductNumber(null);
                        entry.setAmount(amount);
                        entry.setEquivalentAmount((BigDecimal)equivalentAmount);
                        entries.add(entry);
                    } else if (associationType == AgencyMemoProductEntryAssociationType.PRODUCT) {
                        for (String relatedProductNumber : relatedProductNumbers) {
                            void var23_27;
                            Object var23_25 = null;
                            BigDecimal entryEquivalentAmount = null;
                            if (amount != null) {
                                Money money = new Money();
                                if (amount.getValue() != null) {
                                    money.setValue(amount.getValue().divide(BigDecimal.valueOf(relatedProductNumbers.size()), RoundingMode.HALF_UP));
                                }
                                money.setCurrency(amount.getCurrency());
                            }
                            if (equivalentAmount != null) {
                                entryEquivalentAmount = ((BigDecimal)equivalentAmount).divide(BigDecimal.valueOf(relatedProductNumbers.size()), RoundingMode.HALF_UP);
                            }
                            AgencyMemoProductEntry entry = new AgencyMemoProductEntry();
                            entry.setProduct(agencyMemoProduct);
                            entry.setContractType(ContractType.VENDOR);
                            entry.setType(type);
                            entry.setAssociationType(associationType);
                            entry.setRelatedProductNumber(relatedProductNumber);
                            entry.setAmount((Money)var23_27);
                            entry.setEquivalentAmount(entryEquivalentAmount);
                            entries.add(entry);
                        }
                    }
                    agencyMemoProduct.getEntries().addAll(entries);
                    AgencyMemoProductItemGroup itemGroup = new AgencyMemoProductItemGroup();
                    itemGroup.setContractType(ContractType.VENDOR);
                    itemGroup.setType(type);
                    itemGroup.setAmount(amount);
                    itemGroup.setEquivalentAmount((BigDecimal)equivalentAmount);
                    itemGroup.setDescription(agencyMemoItem.getDescription());
                    itemGroup.getEntries().addAll(entries);
                    agencyMemoProduct.getItemGroups().add(itemGroup);
                    for (AgencyMemoProductEntry agencyMemoProductEntry : entries) {
                        AgencyMemoProductRelatedProductGroup relatedProductGroup = this.getRelatedProductGroup(agencyMemoProduct.getRelatedProductGroups(), agencyMemoProductEntry.getAssociationType(), agencyMemoProductEntry.getRelatedProductNumber());
                        if (relatedProductGroup == null) {
                            EntityReference client = null;
                            EntityReference subagency = null;
                            EntityReference salesPoint = null;
                            EntityReference agent = null;
                            if (agencyMemoProductEntry.getAssociationType() == AgencyMemoProductEntryAssociationType.REPORT) {
                                subagency = agencyMemo.getSubagency();
                                salesPoint = agencyMemo.getSalesPoint();
                                agent = agencyMemo.getAgent();
                            } else if (agencyMemoProductEntry.getAssociationType() == AgencyMemoProductEntryAssociationType.PRODUCT && agencyMemoProductEntry.getRelatedProductNumber() != null) {
                                SearchQuery query = new SearchQuery();
                                query.getCriteria().getCriterions().add(SearchCriterion.contains((String)CommonProductIndex.Property.systemNumbers.name(), (Object)agencyMemoProductEntry.getRelatedProductNumber()));
                                List commonProductIndexes = EntityStorage.get().search(CommonProductIndex.class, query).getData();
                                block6: for (CommonProductIndex commonProductIndex : commonProductIndexes) {
                                    EntityReference bookingFileReference = commonProductIndex.getSource();
                                    EntityContainer bookingFileContainer = EntityStorage.get().resolve(bookingFileReference);
                                    if (bookingFileContainer == null) continue;
                                    for (Reservation reservation : ((BookingFile)bookingFileContainer.getEntity()).getReservations()) {
                                        for (BaseProduct baseProduct : reservation.getProducts()) {
                                            ProductHandler handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                                            if (handler == null) continue;
                                            List productNumbers = handler.getProductNumbers(baseProduct);
                                            if (productNumbers.contains(agencyMemoProductEntry.getRelatedProductNumber())) {
                                                if (client == null) {
                                                    client = baseProduct.getReservation().getBookingFile().getCustomerProfile();
                                                }
                                                if (subagency == null) {
                                                    subagency = GeneralProductHelper.getContractor((SalesChain)handler.getSalesChain(baseProduct), (PredefinedContractorType)PredefinedContractorType.SUBAGENCY);
                                                }
                                                if (salesPoint == null) {
                                                    salesPoint = handler.findSalesPoint(baseProduct);
                                                }
                                                if (agent == null) {
                                                    agent = handler.findIssuingAgent(baseProduct);
                                                }
                                            }
                                            if (client == null || subagency == null || salesPoint == null || agent == null) continue;
                                            break block6;
                                        }
                                    }
                                }
                            }
                            relatedProductGroup = new AgencyMemoProductRelatedProductGroup();
                            relatedProductGroup.setAssociationType(agencyMemoProductEntry.getAssociationType());
                            relatedProductGroup.setRelatedProductNumber(agencyMemoProductEntry.getRelatedProductNumber());
                            relatedProductGroup.setClient(client);
                            relatedProductGroup.setSubagency(subagency);
                            relatedProductGroup.setSalesPoint(salesPoint);
                            relatedProductGroup.setAgent(agent);
                            agencyMemoProduct.getRelatedProductGroups().add(relatedProductGroup);
                        }
                        relatedProductGroup.getEntries().add(agencyMemoProductEntry);
                    }
                }
                EntityReference client = null;
                EntityReference subagency = null;
                EntityReference salesPoint = null;
                EntityReference agent = null;
                for (AgencyMemoProductRelatedProductGroup relatedProductGroup : agencyMemoProduct.getRelatedProductGroups()) {
                    if (client == null) {
                        client = relatedProductGroup.getClient();
                    }
                    if (subagency == null) {
                        subagency = relatedProductGroup.getSubagency();
                    }
                    if (salesPoint == null) {
                        salesPoint = relatedProductGroup.getSalesPoint();
                    }
                    if (agent == null) {
                        agent = relatedProductGroup.getAgent();
                    }
                    if (client == null || subagency == null || salesPoint == null || agent == null) continue;
                    break;
                }
                Reservation reservation = new Reservation();
                reservation.setSubagency(subagency);
                reservation.setSalesPoint(salesPoint);
                reservation.setBookingAgent(agent);
                agencyMemoProduct.setReservation(reservation);
                reservation.getProducts().add(agencyMemoProduct);
                EntityContainer bookingFileContainer = new EntityContainer(BookingFile.class);
                BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
                bookingFile.setCustomerProfile(client);
                bookingFile.setAgency(agencyMemoProduct.getAgency());
                reservation.setBookingFile(bookingFile);
                bookingFile.getReservations().add(reservation);
                bookingFileContainer.getVersionInfo().setDataSource("agency-memo-product-migration-task");
                EntityStorage.get().save(bookingFileContainer, true);
            }
            catch (Throwable e) {
                this.log.error(String.format("unable to create agency memo product %s", agencyMemoTitle), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043f\u0440\u0435\u0442\u0435\u043d\u0437\u0438\u0438 {0}", (Throwable)e, (Object[])new Object[]{agencyMemoTitle}));
            }
        }
        callback.taskFinished();
        this.log.debug("create of agency memo products finished");
    }

    private AgencyMemoProductType getType(AgencyMemoType type) {
        switch (type) {
            case ADM: {
                return AgencyMemoProductType.ADM;
            }
            case ACM: {
                return AgencyMemoProductType.ACM;
            }
        }
        return null;
    }

    private AgencyMemoProductEntryType getType(AgencyMemoItemType type) {
        switch (type) {
            case TARIFF: {
                return AgencyMemoProductEntryType.TARIFF;
            }
            case TAX_CARRIER: {
                return AgencyMemoProductEntryType.TAX_CARRIER;
            }
            case TAX_FUEL: {
                return AgencyMemoProductEntryType.TAX_FUEL;
            }
            case TAX_OTHERS: {
                return AgencyMemoProductEntryType.TAX_OTHERS;
            }
            case PENALTY: {
                return AgencyMemoProductEntryType.PENALTY;
            }
            case PENALTY_SHORTAGE: {
                return AgencyMemoProductEntryType.CONTRACT_PENALTY;
            }
            case COMMISSION: {
                return AgencyMemoProductEntryType.COMMISSION;
            }
            case BONUS: {
                return AgencyMemoProductEntryType.BONUS;
            }
        }
        return null;
    }

    private AgencyMemoProductRelatedProductGroup getRelatedProductGroup(Collection<AgencyMemoProductRelatedProductGroup> groups, AgencyMemoProductEntryAssociationType associationType, String relatedProductNumber) {
        for (AgencyMemoProductRelatedProductGroup group : groups) {
            if (group.getAssociationType() != associationType || associationType == AgencyMemoProductEntryAssociationType.PRODUCT && !TextUtil.isSame((String)group.getRelatedProductNumber(), (String)relatedProductNumber, (boolean)false, (boolean)false)) continue;
            return group;
        }
        return null;
    }

    private void updateUids() throws Exception {
        if (!this.toProceed.isEmpty()) {
            return;
        }
        LogicalStorage storage = LogicalStorage.get();
        LogicalEntityStorage entityStorage = storage.getEntityStorage();
        List uids = entityStorage.getEntityUids(AgencyMemo.class, null, null, true, true, SortOrder.DESC, null);
        this.toProceed.addAll(uids);
    }
}

