/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntry;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductIndex;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroup;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class AgencyMemoProductsUpdateTask
extends BaseLongRunningTask<Serializable> {
    private int count = -1;
    private final Set<String> toProceed = new LinkedHashSet<String>();

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.AgencyMemoProductsUpdateTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        Element countElement = XmlUtil.getElement((Element)elm, (String)"count");
        if (countElement != null) {
            this.count = Integer.parseInt(countElement.getAttribute("value"));
        }
        for (Element itemElement : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(itemElement.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        Element countElement = XmlUtil.addElement((Element)elm, (String)"count");
        countElement.setAttribute("value", String.valueOf(this.count));
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("agency memo products update started");
        this.updateUids();
        if (this.count == -1) {
            this.count = this.toProceed.size();
        }
        int n = this.count - this.toProceed.size();
        this.log.debug(String.format(String.format("uids updated, processed: %s, total: %s", String.valueOf(n), String.valueOf(this.count)), new Object[0]));
        Iterator<String> uidIterator = this.toProceed.iterator();
        while (uidIterator.hasNext()) {
            String uid = uidIterator.next();
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            ++n;
            String bookingFileTitle = uid;
            try {
                EntityContainer bookingFileContainer = EntityStorage.get().load(BookingFile.class, uid);
                if (bookingFileContainer == null) continue;
                BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
                bookingFileTitle = bookingFile.toString();
                byte progress = (byte)(100 * n / this.count);
                this.log.debug(String.format("processing booking file %s, %s of %s (%s%%)", bookingFileTitle, String.valueOf(n), String.valueOf(this.count), String.valueOf(progress)));
                if (n % 10 == 0) {
                    callback.updateProgress(progress);
                }
                boolean save = false;
                for (Reservation reservation : bookingFile.getReservations()) {
                    for (BaseProduct baseProduct : reservation.getProducts()) {
                        if (!(baseProduct instanceof AgencyMemoProduct)) continue;
                        AgencyMemoProduct product = (AgencyMemoProduct)baseProduct;
                        this.log.debug(String.format("processing agency memo product %s", product.getSystemNumber()));
                        for (AgencyMemoProductItemGroup itemGroup : product.getItemGroups()) {
                            if (itemGroup.getAmount() != null && itemGroup.getAmount().getValue() != null && itemGroup.getAmount().getValue().compareTo(BigDecimal.ZERO) < 0) {
                                itemGroup.getAmount().setValue(itemGroup.getAmount().getValue().negate());
                                save = true;
                            }
                            if (itemGroup.getEquivalentAmount() == null || itemGroup.getEquivalentAmount().compareTo(BigDecimal.ZERO) >= 0) continue;
                            itemGroup.setEquivalentAmount(itemGroup.getEquivalentAmount().negate());
                            save = true;
                        }
                        for (AgencyMemoProductEntry entry : product.getEntries()) {
                            if (entry.getAmount() != null && entry.getAmount().getValue() != null && entry.getAmount().getValue().compareTo(BigDecimal.ZERO) < 0) {
                                entry.getAmount().setValue(entry.getAmount().getValue().negate());
                                save = true;
                            }
                            if (entry.getEquivalentAmount() == null || entry.getEquivalentAmount().compareTo(BigDecimal.ZERO) >= 0) continue;
                            entry.setEquivalentAmount(entry.getEquivalentAmount().negate());
                            save = true;
                        }
                    }
                }
                if (save) {
                    EntityStorage.get().save(bookingFileContainer, true);
                }
            }
            catch (Throwable e) {
                this.log.error(String.format("unable to update agency memo products of booking file %s", bookingFileTitle), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AgencyMemoProductsUpdateTask_agencyMemoProductsUpdateFailed, (Throwable)e, (Object[])new Object[]{bookingFileTitle}));
            }
            uidIterator.remove();
        }
        callback.taskFinished();
        this.log.debug("agency memo products update finished");
    }

    private void updateUids() throws Exception {
        if (this.count != -1 && !this.toProceed.isEmpty()) {
            return;
        }
        LogicalEntityStorage entityStorage = LogicalStorage.get().getEntityStorage();
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add("uid");
        for (AgencyMemoProductIndex index : entityStorage.search(AgencyMemoProductIndex.class, query).getData()) {
            String uid = index.getSource().getUid();
            if (this.toProceed.contains(uid)) continue;
            this.toProceed.add(uid);
        }
    }
}

