/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profiling.Profiler;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.BaseEntityUpdateTaskConfiguration;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.w3c.dom.Element;

public abstract class BaseEntityUpdateTask<C extends BaseEntityUpdateTaskConfiguration>
extends BaseLongRunningTask<C> {
    protected volatile C config;
    private List<Part> partList = null;
    private int totalCount = -1;
    private int doneCount = 0;
    protected AtomicInteger errorCount = new AtomicInteger();
    private Date doneTo = null;
    private final List<Object> earlierProcessed = new ArrayList<Object>();

    public void test(LongRunningTask.EventsCallback callback) throws Exception {
        this.doJob(callback);
    }

    public C getConfig() {
        return this.config;
    }

    @Override
    public void configure(C configuration) throws Exception {
        this.config = configuration;
    }

    protected List<Part> getPartList(Date configDate, Date date, int hours) throws Exception {
        ArrayList<Part> result = new ArrayList<Part>();
        if (configDate == null) {
            return result;
        }
        Calendar current = Calendar.getInstance();
        if (date != null) {
            current.setTime(date);
        }
        Calendar next = Calendar.getInstance();
        while (current.getTimeInMillis() > configDate.getTime()) {
            next.setTimeInMillis(current.getTimeInMillis());
            next.add(10, -hours);
            if (next.getTimeInMillis() < configDate.getTime()) {
                next.setTimeInMillis(configDate.getTime());
            }
            result.add(new Part(next.getTime(), current.getTime(), this.createData()));
            current.add(10, -hours);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getDate(final boolean isUsedCreateDate, final LongRunningTask.EventsCallback callback) throws Exception {
        Collection<Class<?>> entityTypeList = this.getEntityTypeList();
        Date result = null;
        final LinkedBlockingDeque dateList = new LinkedBlockingDeque();
        ExecutorServiceFacade service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool(this.getClass().getName(), this.config.getThreadCount() > 0 ? this.config.getThreadCount() : 1);
        final CountDownLatch countDown = new CountDownLatch(entityTypeList.size());
        try {
            for (final Class<?> entityType : entityTypeList) {
                service.submit(new Runnable(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        block9: {
                            if (!BaseEntityUpdateTask.this.isToBeStopped()) break block9;
                            countDown.countDown();
                            return;
                        }
                        try {
                            try {
                                Date typeDate = BaseEntityUpdateTask.this.getEntityTypeDate(entityType, isUsedCreateDate);
                                if (typeDate == null) return;
                                dateList.add(typeDate);
                                return;
                            }
                            catch (Throwable t) {
                                BaseEntityUpdateTask.this.log.error("error in task", t);
                                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}: {1}", (Throwable)t, (Object[])new Object[]{entityType.getName(), t.toString()}));
                                if (!BaseEntityUpdateTask.this.config.isStopOnError() || BaseEntityUpdateTask.this.isToBeStopped()) return;
                                BaseEntityUpdateTask.this.log.debug("stop task");
                                try {
                                    BaseEntityUpdateTask.this.stop();
                                }
                                catch (Throwable e) {
                                    BaseEntityUpdateTask.this.log.error("unable to stop task", e);
                                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Throwable)e, (Object[])new Object[0]));
                                }
                                countDown.countDown();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            countDown.countDown();
                        }
                    }
                });
            }
            countDown.await();
        }
        finally {
            service.dispose();
        }
        for (Date typeDate : dateList) {
            if (typeDate == null || result != null && !result.after(typeDate)) continue;
            result = typeDate;
        }
        return result;
    }

    protected Date getEntityTypeDate(Class<?> clazz, boolean isUsedCreateDate) throws Exception {
        if (BaseEntity.class.isAssignableFrom(clazz)) {
            return this.getEntityStorageDate(clazz, isUsedCreateDate);
        }
        throw new IllegalArgumentException("Wrong class for reindex task: " + String.valueOf(clazz));
    }

    protected <T extends BaseEntity> Date getEntityStorageDate(Class<T> clazz, boolean isUsedCreateDate) throws Exception {
        LogicalEntityStorage entityStorage = LogicalStorage.get().getEntityStorage();
        List uidList1 = entityStorage.getEntityUids(clazz, null, null, this.config.isUsedCreateDate(), true, SortOrder.ASC, Integer.valueOf(1));
        Date date1 = null;
        if (uidList1.size() >= 1) {
            EntityContainer entity1 = EntityStorage.get().load(clazz, (String)uidList1.get(0));
            date1 = entity1 != null ? (isUsedCreateDate ? entity1.getCreated() : entity1.getModified()) : null;
        }
        return date1;
    }

    protected boolean acceptType(String typeId) {
        return true;
    }

    protected Collection<Class<?>> getEntityTypeList() throws Exception {
        HashSet result = new HashSet();
        MetaRegistry metaRegistry = MetaRegistry.get();
        Set typeList = this.config.getTypeList();
        for (EntityType value : metaRegistry.getEntities().values()) {
            if (typeList != null && typeList.size() > 0 && !typeList.contains(value.getId()) || !this.acceptType(value.getId())) continue;
            result.add(Class.forName(value.getId()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E extends BaseEntity> boolean processEntityStorage(Part part, Class<E> entityClass, LongRunningTask.EventsCallback callback) throws Throwable {
        LogicalEntityStorage entityStorage = LogicalStorage.get().getEntityStorage();
        List uidList = entityStorage.getEntityUids(entityClass, part.getFrom(), part.getTo(), this.config.isUsedCreateDate(), true, this.config.isDescOrder() ? SortOrder.DESC : SortOrder.ASC, null);
        for (String uid : uidList) {
            EntityContainer etc = null;
            try {
                if (this.isToBeStopped()) {
                    return false;
                }
                long timing = System.currentTimeMillis();
                try {
                    etc = entityStorage.load(entityClass, uid, new EntityStorageLoadParameters());
                    if (etc == null) continue;
                    this.processContainer(etc, entityStorage, part.getData());
                }
                finally {
                    String key = "tasks." + MiscUtil.getSimpleClassName(this.getClass()) + ".processEntityStorage." + MiscUtil.getSimpleClassName(entityClass);
                    if (!Profiler.get().isProfilingEnabled(key)) continue;
                    Profiler.get().updateTiming(key, timing, null);
                }
            }
            catch (Throwable t) {
                if (this.config.isStopOnError()) {
                    throw t;
                }
                this.errorCount.incrementAndGet();
                this.log.error(String.format("error in task %s (class %s, uid %s): %s", etc == null ? null : etc.toReference(), entityClass.getName(), uid, t.toString()), t);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0} type {1}, uid {2}: {3}", (Throwable)t, (Object[])new Object[]{etc == null ? null : etc.toReference(), entityClass.getName(), uid, t.toString()}));
            }
        }
        return true;
    }

    protected Object createData() {
        return null;
    }

    protected void makeResult(LongRunningTask.EventsCallback callback) {
    }

    protected List<Object> getDataList() {
        if (this.partList == null && this.earlierProcessed.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = null;
        if (!this.earlierProcessed.isEmpty()) {
            result = new ArrayList<Object>();
            result.addAll(this.earlierProcessed);
        }
        if (this.partList != null) {
            for (Part part : this.partList) {
                Object data = part.getData();
                if (data == null) continue;
                if (result == null) {
                    result = new ArrayList();
                }
                result.add(data);
            }
        }
        return result != null ? result : Collections.emptyList();
    }

    protected abstract <E extends BaseEntity> void processContainer(EntityContainer<E> var1, LogicalEntityStorage var2, Object var3) throws Exception;

    protected boolean processEntityType(Class<?> clazz, Part part, LongRunningTask.EventsCallback callback) throws Throwable {
        if (BaseEntity.class.isAssignableFrom(clazz)) {
            return this.processEntityStorage(part, clazz, callback);
        }
        throw new IllegalArgumentException("Wrong class for reindex task: " + String.valueOf(clazz));
    }

    private static DateFormat createDateTimeFormat() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(final LongRunningTask.EventsCallback callback) throws Exception {
        try {
            this.log.debug("task started");
            Date configDate = this.config.getDate();
            Date startDate = configDate != null ? configDate : this.getDate(this.config.isUsedCreateDate(), callback);
            Date finishDate = this.doneTo != null ? this.doneTo : new Date();
            int threadCount = this.config.getThreadCount() > 0 ? this.config.getThreadCount() : 1;
            int hours = this.config.getHours() > 0 ? this.config.getHours() : 24;
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0443\u0441\u043a\u0430:", (Object[])new Object[0]));
            DateFormat dateTimeFormat = BaseEntityUpdateTask.createDateTimeFormat();
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430: {0}", (Object[])new Object[]{startDate != null ? dateTimeFormat.format(startDate) + (configDate != null ? "" : " (\u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0430)") : "(\u0432\u044b\u0447\u0438\u0441\u043b\u0438\u0442\u044c \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c)"}));
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430: {0}", (Object[])new Object[]{dateTimeFormat.format(finishDate)}));
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u0432 \u0447\u0430\u0441\u0430\u0445: {0}", (Object[])new Object[]{Integer.toString(hours)}));
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0442\u043e\u043a\u043e\u0432: {0}", (Object[])new Object[]{Integer.toString(threadCount)}));
            this.printParameters(callback);
            if (this.doneTo != null) {
                this.partList = this.getPartList(startDate, this.doneTo, hours);
            }
            if (this.partList == null) {
                this.partList = this.getPartList(startDate, finishDate, hours);
            }
            if (!this.config.isDescOrder()) {
                Collections.reverse(this.partList);
            }
            Collection<Class<?>> entityTypeList = this.getEntityTypeList();
            int typeCount = entityTypeList.size();
            ExecutorServiceFacade service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool(this.getClass().getName(), threadCount);
            try {
                final int maxCount = this.partList.size() * typeCount;
                if (this.totalCount == -1 || this.totalCount < maxCount) {
                    this.totalCount = maxCount;
                }
                final int resumeDelta = this.doneCount = this.totalCount - maxCount;
                final CountDownLatch countDown = new CountDownLatch(maxCount);
                if (maxCount + resumeDelta != 0) {
                    byte progress = (byte)(100 * resumeDelta / (maxCount + resumeDelta));
                    callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u0438\u0437 {1}", (Object[])new Object[]{resumeDelta, maxCount + resumeDelta}));
                    callback.updateProgress(progress);
                }
                final int pd = Math.max(maxCount / 20, 1);
                final AtomicLong lastUpdateProgress = new AtomicLong(System.currentTimeMillis());
                long shadowPeriod = 300000L;
                final String taskName = MiscUtil.getSimpleClassName(this.getClass());
                for (final Part part : this.partList) {
                    part.getDownCount().set(typeCount);
                    for (final Class<?> entityType : entityTypeList) {
                        service.submit(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                block18: {
                                    try {
                                        long timing;
                                        block17: {
                                            if (BaseEntityUpdateTask.this.isToBeStopped()) {
                                                return;
                                            }
                                            timing = System.currentTimeMillis();
                                            LogicalStorage.get().authorizeAsSystem();
                                            if (BaseEntityUpdateTask.this.processEntityType(entityType, part, callback)) break block17;
                                            String key = "tasks." + taskName + ".processPart." + MiscUtil.getSimpleClassName((Class)entityType);
                                            if (Profiler.get().isProfilingEnabled(key)) {
                                                Profiler.get().updateTiming(key, timing, null);
                                            }
                                            return;
                                        }
                                        try {
                                            try {
                                                part.getDownCount().decrementAndGet();
                                                long current = (long)maxCount - countDown.getCount() + 1L;
                                                byte progress = (byte)(100L * (current + (long)resumeDelta) / (long)(maxCount + resumeDelta));
                                                if ((current + (long)resumeDelta) % (long)pd == 0L || progress >= 100 || BaseEntityUpdateTask.this.isToBeStopped() || System.currentTimeMillis() - lastUpdateProgress.get() > 300000L) {
                                                    lastUpdateProgress.set(System.currentTimeMillis());
                                                    callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u0438\u0437 {1}", (Object[])new Object[]{current + (long)resumeDelta, maxCount + resumeDelta}));
                                                    callback.updateProgress(progress);
                                                }
                                            }
                                            catch (Throwable t) {
                                                BaseEntityUpdateTask.this.log.error("error in task", t);
                                                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}: {1}", (Throwable)t, (Object[])new Object[]{entityType.getName(), t.toString()}));
                                                if (!BaseEntityUpdateTask.this.config.isStopOnError() || BaseEntityUpdateTask.this.isToBeStopped()) break block18;
                                                BaseEntityUpdateTask.this.log.debug("stop task");
                                                try {
                                                    BaseEntityUpdateTask.this.stop();
                                                }
                                                catch (Exception e) {
                                                    BaseEntityUpdateTask.this.log.error("unable to stop task", (Throwable)e);
                                                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Throwable)t, (Object[])new Object[0]));
                                                }
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                        finally {
                                            String key = "tasks." + taskName + ".processPart." + MiscUtil.getSimpleClassName((Class)entityType);
                                            if (Profiler.get().isProfilingEnabled(key)) {
                                                Profiler.get().updateTiming(key, timing, null);
                                            }
                                        }
                                    }
                                    finally {
                                        countDown.countDown();
                                    }
                                }
                            }
                        });
                    }
                }
                countDown.await();
            }
            finally {
                service.dispose();
            }
            this.makeResult(callback);
            if (this.errorCount.get() > 0) {
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u043e \u043e\u0448\u0438\u0431\u043e\u043a: {0}", (Object[])new Object[]{this.errorCount.get()}));
            }
            callback.taskFinished();
            this.log.debug("task finished");
        }
        catch (InterruptedException e) {
            this.log.error("task interrupted", (Throwable)e);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0422\u0430\u0441\u043a\u0430 \u0431\u044b\u043b\u0430 \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u0430", (Throwable)e, (Object[])new Object[0]));
        }
    }

    protected void printParameters(LongRunningTask.EventsCallback callback) {
    }

    public void toXML(Element elm) throws Exception {
        this.config.toXML(elm);
        XHelper.writeInt((Element)elm, (String)"totalCount", (int)this.totalCount);
        ArrayList<Object> processed = null;
        if (!this.earlierProcessed.isEmpty()) {
            processed = new ArrayList<Object>();
            processed.addAll(this.earlierProcessed);
        }
        if (this.partList != null) {
            Date date = null;
            for (Part part : this.partList) {
                if (part.getDownCount().get() != 0) break;
                date = part.getFrom();
                ++this.doneCount;
                Object data = part.getData();
                if (data == null) continue;
                if (processed == null) {
                    processed = new ArrayList();
                }
                processed.add(data);
            }
            if (date != null) {
                XHelper.writeDate((Element)elm, (String)"doneTo", date);
            }
        }
        XHelper.writeInt((Element)elm, (String)"doneCount", (int)this.doneCount);
        XHelper.writeInt((Element)elm, (String)"errorCount", (int)this.errorCount.get());
        if (processed != null) {
            for (Object e : processed) {
                XHelper.writeObject((Element)elm, (String)"data/item", e);
            }
        }
    }

    public void fromXML(Element elm) throws Exception {
        this.config = (BaseEntityUpdateTaskConfiguration)this.getConfigurationClass().newInstance();
        this.config.fromXML(elm);
        this.totalCount = XHelper.readInt((Element)elm, (String)"totalCount", (int)-1);
        this.doneCount = XHelper.readInt((Element)elm, (String)"doneCount", (int)0);
        this.errorCount.set(XHelper.readInt((Element)elm, (String)"errorCount", (int)0));
        this.doneTo = XHelper.readDate((Element)elm, (String)"doneTo");
        this.earlierProcessed.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"data/item")) {
            Object data = XHelper.readObject((Element)itemElm, (String)".");
            this.earlierProcessed.add(data);
        }
    }

    protected abstract Class<C> getConfigurationClass();

    protected static class Part {
        private final Date from;
        private final Date to;
        private final Object data;
        private final AtomicInteger downCount = new AtomicInteger(-1);

        public Part(Date fromValue, Date toValue, Object data) {
            this.from = fromValue;
            this.to = toValue;
            this.data = data;
        }

        public Date getFrom() {
            return this.from;
        }

        public Date getTo() {
            return this.to;
        }

        public AtomicInteger getDownCount() {
            return this.downCount;
        }

        public Object getData() {
            return this.data;
        }
    }
}

