/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.TaskController;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLongRunningTask<T extends Serializable>
implements LongRunningTask<T>,
TaskController {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile boolean toBeStopped = false;

    @Override
    public void start(LongRunningTask.EventsCallback callback) throws Exception {
        try {
            this.doJob(callback);
            if (!callback.wasFinished() && !this.toBeStopped) {
                IncidentsLog.reportStackTrace((String)"task wasn't finished ".concat(this.getClass().getName()));
            }
        }
        catch (Throwable t) {
            IncidentsLog.reportException((String)"failed executing long running task", (Throwable)t);
            throw t;
        }
    }

    @Override
    public void stop() throws Exception {
        this.toBeStopped = true;
    }

    @Override
    public void abort() throws Exception {
        this.stop();
    }

    @Override
    public boolean isToBeStopped() {
        return this.toBeStopped;
    }

    @Override
    public boolean isIndefinite() {
        return true;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean isDeleteAfterStop() {
        return false;
    }

    @Override
    public int getStopTimeoutInSeconds() {
        return 10;
    }

    protected abstract void doJob(LongRunningTask.EventsCallback var1) throws Exception;

    protected void info(LongRunningTask.EventsCallback callback, String msg, Object ... parameters) {
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)msg, (Object[])parameters));
    }

    protected void warn(LongRunningTask.EventsCallback callback, String msg, Object ... parameters) {
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)msg, (Object[])parameters));
    }

    protected void error(LongRunningTask.EventsCallback callback, Throwable e, String msg, Object ... parameters) {
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)msg, (Throwable)e, (Object[])parameters));
    }
}

