/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.PaymentDocumentType;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.PaymentDocumentSettings;
import com.gridnine.xtrip.common.model.profile.PaymentDocumentsProperties;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public abstract class BaseProfileFinanceDocumentSettingsMigrationTask<T extends BaseProfile>
extends BaseLongRunningTask<Serializable> {
    private int count = -1;
    private final Set<String> toProceed = new LinkedHashSet<String>();

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.FinanceDocumentSettingsMigrationTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        Element countElement = XmlUtil.getElement((Element)elm, (String)"count");
        if (countElement != null) {
            this.count = Integer.parseInt(countElement.getAttribute("value"));
        }
        for (Element itemElement : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(itemElement.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        Element countElement = XmlUtil.addElement((Element)elm, (String)"count");
        countElement.setAttribute("value", String.valueOf(this.count));
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("finance documents settings migration started");
        this.updateUids();
        if (this.count == -1) {
            this.count = this.toProceed.size();
        }
        int n = this.count - this.toProceed.size();
        this.log.debug(String.format(String.format("uids updated, processed: %s, total: %s", String.valueOf(n), String.valueOf(this.count)), new Object[0]));
        Iterator<String> uidIterator = this.toProceed.iterator();
        while (uidIterator.hasNext()) {
            String uid = uidIterator.next();
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            ++n;
            String profileTitle = uid;
            try {
                EntityContainer profileContainer = EntityStorage.get().load(this.getType(), uid);
                if (profileContainer == null) continue;
                BaseProfile profile = (BaseProfile)profileContainer.getEntity();
                profileTitle = profile.toString();
                byte progress = (byte)(100 * n / this.count);
                this.log.debug(String.format("processing organization %s, %s of %s (%s%%)", profileTitle, String.valueOf(n), String.valueOf(this.count), String.valueOf(progress)));
                if (n % 10 == 0) {
                    callback.updateProgress(progress);
                }
                boolean save = false;
                Iterator iterator = this.getFinanceDocumentsProperties(profile).getFinanceDocumentsSettings().iterator();
                while (iterator.hasNext()) {
                    FinanceDocumentSettings financeDocumentSettings = (FinanceDocumentSettings)iterator.next();
                    PaymentDocumentType type = this.getType(financeDocumentSettings.getType());
                    if (type == null) continue;
                    PaymentDocumentSettings settings = this.getPaymentDocumentsProperties(profile).getPaymentDocumentsSettings().stream().filter(item -> item.getType() == type).findFirst().orElse(null);
                    if (settings == null) {
                        settings = new PaymentDocumentSettings();
                    }
                    if (this.isEmpty(settings)) {
                        settings.setType(type);
                        settings.setUseDocument(financeDocumentSettings.isUseDocument());
                        settings.setUseSettings(financeDocumentSettings.isUseSettings());
                        settings.setTemplate(financeDocumentSettings.getTemplate());
                        settings.setNumberPattern(financeDocumentSettings.getNumberPattern());
                        settings.setUseFacsimile(financeDocumentSettings.isUseFacsimile());
                        settings.getSignatures().clear();
                        settings.getSignatures().addAll(financeDocumentSettings.getSignatures());
                        settings.setStamp(financeDocumentSettings.getStamp());
                        this.getPaymentDocumentsProperties(profile).getPaymentDocumentsSettings().add(settings);
                    }
                    iterator.remove();
                    save = true;
                }
                if (save) {
                    profileContainer.getVersionInfo().setDataSource("FinanceDocumentSettingsMigrationTask");
                    EntityStorage.get().save(profileContainer, true);
                }
            }
            catch (Throwable e) {
                this.log.error(String.format("unable to migrate finance documents settings of organization file %s", profileTitle), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.FinanceDocumentSettingsMigrationTask_financeDocumentSettingsMigrationFailed, (Throwable)e, (Object[])new Object[]{profileTitle}));
            }
            uidIterator.remove();
        }
        callback.taskFinished();
        this.log.debug("finance documents settings migration finished");
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    private void updateUids() throws Exception {
        if (this.count != -1 && !this.toProceed.isEmpty()) {
            return;
        }
        LogicalStorage storage = LogicalStorage.get();
        LogicalEntityStorage entityStorage = storage.getEntityStorage();
        List uids = entityStorage.getEntityUids(this.getType(), null, null, true, true, SortOrder.DESC, null);
        this.toProceed.addAll(uids);
    }

    private PaymentDocumentType getType(FinanceDocumentType type) {
        if (type == FinanceDocumentType.CASH_ORDER) {
            return PaymentDocumentType.CREDIT_SLIP;
        }
        if (type == FinanceDocumentType.RECEIPT) {
            return PaymentDocumentType.DEBIT_SLIP;
        }
        return null;
    }

    private boolean isEmpty(PaymentDocumentSettings settings) {
        return !settings.isUseDocument() && !settings.isUseSettings() && settings.getTemplate() == null && TextUtil.isBlank((String)settings.getNumberPattern()) && !settings.isUseFacsimile() && settings.getSignatures().size() == 0 && settings.getStamp() == null;
    }

    protected abstract Class<T> getType();

    protected abstract FinanceDocumentsProperties getFinanceDocumentsProperties(T var1);

    protected abstract PaymentDocumentsProperties getPaymentDocumentsProperties(T var1);
}

