/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.IrrelevanceTolerantEntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.StorageQuery;
import com.gridnine.xtrip.common.search.utils.DynamicCriterionsHelper;
import com.gridnine.xtrip.common.search.utils.DynamicFieldsConstants;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class BaseQueryObjectsTask<T extends Serializable & XSerializable>
implements LongRunningTask<T> {
    protected static final String PROGRESS_UPDATE = "\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0438\u0437 {1}";
    private static final String COLLECTING_REFERENCES = "c\u043e\u0431\u0438\u0440\u0430\u0435\u043c \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u044b \u0442\u0438\u043f\u0430 {0}";
    private static final String ERROR_OCCURRED = "\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 {0}";
    private static final String COUNT_ALLIAS = "itemsCount";
    protected static final String MIN_DATE_ALLIAS = "minDateAllias";
    protected static final String MAX_DATE_ALLIAS = "maxDateAllias";
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile boolean toBeStopped = false;
    protected int maxErrors = 100;
    protected final AtomicInteger errorsCount = new AtomicInteger(0);
    private volatile AtomicInteger processed = new AtomicInteger(0);
    private volatile int lastProgress = 0;
    private volatile Date lastDate = new Date();
    public T config;

    protected boolean isSearchIrrelevanceTolerant() {
        return false;
    }

    @Override
    public void configure(T configuration) throws Exception {
        this.config = configuration;
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeObject((Element)elm, (String)"config", this.config);
    }

    public void fromXML(Element elm) throws Exception {
        this.config = (Serializable)XHelper.readObject((Element)elm, (String)"config");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processObjects(final String className, final LongRunningTask.EventsCallback eventsCallback, final ProcessCallback processCallback) throws Exception {
        if (this.errorsCount.get() > this.maxErrors || this.isToBeStopped()) {
            this.log.debug("interrupted");
            return;
        }
        this.log.debug(String.format("preparing date intervals for object %s", className));
        final Class objectClass = XHelper.getClass((String)className);
        eventsCallback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)COLLECTING_REFERENCES, (Object[])new Object[]{className}));
        ProjectionQuery query = new ProjectionQuery();
        this.updateQuery((StorageQuery)query, processCallback.getCriterions(objectClass));
        query.getProjections().add(Projection.min((String)"modified", (String)MIN_DATE_ALLIAS));
        query.getProjections().add(Projection.max((String)"modified", (String)MAX_DATE_ALLIAS));
        ProjectionResult sr = null;
        if (BaseAsset.class.isAssignableFrom(objectClass)) {
            sr = AssetsStorage.get().search(objectClass, query);
        } else {
            EntityStorageSearchParameters params = this.isSearchIrrelevanceTolerant() ? IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS : new EntityStorageSearchParameters();
            sr = EntityStorage.get().search(objectClass, query, params);
        }
        Date minDate = sr.getDate(MIN_DATE_ALLIAS);
        Date maxDate = sr.getDate(MAX_DATE_ALLIAS);
        if (minDate == null || maxDate == null) {
            return;
        }
        maxDate = new Date(maxDate.getTime() + 1L);
        long duration = Duration.between(minDate.toInstant(), maxDate.toInstant()).toMinutes();
        int step = duration < 2880L ? 11 : (duration < 89280L ? 5 : 2);
        ArrayList<DateInterval> dates = new ArrayList<DateInterval>();
        Date currentDate = minDate;
        Calendar cal = Calendar.getInstance();
        while (currentDate.compareTo(maxDate) < 0) {
            cal.setTime(currentDate);
            cal.add(step, 1);
            dates.add(new DateInterval(currentDate, cal.getTime()));
            currentDate = cal.getTime();
        }
        this.log.debug(String.format("got %s date intervals for object %s", Integer.toString(dates.size()), className));
        int threadsCount = processCallback.getThreadsCount();
        final String user = LogicalStorage.get().getUser();
        final Locale currentLocale = LocaleManager.get().getCurrentLocale();
        ExecutorServiceFacade service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool(threadsCount > 0 ? threadsCount : 1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(processCallback.getThreadPrefix() + "-" + Math.round(100.0 * Math.random()));
                return thread;
            }
        });
        try {
            final Set updatedUids = Collections.newSetFromMap(new ConcurrentHashMap());
            ArrayList<Future> futures = new ArrayList<Future>();
            for (final DateInterval interval : dates) {
                if (this.errorsCount.get() > this.maxErrors || this.isToBeStopped()) {
                    return;
                }
                futures.add(service.submit((Callable)new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        if (BaseQueryObjectsTask.this.errorsCount.get() > BaseQueryObjectsTask.this.maxErrors || BaseQueryObjectsTask.this.isToBeStopped()) {
                            return null;
                        }
                        if (LocaleManager.get().getCurrentLocale() == null) {
                            LocaleManager.get().setCurrentLocale(currentLocale);
                        }
                        if (LogicalStorage.get().getUser() == null) {
                            LogicalStorage.get().setUser(user);
                        }
                        BaseQueryObjectsTask.this.log.debug(String.format("processing object %s for date interval %s", className, interval));
                        ProjectionQuery query2 = new ProjectionQuery();
                        BaseQueryObjectsTask.this.updateQuery((StorageQuery)query2, processCallback.getCriterions(objectClass));
                        query2.getCriteria().getCriterions().add(SearchCriterion.ge((String)"modified", (Object)interval.getBeginDate()));
                        query2.getCriteria().getCriterions().add(SearchCriterion.lt((String)"modified", (Object)interval.getEndDate()));
                        query2.getProjections().addAll(processCallback.getProjections(objectClass));
                        List data = null;
                        data = BaseAsset.class.isAssignableFrom(objectClass) ? AssetsStorage.get().search(objectClass, query2).getData() : EntityStorage.get().search(objectClass, query2).getData();
                        BaseQueryObjectsTask.this.log.debug(String.format("got %s objects of type %s for date interval %s", Integer.toString(data.size()), className, interval));
                        for (Map obj : data) {
                            if (BaseQueryObjectsTask.this.errorsCount.get() > BaseQueryObjectsTask.this.maxErrors || BaseQueryObjectsTask.this.isToBeStopped()) {
                                return null;
                            }
                            String uid = processCallback.getUid(obj);
                            if (updatedUids.contains(uid)) {
                                BaseQueryObjectsTask.this.log.debug(String.format("object with uid %s was already deleted", uid));
                                continue;
                            }
                            try {
                                processCallback.processObject(objectClass, obj);
                            }
                            catch (Throwable t) {
                                BaseQueryObjectsTask.this.log.error(String.format("unable to process object %s uid = %s", className, uid), t);
                                eventsCallback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)BaseQueryObjectsTask.ERROR_OCCURRED, (Throwable)t, (Object[])new Object[]{t.getMessage()}));
                                BaseQueryObjectsTask.this.errorsCount.addAndGet(1);
                            }
                            finally {
                                updatedUids.add(uid);
                                BaseQueryObjectsTask.this.incrementAndUpdateProgress(eventsCallback, className, processCallback.getTotalCount());
                            }
                        }
                        return null;
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            service.dispose();
        }
    }

    protected synchronized void incrementAndUpdateProgress(LongRunningTask.EventsCallback callback, String clsName, int totalCount) {
        this.processed.incrementAndGet();
        int newProgress = (int)Math.round(100.0 * (double)this.processed.get() / (double)totalCount);
        Date currentDate = new Date();
        if (currentDate.getTime() - this.lastDate.getTime() < 300000L) {
            return;
        }
        this.lastDate = currentDate;
        if (newProgress > this.lastProgress) {
            this.lastProgress = newProgress;
            callback.updateProgress((byte)newProgress);
        }
        callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)PROGRESS_UPDATE, (Object[])new Object[]{this.processed.get(), totalCount}));
    }

    protected <E> int count(ProcessCallback clb, Class<E> clazz) {
        ProjectionQuery query = new ProjectionQuery();
        this.updateQuery((StorageQuery)query, clb.getCriterions(clazz));
        query.getProjections().add(Projection.count((String)"uid", (String)COUNT_ALLIAS));
        if (BaseAsset.class.isAssignableFrom(clazz)) {
            Class<E> assetCls = clazz;
            return AssetsStorage.get().search(assetCls, query).getInt(COUNT_ALLIAS);
        }
        Class<E> assetCls = clazz;
        return EntityStorage.get().search(assetCls, query).getInt(COUNT_ALLIAS);
    }

    public void updateQuery(StorageQuery query, List<SearchCriterion> criterions) {
        HashMap<String, Date> dynamicParams = new HashMap<String, Date>();
        query.getCriteria().getCriterions().addAll(criterions);
        dynamicParams.put(DynamicFieldsConstants.NOW.name(), new Date());
        DynamicCriterionsHelper.updateQuery((StorageQuery)query, dynamicParams);
    }

    protected abstract void doJob(LongRunningTask.EventsCallback var1) throws Exception;

    @Override
    public void start(LongRunningTask.EventsCallback callback) throws Exception {
        this.doJob(callback);
    }

    @Override
    public void stop() throws Exception {
        this.toBeStopped = true;
    }

    @Override
    public void abort() throws Exception {
        this.stop();
    }

    protected boolean isToBeStopped() {
        return this.toBeStopped;
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean isDeleteAfterStop() {
        return false;
    }

    @Override
    public int getStopTimeoutInSeconds() {
        return 10;
    }

    public static interface ProcessCallback {
        public int getThreadsCount();

        public int getTotalCount();

        public void processObject(Class<?> var1, Map<String, String> var2) throws Exception;

        public String getUid(Map<String, String> var1);

        public Collection<? extends Projection> getProjections(Class<?> var1);

        public String getThreadPrefix();

        public List<SearchCriterion> getCriterions(Class<?> var1);
    }
}

