/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class BillingItemsUpdateTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.BillingItemsUpdateTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("billing items update started");
        SearchQuery query = new SearchQuery();
        Set shipmentReferences = EntityStorage.get().search(ShipmentIndex.class, query).getData().stream().map(item -> item.getSource()).collect(Collectors.toSet());
        int count = shipmentReferences.size();
        int n = 0;
        for (EntityReference shipmentReference : shipmentReferences) {
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            byte progress = (byte)(100 * n / count);
            this.log.debug(String.format("processing shipment %s, %s of %s (%s%%)", shipmentReference, String.valueOf(n), String.valueOf(count), String.valueOf(progress)));
            if (n % 10 == 0) {
                callback.updateProgress(progress);
            }
            EntityStorageContext storageContext = EntityStorageHelper.createContext();
            EntityContainer shipmentContainer = EntityStorage.get().resolve(shipmentReference);
            if (shipmentContainer == null) continue;
            Map<EntityContainer<BillingItemsList>, Collection<BillingItem>> billingItemsListsGroups = FinanceDocumentHelper.getBillingItemsLists(((Shipment)shipmentContainer.getEntity()).getBillingItems(), storageContext);
            for (Map.Entry<EntityContainer<BillingItemsList>, Collection<BillingItem>> billingItemsListsGroup : billingItemsListsGroups.entrySet()) {
                EntityContainer<BillingItemsList> billingItemsListContainer = billingItemsListsGroup.getKey();
                Collection<BillingItem> billingItems = billingItemsListsGroup.getValue();
                boolean save = false;
                for (BillingItem billingItem : billingItems) {
                    if (billingItem.getShipment() != null) continue;
                    billingItem.setShipment(shipmentContainer.toReference());
                    save = true;
                }
                if (!save) continue;
                billingItemsListContainer.getVersionInfo().setDataSource("billing-items-update-task");
                EntityStorage.get().save(billingItemsListContainer, true);
            }
        }
        callback.taskFinished();
        this.log.debug("billing items update finished");
    }
}

