/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MultiThread;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Element;

public class BillingTransactionContractTypeUpdateTask
extends BaseLongRunningTask<Serializable> {
    final Set<String> toProceed = new LinkedHashSet<String>();
    volatile AtomicInteger n = new AtomicInteger(0);

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.BillingTransactionContractTypeUpdateTask_addContractTypeTransaction, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        for (Element element : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(element.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(final LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("billing transaction contract type update started");
        this.updateUids();
        final int count = this.toProceed.size();
        this.log.debug(String.format("uids updated, remains " + count, new Object[0]));
        MultiThread.execute((String)this.getClass().getName(), (int)5, (int)100, this.toProceed, (MultiThread.Task)new MultiThread.Task<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void doJob(Collection<String> argSubset) {
                try {
                    LogicalStorage.get().authorizeAsSystem();
                    Iterator<String> iterator = argSubset.iterator();
                    while (iterator.hasNext()) {
                        String item;
                        block19: {
                            item = iterator.next();
                            if (BillingTransactionContractTypeUpdateTask.this.isToBeStopped()) {
                                BillingTransactionContractTypeUpdateTask.this.log.debug("task is interrupted");
                                return;
                            }
                            BillingTransactionContractTypeUpdateTask.this.n.incrementAndGet();
                            String billingTransactionTitle = item;
                            try {
                                EntityContainer clientContainer;
                                BookingFile bookingFile;
                                EntityContainer bookingFileContainer;
                                EntityContainer billingTransactionContainer = EntityStorage.get().load(BillingTransaction.class, item);
                                if (billingTransactionContainer == null) break block19;
                                BillingTransaction billingTransaction = (BillingTransaction)billingTransactionContainer.getEntity();
                                billingTransactionTitle = billingTransaction.toString();
                                byte progress = (byte)(100 * BillingTransactionContractTypeUpdateTask.this.n.get() / count);
                                BillingTransactionContractTypeUpdateTask.this.log.debug(String.format("processing billing transaction %s, %s of %s (%s%%)", billingTransactionTitle, String.valueOf(BillingTransactionContractTypeUpdateTask.this.n), String.valueOf(count), String.valueOf(progress)));
                                if (BillingTransactionContractTypeUpdateTask.this.n.get() % 10 == 0) {
                                    callback.updateProgress(progress);
                                }
                                ContractType contractType = billingTransaction.getContractType();
                                EntityReference clientReference = billingTransaction.getClient();
                                if (contractType != null || clientReference == null) break block19;
                                EntityReference entity = billingTransaction.getEntity();
                                if (entity != null && entity.getType().getName().equals(BookingFile.class.getName()) && (bookingFileContainer = EntityStorage.get().resolve(entity)) != null && (bookingFile = (BookingFile)bookingFileContainer.getEntity()).getCustomerProfile() != null && bookingFile.getCustomerProfile().equals((Object)clientReference)) {
                                    contractType = ContractType.CLIENT;
                                }
                                if (contractType == null && clientReference.getType().getName().equals(Organization.class.getName()) && (clientContainer = EntityStorage.get().resolve(clientReference)) != null) {
                                    Set types = ((Organization)clientContainer.getEntity()).getTypes();
                                    if (types.contains(OrganizationType.AGENCY) && !types.contains(OrganizationType.CORPORATE_CLIENT)) {
                                        contractType = ContractType.SUBAGENCY;
                                    } else if (types.contains(OrganizationType.CORPORATE_CLIENT)) {
                                        contractType = ContractType.CLIENT;
                                    }
                                }
                                if (contractType != null) {
                                    billingTransaction.setContractType(contractType);
                                    billingTransactionContainer.getVersionInfo().setDataSource("billing-transaction-contract-type-update-task");
                                    EntityStorage.get().save(billingTransactionContainer, true);
                                }
                            }
                            catch (Throwable e) {
                                BillingTransactionContractTypeUpdateTask.this.log.error(String.format("unable to update billiung transaction %s", billingTransactionTitle), e);
                                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 {0}", (Throwable)e, (Object[])new Object[]{billingTransactionTitle}));
                            }
                        }
                        Set<String> set = BillingTransactionContractTypeUpdateTask.this.toProceed;
                        synchronized (set) {
                            BillingTransactionContractTypeUpdateTask.this.toProceed.remove(item);
                        }
                    }
                    return;
                }
                catch (Exception ex) {
                    throw new RuntimeException("authorization failed", ex);
                }
                finally {
                    LogicalStorage.reset();
                }
            }
        });
        callback.taskFinished();
        this.log.debug("billing transaction contract type update finished");
    }

    private void updateUids() throws Exception {
        if (!this.toProceed.isEmpty()) {
            return;
        }
        LogicalStorage storage = LogicalStorage.get();
        LogicalEntityStorage entityStorage = storage.getEntityStorage();
        List uids = entityStorage.getEntityUids(BillingTransaction.class, null, null, true, true, SortOrder.DESC, null);
        this.toProceed.addAll(uids);
    }
}

