/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MultiThread;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Element;

public class BillingTransactionStatusUpdateTask
extends BaseLongRunningTask<Serializable> {
    final Set<String> toProceed = new LinkedHashSet<String>();
    volatile AtomicInteger n = new AtomicInteger(0);

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.BillingTransactionStatusUpdateTask_addStatusTransaction, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        for (Element element : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(element.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(final LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("billing transaction status update started");
        this.updateUids();
        final int count = this.toProceed.size();
        this.log.debug(String.format("uids updated, remains " + count, new Object[0]));
        MultiThread.execute((String)this.getClass().getName(), (int)5, (int)100, this.toProceed, (MultiThread.Task)new MultiThread.Task<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void doJob(Collection<String> argSubset) {
                try {
                    LogicalStorage.get().authorizeAsSystem();
                    Iterator<String> iterator = argSubset.iterator();
                    while (iterator.hasNext()) {
                        String item;
                        block14: {
                            item = iterator.next();
                            if (BillingTransactionStatusUpdateTask.this.isToBeStopped()) {
                                BillingTransactionStatusUpdateTask.this.log.debug("task is interrupted");
                                return;
                            }
                            BillingTransactionStatusUpdateTask.this.n.incrementAndGet();
                            String billingTransactionTitle = item;
                            try {
                                BillingTransactionStatus status;
                                EntityContainer billingTransactionContainer = EntityStorage.get().load(BillingTransaction.class, item);
                                if (billingTransactionContainer == null) break block14;
                                BillingTransaction billingTransaction = (BillingTransaction)billingTransactionContainer.getEntity();
                                billingTransactionTitle = billingTransaction.toString();
                                byte progress = (byte)(100 * BillingTransactionStatusUpdateTask.this.n.get() / count);
                                BillingTransactionStatusUpdateTask.this.log.debug(String.format("processing billing transaction %s, %s of %s (%s%%)", billingTransactionTitle, String.valueOf(BillingTransactionStatusUpdateTask.this.n), String.valueOf(count), String.valueOf(progress)));
                                if (BillingTransactionStatusUpdateTask.this.n.get() % 100 == 0) {
                                    callback.updateProgress(progress);
                                }
                                if ((status = billingTransaction.getStatus()) == null) {
                                    billingTransaction.setStatus(BillingTransactionStatus.ACTIVE);
                                    billingTransactionContainer.getVersionInfo().setDataSource("billing-transaction-status-update-task");
                                    EntityStorage.get().save(billingTransactionContainer, true);
                                }
                            }
                            catch (Throwable e) {
                                BillingTransactionStatusUpdateTask.this.log.error(String.format("unable to update billing transaction %s", billingTransactionTitle), e);
                                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 {0}", (Throwable)e, (Object[])new Object[]{billingTransactionTitle}));
                            }
                        }
                        Set<String> set = BillingTransactionStatusUpdateTask.this.toProceed;
                        synchronized (set) {
                            BillingTransactionStatusUpdateTask.this.toProceed.remove(item);
                        }
                    }
                    return;
                }
                catch (Exception ex) {
                    throw new RuntimeException("authorization failed", ex);
                }
                finally {
                    LogicalStorage.reset();
                }
            }
        });
        callback.taskFinished();
        this.log.debug("billing transaction status update finished");
    }

    private void updateUids() throws Exception {
        if (!this.toProceed.isEmpty()) {
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.status.name(), null));
        List indexes = EntityStorage.get().search(BillingTransactionIndex.class, query).getData();
        for (BillingTransactionIndex index : indexes) {
            this.toProceed.add(index.getSource().getUid());
        }
    }
}

