/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingTransactionsCreateTaskConfiguration;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.interceptors.BillingTransactionsInterceptor;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseQueryObjectsTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BillingTransactionsCreateTask
extends BaseQueryObjectsTask<BillingTransactionsCreateTaskConfiguration> {
    private static final List<ContractType> contractTypes = new ArrayList<ContractType>();
    private int totalCount;

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)MetaRegistryHelper.getEntityType((String)BillingTransactionsCreateTaskConfiguration.class.getName()).getDisplayName(), (Object[])new Object[0]);
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.billingTransactionsCreateTask_threadsCount, (Object[])new Object[]{String.valueOf(((BillingTransactionsCreateTaskConfiguration)this.config).getThreadsCount())}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.billingTransactionsCreateTask_bookingFilesCountStart, (Object[])new Object[0]));
        this.totalCount = this.count(this.createCallback(), BookingFileIndex.class);
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.billingTransactionsCreateTask_bookingFilesProcessCompleted, (Object[])new Object[]{this.totalCount}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.billingTransactionsCreateTask_bookingFilesProcessStart, (Object[])new Object[0]));
        this.processObjects(BookingFileIndex.class.getName(), callback, this.createCallback());
        callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.billingTransactionsCreateTask_bookingFilesProcessComplete, (Object[])new Object[]{this.totalCount}));
        callback.updateProgress((byte)100);
        callback.taskFinished();
    }

    private BaseQueryObjectsTask.ProcessCallback createCallback() {
        return new BaseQueryObjectsTask.ProcessCallback(){
            private static final String UID = "uid";

            @Override
            public String getThreadPrefix() {
                return "billing-transactions-create-task";
            }

            @Override
            public int getThreadsCount() {
                return ((BillingTransactionsCreateTaskConfiguration)BillingTransactionsCreateTask.this.config).getThreadsCount();
            }

            @Override
            public int getTotalCount() {
                return BillingTransactionsCreateTask.this.totalCount;
            }

            @Override
            public Collection<? extends Projection> getProjections(Class<?> cls) {
                return Collections.singleton(Projection.property((String)"containerUid", (String)UID));
            }

            @Override
            public List<SearchCriterion> getCriterions(Class<?> objectClass) {
                return Collections.emptyList();
            }

            @Override
            public String getUid(Map<String, String> object) {
                return object.get(UID);
            }

            @Override
            public void processObject(Class<?> type, Map<String, String> object) throws Exception {
                String uid = object.get(UID);
                EntityContainer bookingFileContainer = EntityStorage.get().load(BookingFile.class, uid);
                if (bookingFileContainer != null) {
                    BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
                    List<EntityContainer<BillingTransaction>> transactions = BillingTransactionsInterceptor.createProductTransactions((EntityContainer<BookingFile>)bookingFileContainer);
                    for (ContractType contractType : contractTypes) {
                        boolean transactionsExists = this.isTransactionsExists((EntityReference<BookingFile>)bookingFileContainer.toReference(), contractType);
                        if (!transactionsExists) {
                            for (EntityContainer<BillingTransaction> transaction : transactions) {
                                if (((BillingTransaction)transaction.getEntity()).getContractType() != contractType) continue;
                                EntityStorage.get().save(transaction, true);
                            }
                            BillingTransactionsCreateTask.this.log.debug(String.format("transactions for booking file %s of contract type %s were created successfully", bookingFile, contractType));
                            continue;
                        }
                        BillingTransactionsCreateTask.this.log.debug(String.format("transactions for booking file %s of cntract type %s already exists", bookingFile, contractType));
                    }
                } else {
                    BillingTransactionsCreateTask.this.log.warn(String.format("fialed loading booking file with uid %s", uid));
                }
            }

            private boolean isTransactionsExists(EntityReference<BookingFile> bookingFile, ContractType contractType) {
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.referencedEntity.name(), bookingFile));
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.contractType.name(), (Object)contractType));
                return EntityStorage.get().search(BillingTransactionIndex.class, query).getData().size() > 0;
            }
        };
    }

    static {
        contractTypes.add(ContractType.VENDOR);
    }
}

