/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.profile.TripartiteContractType;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.tripartite.AviaTripartiteContractActions;
import com.gridnine.xtrip.common.model.rules.tripartite.CarTripartiteContractActions;
import com.gridnine.xtrip.common.model.rules.tripartite.HotelTripartiteContractActions;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import org.w3c.dom.Element;

public class CalculationIndicatorMigrationTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.CalculationIndicatorMigrationTask_updateContracts, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        for (EntityReference ctrRef : StorageHelper.getEntityReferences((SearchQuery)new SearchQuery(), TripartiteContractIndex.class)) {
            if (this.isToBeStopped()) {
                this.log.debug("task is interupted");
                return;
            }
            this.log.debug("updating tripartite contract " + ctrRef);
            try {
                EntityContainer ctr = EntityStorage.get().resolve(ctrRef);
                boolean alreadyHasARule = false;
                block3: for (RuleSettings rs : ((TripartiteContract)ctr.getEntity()).getRuleSet().getRules()) {
                    for (RuleResult rr : rs.getResults()) {
                        if (rr.getValue() == null || !AviaTripartiteContractActions.AVIA_CALCULATION_INDICATOR.equals((Object)rr.getAction()) && !HotelTripartiteContractActions.HOTEL_CALCULATION_INDICATOR.equals((Object)rr.getAction()) && !CarTripartiteContractActions.CAR_CALCULATION_INDICATOR.equals((Object)rr.getAction())) continue;
                        alreadyHasARule = true;
                        break block3;
                    }
                }
                if (!alreadyHasARule && ((TripartiteContract)ctr.getEntity()).getCalculationIndicator() != null) {
                    RuleSettings rs = new RuleSettings();
                    RuleResult rr = new RuleResult();
                    if (((TripartiteContract)ctr.getEntity()).getType() == TripartiteContractType.AVIA) {
                        rr.setAction((RuleAction)AviaTripartiteContractActions.AVIA_CALCULATION_INDICATOR);
                        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
                    } else if (((TripartiteContract)ctr.getEntity()).getType() == TripartiteContractType.HOTEL) {
                        rr.setAction((RuleAction)HotelTripartiteContractActions.HOTEL_CALCULATION_INDICATOR);
                        rs.setTarget((RuleTarget)Targets.HOTELS_FOREIGN);
                    } else if (((TripartiteContract)ctr.getEntity()).getType() == TripartiteContractType.CAR) {
                        rr.setAction((RuleAction)CarTripartiteContractActions.CAR_CALCULATION_INDICATOR);
                        rs.setTarget((RuleTarget)Targets.CAR);
                    }
                    rr.setValue((Object)((TripartiteContract)ctr.getEntity()).getCalculationIndicator());
                    rs.getResults().add(rr);
                    ((TripartiteContract)ctr.getEntity()).getRuleSet().getRules().add(rs);
                    ctr.getVersionInfo().setDataSource("server-task");
                    ctr.getVersionInfo().setVersionNotes("modified by task " + MiscUtil.getSimpleClassName(this.getClass()));
                    EntityStorage.get().save(ctr, true);
                }
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.ContractMigrationTask_processedContract, (Object[])new Object[]{ctrRef}));
            }
            catch (Throwable e) {
                this.log.error("unable to update contract " + ctrRef, e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ContractMigrationTask_errorProcessingContract, (Throwable)e, (Object[])new Object[]{ctrRef}));
            }
        }
        callback.taskFinished();
    }
}

