/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class CancellationDetailsMigrationTask
extends BaseLongRunningTask<Serializable> {
    private int count = -1;
    private final Set<String> toProceed = new LinkedHashSet<String>();

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.CancellationDetailsMigrationTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        Element countElement = XmlUtil.getElement((Element)elm, (String)"count");
        if (countElement != null) {
            this.count = Integer.parseInt(countElement.getAttribute("value"));
        }
        for (Element itemElement : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(itemElement.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        Element countElement = XmlUtil.addElement((Element)elm, (String)"count");
        countElement.setAttribute("value", String.valueOf(this.count));
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("cancellation details migration started");
        this.updateUids();
        if (this.count == -1) {
            this.count = this.toProceed.size();
        }
        int n = this.count - this.toProceed.size();
        this.log.debug(String.format(String.format("uids updated, processed: %s, total: %s", String.valueOf(n), String.valueOf(this.count)), new Object[0]));
        Iterator<String> uidIterator = this.toProceed.iterator();
        while (uidIterator.hasNext()) {
            String uid = uidIterator.next();
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            ++n;
            String bookingFileTitle = uid;
            try {
                EntityContainer bookingFileContainer = EntityStorage.get().load(BookingFile.class, uid);
                if (bookingFileContainer == null) continue;
                BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
                bookingFileTitle = bookingFile.toString();
                byte progress = (byte)(100 * n / this.count);
                this.log.debug(String.format("processing booking file %s, %s of %s (%s%%)", bookingFileTitle, String.valueOf(n), String.valueOf(this.count), String.valueOf(progress)));
                if (n % 10 == 0) {
                    callback.updateProgress(progress);
                }
                boolean save = false;
                for (Reservation reservation : bookingFile.getReservations()) {
                    for (BaseProduct baseProduct : reservation.getProducts()) {
                        String productTitle = baseProduct.getUid();
                        ProductHandler productHandler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                        if (productHandler != null) {
                            productTitle = productHandler.generateShortProductName(baseProduct);
                            this.log.debug(String.format("processing product %s", productTitle));
                            ProductCancellationDetails cancellationDetails = null;
                            BaseProduct cancelProduct = baseProduct;
                            while (productHandler.getPreviousProduct(cancelProduct) != null) {
                                cancelProduct = productHandler.getPreviousProduct(cancelProduct);
                            }
                            while (cancelProduct != null) {
                                if (productHandler.getCancellationDetails(cancelProduct) != null) {
                                    cancellationDetails = productHandler.getCancellationDetails(cancelProduct);
                                    break;
                                }
                                cancelProduct = productHandler.getNextProduct(cancelProduct);
                            }
                            if (cancellationDetails == null || cancellationDetails.getDate() == null || cancellationDetails.getAgent() == null) continue;
                            ArrayList<XCloneable> fops = new ArrayList<XCloneable>();
                            for (GeneralProductFop generalProductFop : GeneralProductHelper.getUnmodifiableFops((BaseProduct)baseProduct, (ContractType)ContractType.CLIENT)) {
                                if (generalProductFop.getEquivalentAmount() == null || generalProductFop.getOperationDate() != null || generalProductFop.isRefused()) continue;
                                fops.add(XCloneHelper.clone((XCloneable)generalProductFop));
                            }
                            for (GeneralProductFop generalProductFop : fops) {
                                generalProductFop.setOperationDate(cancellationDetails.getDate());
                                generalProductFop.setAgent(cancellationDetails.getAgent());
                                generalProductFop.setRefused(true);
                            }
                            if (fops.size() <= 0) continue;
                            GeneralProductHelper.updateFops((BaseProduct)baseProduct, (ContractType)ContractType.CLIENT, fops);
                            save = true;
                            continue;
                        }
                        this.log.debug(String.format("unable to handle %s", productTitle));
                    }
                }
                if (save) {
                    EntityStorage.get().save(bookingFileContainer, true);
                }
            }
            catch (Throwable e) {
                this.log.error(String.format("unable to migrate product cancellation details of booking file %s", bookingFileTitle), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CancellationDetailsMigrationTask_cancellationDetailsMigrationFailed, (Throwable)e, (Object[])new Object[]{bookingFileTitle}));
            }
            uidIterator.remove();
        }
        callback.taskFinished();
        this.log.debug("cancellation details migration finished");
    }

    private void updateUids() throws Exception {
        if (this.count != -1 && !this.toProceed.isEmpty()) {
            return;
        }
        LogicalEntityStorage entityStorage = LogicalStorage.get().getEntityStorage();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.cancellationDate.name(), null));
        query.getPreferredProperties().add("uid");
        for (CommonProductIndex index : entityStorage.search(CommonProductIndex.class, query).getData()) {
            String uid = index.getSource().getUid();
            if (this.toProceed.contains(uid)) continue;
            this.toProceed.add(uid);
        }
    }
}

