/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.CheckBookingTransactionTaskConfiguration;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.interceptors.BillingTransactionsInterceptor;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;

public class CheckBookingTransactionTask
extends BaseLongRunningTask<CheckBookingTransactionTaskConfiguration> {
    private CheckBookingTransactionTaskConfiguration config;

    @Override
    public void configure(CheckBookingTransactionTaskConfiguration configuration) throws Exception {
        this.config = configuration;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.CheckBookingTransactionTask_description, (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("task started");
        boolean successfully = false;
        try {
            EntityContainer first;
            List uids;
            Date now = new Date();
            LogicalEntityStorage entityStorage = LogicalStorage.get().getEntityStorage();
            int hours = this.config.getHours();
            if (hours <= 0 && (uids = entityStorage.getEntityUids(BookingFile.class, null, null, true, false, SortOrder.DESC, Integer.valueOf(1))) != null && uids.size() > 0 && (first = EntityStorage.get().load(BookingFile.class, (String)uids.get(0))) != null) {
                long delta = now.getTime() - first.getCreated().getTime();
                hours = (int)(delta / 3600000L);
                if (delta % 3600000L != 0L) {
                    ++hours;
                }
            }
            byte progress = -1;
            for (int i = 0; i < hours; ++i) {
                if (100 * i / hours >= progress + 1) {
                    progress = (byte)(100 * i / hours);
                    callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u0438\u0437 {1} \u0447\u0430\u0441\u043e\u0432", (Object[])new Object[]{i, hours}));
                    callback.updateProgress(progress);
                }
                Calendar dateFrom = Calendar.getInstance();
                dateFrom.setTime(now);
                dateFrom.add(11, -i - 1);
                Calendar dateTo = Calendar.getInstance();
                dateTo.setTime(now);
                dateTo.add(11, -i);
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BookingFileIndex.Property.createDate.name(), (Object)dateFrom.getTime()));
                query.getCriteria().getCriterions().add(SearchCriterion.lt((String)BookingFileIndex.Property.createDate.name(), (Object)dateTo.getTime()));
                query.getCriteria().getOrders().put(BookingFileIndex.Property.createDate.name(), SortOrder.DESC);
                SearchResult searchResult = entityStorage.search(BookingFileIndex.class, query);
                for (BookingFileIndex index : searchResult.getData()) {
                    EntityContainer booking = EntityStorage.get().resolve(index.getSource());
                    if (booking == null) continue;
                    this.checkBooking(entityStorage, (EntityContainer<BookingFile>)booking, callback);
                }
            }
            callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u0438\u0437 {1} \u0447\u0430\u0441\u043e\u0432", (Object[])new Object[]{hours, hours}));
            callback.updateProgress((byte)100);
            successfully = true;
        }
        finally {
            if (!successfully) {
                try {
                    this.stop();
                }
                catch (Exception e) {
                    this.log.error("unable to stop task", (Throwable)e);
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Object[])new Object[0]));
                }
            }
        }
        callback.taskFinished();
        this.log.debug("task finished");
    }

    private void checkBooking(LogicalEntityStorage entityStorage, EntityContainer<BookingFile> booking, LongRunningTask.EventsCallback callback) throws Exception {
        List<EntityContainer<BillingTransaction>> must = BillingTransactionsInterceptor.createProductTransactions(booking);
        SearchQuery query = BillingTransactionsInterceptor.createAutoCreatedTransactionsSearchQuery((EntityReference<? extends BaseEntity>)booking.toReference());
        SearchResult searchResult = entityStorage.search(BillingTransactionIndex.class, query);
        ArrayList<EntityContainer<BillingTransaction>> have = new ArrayList<EntityContainer<BillingTransaction>>(searchResult.getData().size());
        for (BillingTransactionIndex index : searchResult.getData()) {
            EntityContainer transaction = EntityStorage.get().resolve(index.getSource());
            if (transaction == null) continue;
            have.add((EntityContainer<BillingTransaction>)transaction);
        }
        if (!BillingTransactionsInterceptor.isChanged(must, have)) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("found difference for %s,\nactual: \n %s, \nexpected: \n%s", ((BookingFile)booking.getEntity()).getNumber(), this.getDescription(have), this.getDescription(must)));
        }
        if (this.config.isRecover()) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0418\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439 \u043f\u043e \u0437\u0430\u043a\u0430\u0437\u0443 {0} (uid: {1})", (Object[])new Object[]{((BookingFile)booking.getEntity()).toString(), booking.getUid()}));
            BillingTransactionsInterceptor.deleteBillingTransactions(booking, false, "check task");
            BillingTransactionsInterceptor.saveBillingTransactions(booking, must, false, "check task");
        } else {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u043f\u043e \u0437\u0430\u043a\u0430\u0437\u0443 {0} (uid: {1})", (Object[])new Object[]{((BookingFile)booking.getEntity()).toString(), booking.getUid()}));
        }
    }

    private String getDescription(List<EntityContainer<BillingTransaction>> coll) {
        StringBuilder sb = new StringBuilder();
        for (EntityContainer<BillingTransaction> item : coll) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(this.getDescription((BillingTransaction)item.getEntity()));
        }
        return sb.toString();
    }

    private String getDescription(BillingTransaction billingTransaction) {
        return String.format("sum=%s, contractType=%s, client=%s, agency=%s, description=%s, agent=%s, category=%s, date=%s, details=%s, parent=%s, paymentType=%s, finDocNumber=%s, finDocDate=%s, type=%s, status=%s", billingTransaction.getSum() != null && billingTransaction.getSum().getValue() != null ? billingTransaction.getSum().getValue().toString() : "null", billingTransaction.getContractType() != null ? billingTransaction.getContractType().name() : "null", billingTransaction.getClient() != null ? billingTransaction.getClient().getUid() + " (" + String.valueOf(billingTransaction.getClient().getCaption()) + ")" : "null", billingTransaction.getAgency() != null ? billingTransaction.getAgency().getUid() + " (" + String.valueOf(billingTransaction.getAgency().getCaption()) + ")" : "null", String.valueOf(billingTransaction.getDescription()), billingTransaction.getAgent() != null ? billingTransaction.getAgent().getUid() + " (" + String.valueOf(billingTransaction.getAgent().getCaption()) + ")" : "null", billingTransaction.getCategory() != null ? billingTransaction.getCategory().name() : "null", String.valueOf(billingTransaction.getDate()), billingTransaction.getDetails() != null ? billingTransaction.getDetails().getUid() + " (" + String.valueOf(billingTransaction.getDetails().getTransactionCode()) + ")" : "null", billingTransaction.getParent() != null ? billingTransaction.getParent().getUid() + " (" + String.valueOf(billingTransaction.getParent().getCaption()) + ")" : "null", billingTransaction.getPaymentType() != null ? billingTransaction.getPaymentType().name() : "null", String.valueOf(billingTransaction.getFinDocNumber()), String.valueOf(billingTransaction.getFinDocDate()), billingTransaction.getType() != null ? billingTransaction.getType().name() : "null", billingTransaction.getStatus() != null ? billingTransaction.getStatus().name() : "null");
    }

    public void toXML(Element elm) throws Exception {
        this.config.toXML(elm);
    }

    public void fromXML(Element elm) throws Exception {
        this.config = new CheckBookingTransactionTaskConfiguration();
        this.config.fromXML(elm);
    }
}

