/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.CheckDuplicateIndexEntryTaskConfiguration;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class CheckDuplicateIndexEntryTask
extends BaseLongRunningTask<CheckDuplicateIndexEntryTaskConfiguration> {
    private CheckDuplicateIndexEntryTaskConfiguration config;
    private static final int FRAME = 1000;

    @Override
    public void configure(CheckDuplicateIndexEntryTaskConfiguration configuration) throws Exception {
        this.config = configuration;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.CheckDuplicateIndexEntryTask_description, (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("task started");
        boolean successfully = false;
        try {
            EntityStorage entityStorage = EntityStorage.get();
            Collection<Class<?>> types = this.getIndexTypeList();
            byte progress = -1;
            int stageStep = types.size() > 0 ? (int)(100 / types.size()) : 0;
            int stage = -1;
            block13: for (Class<?> clazz : types) {
                ++stage;
                if (this.isToBeStopped()) break;
                try {
                    try {
                        LogicalStorageRegistry.get().getIndexHandler(clazz);
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                    IndexType indexType = (IndexType)MetaRegistry.get().getIndexes().get(clazz.getName());
                    String indexName = indexType.getDisplayName();
                    SearchQuery query = new SearchQuery();
                    if (PersonIndex.class.isAssignableFrom(clazz)) {
                        query.getCriteria().getCriterions().add(SearchCriterion.not((SearchCriterion)SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.PASSENGER.name())));
                    }
                    query.setResultMode(ResultMode.COUNT_ONLY);
                    SearchResult result = entityStorage.search(clazz, query);
                    int totalCount = result.getTotalCount();
                    query.setResultMode(ResultMode.DATA_ONLY);
                    HashSet<String> repaired = new HashSet<String>();
                    query.setLimit(1000);
                    int top = 0;
                    long i = 0L;
                    block14: while (!this.isToBeStopped()) {
                        query.setOffset(top);
                        SearchResult result2 = entityStorage.search(clazz, query);
                        if (result2.getData().size() == 0) continue block13;
                        top += 1000;
                        for (EntityIndex data : result2.getData()) {
                            if (this.isToBeStopped()) continue block14;
                            try {
                                byte newProgress = (byte)((long)(stage * stageStep) + (long)stageStep * i / (long)totalCount);
                                if (newProgress > 100) {
                                    newProgress = 100;
                                }
                                if (newProgress >= progress + 1) {
                                    progress = newProgress;
                                    callback.addEvent("progress", MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.CheckDuplicateIndexEntryTask_processingIndex, (Object[])new Object[]{indexName, i, totalCount}));
                                    callback.updateProgress(progress);
                                }
                                ++i;
                                if (data.getSource() == null) continue;
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug(String.format("found duplicate index entries. Index: %s, entity uid: %s.", MiscUtil.getSimpleClassName(clazz), data.getSource().getUid()));
                                }
                                if (repaired.contains(data.getSource().getUid())) {
                                    callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.CheckDuplicateIndexEntryTask_foundDuplicate, (Object[])new Object[]{indexName, data.getSource().getUid()}));
                                    continue;
                                }
                                if (this.config.isRecover()) {
                                    callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.CheckDuplicateIndexEntryTask_foundDuplicate_reindex, (Object[])new Object[]{indexName, data.getSource().getUid()}));
                                    this.reindex(data.getSource());
                                } else {
                                    callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.CheckDuplicateIndexEntryTask_foundDuplicate, (Object[])new Object[]{indexName, data.getSource().getUid()}));
                                }
                                repaired.add(data.getSource().getUid());
                            }
                            catch (Exception e) {
                                if (this.config.isStopOnError()) {
                                    throw e;
                                }
                                this.log.error("error in task", (Throwable)e);
                                callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CheckDuplicateIndexEntryTask_errorProcessing, (Throwable)e, (Object[])new Object[]{clazz.getName(), e.toString()}));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (this.config.isStopOnError()) {
                        throw e;
                    }
                    this.log.error("error in task", (Throwable)e);
                    callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CheckDuplicateIndexEntryTask_errorProcessing, (Throwable)e, (Object[])new Object[]{clazz.getName(), e.toString()}));
                }
            }
            if (!this.isToBeStopped()) {
                callback.addEvent("progress", MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.CheckDuplicateIndexEntryTask_processingComplete, (Object[])new Object[0]));
                callback.updateProgress((byte)100);
            }
            successfully = true;
        }
        finally {
            if (!successfully) {
                try {
                    this.stop();
                }
                catch (Exception e) {
                    this.log.error("unable to stop task", (Throwable)e);
                    callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CheckDuplicateIndexEntryTask_errorStopping, (Object[])new Object[0]));
                }
            }
        }
        callback.taskFinished();
        this.log.debug("task finished");
    }

    private <E extends BaseEntity> void reindex(EntityReference<E> source) {
        EntityContainer entityContainer = EntityStorage.get().resolve(source);
        if (entityContainer == null) {
            // empty if block
        }
        LogicalStorage.get().getEntityStorage().updateIndexes(entityContainer, entityContainer, false);
    }

    protected Collection<Class<?>> getIndexTypeList() throws Exception {
        HashSet result = new HashSet();
        MetaRegistry metaRegistry = MetaRegistry.get();
        Set typeList = this.config.getTypeList();
        for (IndexType value : metaRegistry.getIndexes().values()) {
            if (typeList != null && typeList.size() > 0 && !typeList.contains(value.getId()) || !this.acceptType(value.getId())) continue;
            result.add(Class.forName(value.getId()));
        }
        return result;
    }

    protected boolean acceptType(String typeId) {
        return true;
    }

    public void toXML(Element elm) throws Exception {
        this.config.toXML(elm);
    }

    public void fromXML(Element elm) throws Exception {
        this.config = new CheckDuplicateIndexEntryTaskConfiguration();
        this.config.fromXML(elm);
    }
}

