/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.List;
import org.json.JSONObject;
import org.w3c.dom.Element;

public class CirMigrationTask
extends BaseLongRunningTask<Serializable> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendCard(Card card, PCIDSSServerExchangeSettings settings) throws Exception {
        URL url = new URL(settings.getServerAddress() + "/cards");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("Cookie", CirHelper.appToken2Cookie((String)settings.getToken()));
        connection.setDoOutput(true);
        connection.setDoInput(true);
        SimpleDateFormat formatter = new SimpleDateFormat("MMyy");
        String date = formatter.format(card.getExpiration());
        JSONObject cardObject = new JSONObject();
        cardObject.put("xtripUID", (Object)card.getUid());
        cardObject.put("expirationDate", (Object)date);
        cardObject.put("cardholderName", (Object)card.getNameOnCard());
        cardObject.put("pan", (Object)card.getNumber());
        String cardEntity = cardObject.toString();
        connection.setRequestMethod("POST");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));){
            int bytesRead;
            writer.write(cardEntity);
            ((Writer)writer).flush();
            if (connection.getResponseCode() != 200) {
                throw new Exception("Unable to send card to CIR. Response code: " + connection.getResponseCode());
            }
            InputStream inputStream = connection.getInputStream();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buff = new byte[256];
            while ((bytesRead = inputStream.read(buff, 0, buff.length)) != -1) {
                outputStream.write(buff, 0, bytesRead);
            }
            outputStream.flush();
            String response = new String(outputStream.toByteArray(), "UTF-8");
            JSONObject jsonResponse = new JSONObject(response);
            card.setNumber(jsonResponse.getString("pan"));
            card.setCirUid(jsonResponse.getString("uid"));
        }
        finally {
            connection.disconnect();
        }
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        List organizationUids = LogicalStorage.get().getEntityStorage().getEntityUids(Organization.class, null, null, false, true, SortOrder.ASC, null);
        PCIDSSServerExchangeSettings settings = CirHelper.getSettings();
        for (String organizationUid : organizationUids) {
            Organization organization;
            boolean entityChanged = false;
            EntityContainer organizationContainer = EntityStorage.get().load(Organization.class, organizationUid);
            if (organizationContainer == null || (organization = (Organization)organizationContainer.getEntity()) == null) continue;
            for (Card card : organization.getCards()) {
                if (card.getNumber().contains("*")) continue;
                CirMigrationTask.sendCard(card, settings);
                entityChanged = true;
            }
            if (!entityChanged) continue;
            EntityStorage.get().save(organizationContainer, true);
        }
        callback.updateProgress((byte)50);
        List personUids = LogicalStorage.get().getEntityStorage().getEntityUids(Person.class, null, null, false, true, SortOrder.ASC, null);
        for (String personUid : personUids) {
            Person person;
            boolean entityChanged = false;
            EntityContainer personContainer = EntityStorage.get().load(Person.class, personUid);
            if (personContainer == null || (person = (Person)personContainer.getEntity()) == null) continue;
            for (Card card : person.getCards()) {
                if (card.getNumber().contains("*")) continue;
                CirMigrationTask.sendCard(card, settings);
                entityChanged = true;
            }
            if (!entityChanged) continue;
            personContainer.getVersionInfo().setDataSource("task");
            personContainer.getVersionInfo().setVersionNotes("Cir migration task");
            EntityStorage.get().save(personContainer, true);
        }
        callback.taskFinished();
    }

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return null;
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }
}

