/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ClientCo2EmissionsUpdateTask
extends BaseLongRunningTask<Serializable> {
    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.ClientCo2EmissionsUpdateTask_description, (Object[])new Object[0]);
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("client co2 emissions update started");
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT));
        Set organizationRefs = EntityStorage.get().search(OrganizationIndex.class, query).getData().stream().map(OrganizationIndex::getSource).collect(Collectors.toSet());
        int count = organizationRefs.size();
        int i = 0;
        for (EntityReference orgRef : organizationRefs) {
            Organization org;
            List afsTypes;
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            byte progress = (byte)(100 * i / count);
            this.log.debug(String.format("processing organization %s, %d of %d (%d%%)", orgRef, i, count, progress));
            if (i % 10 == 0) {
                callback.updateProgress(progress);
            }
            ++i;
            EntityContainer orgCtr = EntityStorage.get().resolve(orgRef);
            if (orgCtr == null || ProfileHelper.isRetailProfile((EntityContainer)orgCtr) || (afsTypes = StatisticsHelper.getAfsTypesFromString((String)(org = (Organization)orgCtr.getEntity()).getAfsSettings())).contains(AFSType.CO2_EMISSIONS)) continue;
            afsTypes.add(AFSType.CO2_EMISSIONS);
            org.setAfsSettings(afsTypes.stream().map(Enum::name).collect(Collectors.joining("|")));
            orgCtr.getVersionInfo().setDataSource("client-co2-emissions-update-task");
            EntityStorage.get().save(orgCtr, true);
        }
        callback.taskFinished();
        this.log.debug("client co2 emissions update finished");
    }
}

