/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand1Fnbts;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class CopyBookingPccFromRemarksTask
extends BaseLongRunningTask<Serializable> {
    private int count = -1;
    private final Set<String> toProceed = new LinkedHashSet<String>();

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.CopyBookingPccFromRemarksTask_description, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        Element countElement = XmlUtil.addElement((Element)elm, (String)"count");
        countElement.setAttribute("value", String.valueOf(this.count));
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    public void fromXML(Element elm) throws Exception {
        Element countElement = XmlUtil.getElement((Element)elm, (String)"count");
        if (countElement != null) {
            this.count = Integer.parseInt(countElement.getAttribute("value"));
        }
        for (Element itemElement : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(itemElement.getAttribute("uid"));
        }
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("Copying booking pcc from remarks started");
        this.updateUids();
        if (this.count == -1) {
            this.count = this.toProceed.size();
        }
        int n = this.count - this.toProceed.size();
        this.log.debug(String.format(String.format("uids updated, processed: %s, total: %s", String.valueOf(n), String.valueOf(this.count)), new Object[0]));
        Iterator<String> uidIterator = this.toProceed.iterator();
        while (uidIterator.hasNext()) {
            String uid = uidIterator.next();
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            ++n;
            String organizationTitle = "";
            try {
                EntityContainer orgCont = EntityStorage.get().load(Organization.class, uid);
                if (orgCont == null) continue;
                Organization org = (Organization)orgCont.getEntity();
                if (org.getShortName() != null) {
                    organizationTitle = org.getShortName().getStringValue();
                } else if (org.getFullName() != null) {
                    organizationTitle = org.getFullName().getStringValue();
                }
                if (org.getTypes().contains(OrganizationType.CORPORATE_CLIENT) && org.getSabreAdditionalCommand1Lines() != null) {
                    for (SabreProfileCommand1Fnbts remark : org.getSabreAdditionalCommand1Lines()) {
                        if (remark == null || !TextUtil.nonBlank((String)remark.getEntry5())) continue;
                        org.getBookingPccs().add(remark.getEntry5());
                    }
                    orgCont.getVersionInfo().setDataSource("task");
                    orgCont.getVersionInfo().setVersionNotes("Copying booking pcc from remarks task");
                    EntityStorage.get().save(orgCont, true);
                }
                byte progress = (byte)(100 * n / this.count);
                if (n % 10 == 0) {
                    callback.updateProgress(progress);
                }
            }
            catch (Throwable e) {
                this.log.error(String.format("unable to copy booking pcc from remarks for Organization %s", organizationTitle), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CopyBookingPccFromRemarksTask_failed, (Throwable)e, (Object[])new Object[]{organizationTitle}));
            }
            uidIterator.remove();
        }
        callback.taskFinished();
        this.log.debug("Copying booking pcc from remarks finished");
    }

    private void updateUids() throws Exception {
        if (this.count != -1 && !this.toProceed.isEmpty()) {
            return;
        }
        LogicalStorage storage = LogicalStorage.get();
        LogicalEntityStorage entityStorage = storage.getEntityStorage();
        List uids = entityStorage.getEntityUids(Organization.class, null, null, true, true, SortOrder.ASC, null);
        this.toProceed.addAll(uids);
    }
}

