/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.CopyLocaleToLocaleTaskConfiguration;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Element;

public class CopyDictionaryFromLocaleToLocaleTask
extends BaseLongRunningTask<CopyLocaleToLocaleTaskConfiguration> {
    private final Map<Class<? extends BaseDictionary>, List<String>> toProceed = new LinkedHashMap<Class<? extends BaseDictionary>, List<String>>();
    private CopyLocaleToLocaleTaskConfiguration configuration;
    private int count = 0;

    @Override
    public void configure(CopyLocaleToLocaleTaskConfiguration value) throws Exception {
        this.configuration = value;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.CopyDictionaryFromLocaleToLocaleTask_startCopying, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        this.configuration.toXML(elm);
        Element countElem = XmlUtil.addElement((Element)elm, (String)"count");
        countElem.setAttribute("value", String.valueOf(this.count));
        for (Class<? extends BaseDictionary> item : this.toProceed.keySet()) {
            Element typeElement = XmlUtil.addElement((Element)elm, (String)"type");
            typeElement.setAttribute("type", item.getName());
            for (String uid : this.toProceed.get(item)) {
                Element itemElement = XmlUtil.addElement((Element)typeElement, (String)"item");
                itemElement.setAttribute("uid", uid);
            }
        }
    }

    public void fromXML(Element elm) throws Exception {
        this.configuration = new CopyLocaleToLocaleTaskConfiguration();
        this.configuration.fromXML(elm);
        Element countElem = XmlUtil.getElement((Element)elm, (String)"count");
        if (countElem != null) {
            this.count = Integer.parseInt(countElem.getAttribute("value"));
        }
        for (Element typeElement : XmlUtil.getElements((Element)elm, (String)"type")) {
            ArrayList<String> uidsByType = new ArrayList<String>();
            for (Element itemElement : XmlUtil.getElements((Element)typeElement, (String)"item")) {
                uidsByType.add(itemElement.getAttribute("uid"));
            }
            this.toProceed.put(Class.forName(typeElement.getAttribute("type")), uidsByType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("Begin copy of locale to locale task");
        Locale localeTo = this.configuration.getLocaleTo();
        if (localeTo == null) {
            throw new IllegalStateException("LocaleTo not defined");
        }
        Locale localeFrom = this.configuration.getLocaleFrom();
        if (localeFrom == null) {
            throw new IllegalStateException("LocaleFrom not defined");
        }
        this.updateUids();
        this.log.debug(String.format("UUIDs to update remains %d", this.count));
        int n = 0;
        try {
            for (Class<? extends BaseDictionary> type : this.toProceed.keySet()) {
                List<String> uidsByType = this.toProceed.get(type);
                Iterator<String> uids = uidsByType.iterator();
                while (uids.hasNext()) {
                    String uid = uids.next();
                    if (this.isToBeStopped()) {
                        this.log.debug("task is interrupted");
                        return;
                    }
                    BaseDictionary dr = DictionaryStorage.get().load(type, uid);
                    Map translations = dr.getTranslations();
                    byte progress = (byte)(100 * ++n / this.count);
                    this.log.debug(String.format("processing dictionary reference <%s> %s, %s of %s (%s%%)", dr.getClass(), dr, String.valueOf(n), String.valueOf(this.count), String.valueOf(progress)));
                    if (n % 10 == 0) {
                        callback.updateProgress(progress);
                    }
                    boolean hasChanges = false;
                    if (translations.keySet().contains(localeFrom) && !TextUtil.isBlank((String)((String)translations.get(localeFrom)))) {
                        translations.put(localeTo, translations.get(localeFrom));
                        hasChanges = true;
                    }
                    if (hasChanges) {
                        dr.setDataSource("CopyDictionaryFromLocaleToLocaleTask");
                        DictionaryStorage.get().save(dr);
                    }
                    uids.remove();
                }
            }
        }
        catch (Exception e) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CopyDictionaryFromLocaleToLocaleTask_errorCopying, (Throwable)e, (Object[])new Object[0]));
        }
        finally {
            this.log.debug("End doctionary copy from en to selectable locale task");
            callback.updateProgress((byte)100);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.CopyDictionaryFromLocaleToLocaleTask_successCopying, (Object[])new Object[0]));
            callback.taskFinished();
        }
    }

    private void updateUids() throws Exception {
        if (!this.toProceed.isEmpty()) {
            return;
        }
        Collection airlines = DictionaryStorage.get().loadAll(new Date(0L), Airline.class);
        ArrayList<String> uidsAirline = new ArrayList<String>();
        for (Airline airLine : airlines) {
            uidsAirline.add(airLine.getCode());
        }
        Collection countries = DictionaryStorage.get().loadAll(new Date(0L), Country.class);
        ArrayList<String> uidsCountry = new ArrayList<String>();
        for (Country country : countries) {
            uidsCountry.add(country.getCode());
        }
        Collection geoLocations = DictionaryStorage.get().loadAll(new Date(0L), GeoLocation.class);
        ArrayList<String> uidsGeoLocation = new ArrayList<String>();
        for (GeoLocation geoLocation : geoLocations) {
            uidsGeoLocation.add(geoLocation.getCode());
        }
        Collection geoRegions = DictionaryStorage.get().loadAll(new Date(0L), GeoRegion.class);
        ArrayList<String> uidsGeoRegion = new ArrayList<String>();
        for (GeoRegion geoRegion : geoRegions) {
            uidsGeoRegion.add(geoRegion.getCode());
        }
        this.toProceed.put(Airline.class, uidsAirline);
        this.count += uidsAirline.size();
        this.toProceed.put(Country.class, uidsCountry);
        this.count += uidsCountry.size();
        this.toProceed.put(GeoLocation.class, uidsGeoLocation);
        this.count += uidsGeoLocation.size();
        this.toProceed.put(GeoRegion.class, uidsGeoRegion);
        this.count += uidsGeoRegion.size();
    }
}

