/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class CopyEmailToGetThereLoginTask
extends BaseLongRunningTask<Serializable> {
    private int count = -1;
    private final Set<String> toProceed = new LinkedHashSet<String>();

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.CopyEmailToGetThereLoginTask_description, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        Element countElement = XmlUtil.addElement((Element)elm, (String)"count");
        countElement.setAttribute("value", String.valueOf(this.count));
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    public void fromXML(Element elm) throws Exception {
        Element countElement = XmlUtil.getElement((Element)elm, (String)"count");
        if (countElement != null) {
            this.count = Integer.parseInt(countElement.getAttribute("value"));
        }
        for (Element itemElement : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(itemElement.getAttribute("uid"));
        }
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("Copying email to GetThere login field started");
        this.updateUids();
        if (this.count == -1) {
            this.count = this.toProceed.size();
        }
        int n = this.count - this.toProceed.size();
        this.log.debug(String.format(String.format("uids updated, processed: %s, total: %s", String.valueOf(n), String.valueOf(this.count)), new Object[0]));
        Iterator<String> uidIterator = this.toProceed.iterator();
        while (uidIterator.hasNext()) {
            String uid = uidIterator.next();
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            ++n;
            String personTitle = "";
            try {
                EntityContainer perCont = EntityStorage.get().load(Person.class, uid);
                if (perCont == null) continue;
                Person per = (Person)perCont.getEntity();
                if (per.getLastName() != null) {
                    personTitle = per.getLastName().getStringValue();
                    if (per.getFirstName() != null) {
                        personTitle = personTitle + " " + per.getFirstName().getStringValue();
                    }
                }
                if (per.getTypes().contains(PersonType.PASSENGER) && TextUtil.isBlank((String)per.getResourceIdForGetThere())) {
                    for (PersonCommunication pc : per.getCommunications()) {
                        if (!CommunicationType.EMAIL.equals((Object)pc.getType()) || TextUtil.isBlank((String)pc.getSense())) continue;
                        per.setResourceIdForGetThere(pc.getSense());
                        break;
                    }
                    perCont.getVersionInfo().setDataSource("task");
                    perCont.getVersionInfo().setVersionNotes("Copy email to Get There login task");
                    EntityStorage.get().save(perCont, true);
                }
                byte progress = (byte)(100 * n / this.count);
                if (n % 10 == 0) {
                    callback.updateProgress(progress);
                }
            }
            catch (Throwable e) {
                this.log.error(String.format("unable to copy email to GetThere login field for Person %s", personTitle), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CopyEmailToGetThereLoginTask_failed, (Throwable)e, (Object[])new Object[]{personTitle}));
            }
            uidIterator.remove();
        }
        callback.taskFinished();
        this.log.debug("Copying email to GetThere login field finished");
    }

    private void updateUids() throws Exception {
        if (this.count != -1 && !this.toProceed.isEmpty()) {
            return;
        }
        LogicalStorage storage = LogicalStorage.get();
        LogicalEntityStorage entityStorage = storage.getEntityStorage();
        List uids = entityStorage.getEntityUids(Person.class, null, null, true, true, SortOrder.ASC, null);
        this.toProceed.addAll(uids);
    }
}

