/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.CostCodeCategoryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class CostCodesTransformTask
extends BaseLongRunningTask<Serializable> {
    private final List<CostCodeCategoryWrapper> categories = new ArrayList<CostCodeCategoryWrapper>();

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.CostCodesTransformTask_OversaveUDID, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        for (CostCodeCategoryWrapper wrapper : this.categories) {
            if (wrapper.getCategory() != null) {
                Element elm2 = XHelper.writeString((Element)elm, (String)"category", (String)wrapper.getCategory().getCode());
                elm2.setAttribute("class", "com.gridnine.xtrip.common.model.dict.CostCodeCategoryReference");
                if (!TextUtil.isBlank((String)wrapper.getCategory().toReference().getCaption())) {
                    elm2.setAttribute("caption", wrapper.getCategory().toReference().getCaption());
                }
            }
            XHelper.writeString((Element)elm, (String)"name", (String)wrapper.getSabreName());
            XHelper.writeString((Element)elm, (String)"shortName", (String)wrapper.getSabreShortName());
        }
    }

    public void fromXML(Element elm) throws Exception {
        for (Element element : XmlUtil.getElements((Element)elm, (String)"item")) {
            CostCodeCategory cat;
            String dictCode = XmlUtil.getValue((Element)element, (String)"category");
            if (dictCode != null) {
                CostCodeCategoryReference catRef = new CostCodeCategoryReference(dictCode, XmlUtil.getValue((Element)elm, (String)"category@caption"));
                cat = (CostCodeCategory)DictionaryCache.get().resolveReference((DictionaryReference)catRef);
            } else {
                cat = null;
            }
            String sabreName = XHelper.readString((Element)elm, (String)"name");
            String sabreShortName = XHelper.readString((Element)elm, (String)"shortName");
            CostCodeCategoryWrapper wrapper = new CostCodeCategoryWrapper(cat, sabreName, sabreShortName);
            this.categories.add(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("BEGIN Cost Codes renaming task");
        this.updateCategories();
        int count = this.categories.size();
        this.log.debug(String.format("uids updated, remains " + count, new Object[0]));
        int n = 0;
        try {
            for (CostCodeCategoryWrapper wrapper : this.categories) {
                if (this.isToBeStopped()) {
                    this.log.debug("task is interrupted");
                    return;
                }
                String title = wrapper.getCategory().getCode();
                byte progress = (byte)(100 * ++n / count);
                this.log.debug(String.format("processing cost code categories %s: %s of %s (%s%%)", title, n, String.valueOf(count), String.valueOf(progress)));
                if (n % 20 == 0) {
                    callback.updateProgress(progress);
                }
                CostCodeCategory cat = wrapper.getCategory();
                cat.setName(wrapper.getSabreName());
                cat.setShortName(wrapper.getSabreShortName());
                LogicalStorage.get().getStandardDictionaryStorage().save((BaseDictionary)cat, true);
            }
        }
        catch (Throwable e) {
            this.log.error("unable to process cost code transforming of %s", e);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 UDID", (Throwable)e, (Object[])new Object[0]));
        }
        finally {
            this.log.debug("END Cost Codes renaming task");
            callback.updateProgress((byte)100);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.AfsSettingsTransformTask_completedResavingUDID, (Object[])new Object[0]));
            callback.taskFinished();
        }
    }

    private void updateCategories() throws Exception {
        if (!this.categories.isEmpty()) {
            return;
        }
        List orgIndexes = EntityStorage.get().search(OrganizationIndex.class, new SearchQuery()).getData();
        for (OrganizationIndex orgIndex : orgIndexes) {
            EntityContainer orgCont = EntityStorage.get().resolve(orgIndex.getSource());
            if (orgCont == null) continue;
            Organization org = (Organization)orgCont.getEntity();
            for (CostCodeProperties ccp : org.getCostCodeProperties()) {
                CostCodeCategoryWrapper wrapper;
                CostCodeCategory cat;
                if (ccp.getCategory() == null || TextUtil.isBlank((String)ccp.getSabreName()) || TextUtil.isBlank((String)ccp.getSabreShortName()) || (cat = (CostCodeCategory)DictionaryCache.get().resolveReference(ccp.getCategory())) == null || this.categories.contains(wrapper = new CostCodeCategoryWrapper(cat, ccp.getSabreName(), ccp.getSabreShortName())) || !TextUtil.isBlank((String)cat.getName()) && !TextUtil.isBlank((String)cat.getShortName())) continue;
                this.categories.add(wrapper);
                System.out.println("Added category: " + wrapper.getCategory().getTranslations().values() + ". with SabreName = " + wrapper.getSabreName() + ", SabreShortName = " + wrapper.getSabreShortName());
            }
        }
    }

    public class CostCodeCategoryWrapper {
        private final CostCodeCategory category;
        private final String sabreName;
        private final String sabreShortName;

        public CostCodeCategoryWrapper(CostCodeCategory cat, String sabreName, String sabreShortName) {
            this.category = cat;
            this.sabreName = sabreName;
            this.sabreShortName = sabreShortName;
        }

        public CostCodeCategory getCategory() {
            return this.category;
        }

        public String getSabreName() {
            return this.sabreName;
        }

        public String getSabreShortName() {
            return this.sabreShortName;
        }

        public boolean equals(Object value) {
            if (this == value) {
                return true;
            }
            if (value == null) {
                return false;
            }
            if (!(value instanceof CostCodeCategoryWrapper)) {
                return false;
            }
            CostCodeCategoryWrapper wrapper = (CostCodeCategoryWrapper)value;
            return this.category != null && this.category.equals((Object)wrapper.category);
        }

        public int hashCode() {
            int multiplier = 23;
            int hashCode = 1;
            hashCode = 23 * hashCode + this.category.hashCode();
            return hashCode;
        }
    }
}

