/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class CountriesIso2ClearTask
extends BaseLongRunningTask<Serializable> {
    Set<Country> countries = new HashSet<Country>();
    int countTotal;
    int countUpdated;

    public void toXML(Element elm) throws Exception {
        for (Country country : this.countries) {
            XHelper.writeObject((Element)elm, (String)"Country", (Object)country);
        }
        XHelper.writeInt((Element)elm, (String)"CountTotal", (int)this.countTotal);
        XHelper.writeInt((Element)elm, (String)"CountUpdated", (int)this.countUpdated);
    }

    public void fromXML(Element elm) throws Exception {
        for (Element country : XmlUtil.getElements((Element)elm, (String)"elm")) {
            this.countries.add((Country)XHelper.readObject((Element)country, (String)"."));
        }
        this.countTotal = XHelper.readInt((Element)elm, (String)"CountTotal");
        this.countUpdated = XHelper.readInt((Element)elm, (String)"CountUpdated");
    }

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.CountriesIso2ClearTask_description, (Object[])new Object[0]);
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("country codes ISO2 clear");
        if (this.countries.isEmpty()) {
            this.countries.addAll(DictionaryCache.get().getAll(Country.class).values());
            this.countTotal = this.countries.size();
        }
        int n = 0;
        for (Country country : this.countries) {
            if (country.getCodeVariants().containsKey(CodeSystem.ISO.name())) {
                ++this.countUpdated;
                country.getCodeVariants().remove(CodeSystem.ISO.name());
                country.setDataSource("CountriesIso2ClearTask");
                DictionaryStorage.get().save((BaseDictionary)country);
            }
            if (++n % 10 != 0) continue;
            byte progress = (byte)(100 * n / this.countTotal);
            callback.updateProgress(progress);
        }
        this.log.debug(String.format("countries updated, processed: %s", String.valueOf(this.countTotal)));
        callback.addEvent(null, MessageHelper.createMessage((String)String.format(L10n.get((String)com.gridnine.xtrip.common.l10n.Messages.CountriesIso2ClearTask_CountriesUpdated), String.valueOf(this.countUpdated)), (Object[])new Object[0]));
        callback.taskFinished();
        this.log.debug("country codes ISO2 clear finished");
    }
}

