/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class CountriesIso3UpdateTask
extends BaseLongRunningTask<Serializable> {
    private Set<String> codes = new HashSet<String>();

    public void fromXML(Element elm) throws Exception {
        for (Element itemElement : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.codes.add(itemElement.getAttribute("code"));
        }
    }

    public void toXML(Element elm) throws Exception {
        for (String item : this.codes) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("code", item.trim());
        }
    }

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)com.gridnine.xtrip.common.model.l10n.Messages.CountriesIso3UpdateTask_description, (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) {
        this.log.debug("country codes ISO3 update");
        ArrayList countries = new ArrayList();
        String filePath = "data/Countries.csv";
        BufferedReader reader = null;
        try {
            String line;
            InputStream inputStream = this.getClass().getResourceAsStream(filePath);
            reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            boolean isFirst = true;
            int n = 0;
            while ((line = reader.readLine()) != null) {
                if (!isFirst) {
                    HashMap<String, String> country = new HashMap<String, String>();
                    String[] split = line.split(";");
                    if (split.length > 3 && !TextUtil.isBlank((String)split[3], (boolean)true)) {
                        country.put("CODE", split[0]);
                        country.put("IATA", split[1]);
                        country.put("ISO", split[2]);
                        country.put("ISO_ALPHA3", split[3]);
                        countries.add(country);
                        ++n;
                    }
                } else {
                    isFirst = false;
                }
                if (n % 10 != 0) continue;
                byte progress = (byte)(5 * n / 219);
                callback.updateProgress(progress);
            }
            this.log.debug(String.format("csv file read, count of countries: %s", String.valueOf(n)));
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)String.format(L10n.get((String)Messages.CountriesIso3UpdateTask_CsvFileReaded), String.valueOf(n)), (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.log.error(String.format("unable to read file %s", filePath), (Throwable)e);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10n.get((String)Messages.CountriesIso3UpdateTask_UnableToReadCSVFile), (Throwable)e, (Object[])new Object[]{filePath}));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        if (this.codes.size() == 0) {
            this.codes = DictionaryCache.get().getAll(Country.class).entrySet().stream().filter(c -> Objects.nonNull(c.getValue())).map(Map.Entry::getValue).map(BaseDictionary::getCode).collect(Collectors.toSet());
        }
        int count = this.codes.size();
        int countSave = 0;
        try {
            Iterator<String> iterator = this.codes.iterator();
            while (iterator.hasNext()) {
                String countryCode = iterator.next();
                block15: for (Country country : DictHelper.findCountryByCode((String)countryCode)) {
                    Map codeVariants = country.getCodeVariants();
                    String code = country.getCode();
                    String IATA2Code = TextUtil.nonNullStr((String)((String)codeVariants.get("IATA")));
                    String ISO2Code = TextUtil.nonNullStr((String)((String)codeVariants.get("ISO")));
                    for (Map map : countries) {
                        if (!(!TextUtil.isBlank((String)code, (boolean)true) && code.equalsIgnoreCase((String)map.get("CODE")) || !TextUtil.isBlank((String)IATA2Code, (boolean)true) && IATA2Code.equalsIgnoreCase((String)map.get("IATA"))) && (TextUtil.isBlank((String)ISO2Code, (boolean)true) || !ISO2Code.equalsIgnoreCase((String)map.get("ISO")))) continue;
                        codeVariants.put("ISO_ALPHA3", TextUtil.nonNullStr((String)((String)map.get("ISO_ALPHA3"))));
                        country.setDataSource("CountriesIso3UpdateTask");
                        DictionaryStorage.get().save((BaseDictionary)country);
                        ++countSave;
                        continue block15;
                    }
                }
                iterator.remove();
                if (countSave % 10 != 0) continue;
                byte progress = (byte)(5 + 95 * countSave / count);
                callback.updateProgress(progress);
            }
        }
        catch (Exception e) {
            this.log.error("error of updating country", (Throwable)e);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)L10n.get((String)Messages.CountriesIso3UpdateTask_ErrorOfUpdatingCountry), (Throwable)e, (Object[])new Object[0]));
        }
        this.log.debug(String.format("countries updated, processed: %s, total: %s", String.valueOf(countSave), String.valueOf(count)));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)String.format(L10n.get((String)Messages.CountriesIso3UpdateTask_CountriesUpdated), String.valueOf(countSave), String.valueOf(count)), (Object[])new Object[0]));
        callback.taskFinished();
        this.log.debug("country codes ISO3 update finished");
    }
}

