/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Element;

public class CurrencyRateBaseCurrencyUpdateTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.CurrencyRateBaseCurrencyUpdateTask_fillingEquivalentCurrency, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("migration started");
        String equivCurrency = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
        Collection result = LogicalStorage.get().getStandardDictionaryStorage().loadAll(null, CurrencyRate.class, Collections.emptySet());
        this.log.debug("dictionaries loaded");
        for (BaseDictionary dict : result) {
            CurrencyRate currencyRate = (CurrencyRate)dict;
            this.log.debug("filling in base currency " + currencyRate.toString());
            try {
                if (currencyRate.getBaseCurrency() != null) {
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.CurrencyRateBaseCurrencyUpdateTask_baseCurrencyCourse, (Object[])new Object[]{currencyRate.toString()}));
                    this.log.debug("already updated");
                    continue;
                }
                currencyRate.setBaseCurrency(equivCurrency);
                LogicalStorage.get().getStandardDictionaryStorage().save((BaseDictionary)currencyRate);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.CurrencyRateUpdateTask_courseUpdatedSetBlankOwner, (Object[])new Object[]{currencyRate.toString(), equivCurrency}));
                this.log.debug("updated");
            }
            catch (Throwable e) {
                this.log.error("exception", e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CurrencyRateBaseCurrencyUpdateTask_errorUpdataCourse, (Throwable)e, (Object[])new Object[]{currencyRate.toString()}));
            }
        }
        DictionaryCache.get().check();
        callback.taskFinished();
        this.log.debug("fill-in finished");
    }

    @Override
    public boolean isIndefinite() {
        return true;
    }
}

