/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class CurrencyRateUpdateTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.CurrencyRateUpdateTask_replacingAirlinesOwnerBlank, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("migration started");
        Collection result = LogicalStorage.get().getStandardDictionaryStorage().loadAll(null, CurrencyRate.class, Collections.emptySet());
        this.log.debug("dictionaries loaded");
        for (BaseDictionary dict : result) {
            CurrencyRate currencyRate = (CurrencyRate)dict;
            this.log.debug("updating blank type " + currencyRate.toString());
            try {
                if (currencyRate.getBlankOwner() != null) {
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.CurrencyRateUpdateTask_courseAlreadyUpdated, (Object[])new Object[]{currencyRate.toString()}));
                    this.log.debug("already updated");
                    continue;
                }
                DictionaryReference ref = currencyRate.getVendor();
                if (ref == null) {
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CurrencyRateUpdateTask_courseNotDefineAirline, (Object[])new Object[]{currencyRate.toString()}));
                    this.log.debug("airline is absent");
                    continue;
                }
                List<EntityContainer<Organization>> ctrs = ProfileDao.getBlankOwnersByAirline((DictionaryReference<Airline>)ref);
                if (ctrs.isEmpty()) {
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CurrencyRateUpdateTask_notFoundBlankOwner, (Object[])new Object[]{currencyRate.toString(), currencyRate.getVendor()}));
                    this.log.debug("no blankowner found");
                    continue;
                }
                EntityReference boref = ctrs.get(0).toReference();
                if (ctrs.size() != 1) {
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.CurrencyRateUpdateTask_errorUpdateCouseForAirline, (Object[])new Object[]{currencyRate.toString(), currencyRate.getVendor(), boref.toString()}));
                    this.log.debug("few blankowner found, used " + boref);
                }
                currencyRate.setBlankOwner(boref);
                LogicalStorage.get().getStandardDictionaryStorage().save((BaseDictionary)currencyRate);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.CurrencyRateUpdateTask_courseUpdatedSetBlankOwner, (Object[])new Object[]{currencyRate.toString(), boref.toString()}));
                this.log.debug("updated");
            }
            catch (Throwable e) {
                this.log.error("exception", e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CurrencyRateUpdateTask_errorCourseUpdate, (Throwable)e, (Object[])new Object[]{currencyRate.toString()}));
            }
        }
        DictionaryCache.get().check();
        callback.taskFinished();
        this.log.debug("migration finished");
    }

    @Override
    public boolean isIndefinite() {
        return true;
    }
}

