/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.GdsReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.model.profile.Visa;
import com.gridnine.xtrip.common.model.rules.standard.HotelProperties;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.DateShiftCheckTaskConfiguration;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.licence.Address;
import com.gridnine.xtrip.server.model.licence.DataExchangeResponse;
import com.gridnine.xtrip.server.model.licence.DateShiftExchangeRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DateShiftCheckTask
extends BaseLongRunningTask<Serializable> {
    protected DateShiftCheckTaskConfiguration config = new DateShiftCheckTaskConfiguration();
    private Date startDate = new Date();
    private Date stopDate = new Date();
    private final List<String> ignoredUsers = new ArrayList<String>();
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private static ArrayList<RuleProperty> dateConditions = new ArrayList();

    @Override
    public void configure(Serializable configuration) throws Exception {
        this.config = (DateShiftCheckTaskConfiguration)configuration;
        if (this.config.getStartDate() != null) {
            this.startDate = this.config.getStartDate();
        }
        if (this.config.getStopDate() != null) {
            this.stopDate = this.config.getStopDate();
        }
        if (this.config.getIgnoredUsers() != null) {
            this.ignoredUsers.addAll(Arrays.asList(this.config.getIgnoredUsers().split(",")));
        }
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"dateShiftCheckTask_title", (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        this.config.toXML(elm);
    }

    public void fromXML(Element elm) throws Exception {
        this.config.fromXML(elm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        if (this.config != null) {
            this.configure((Serializable)this.config);
        }
        if (this.startDate.equals(this.stopDate)) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, 2000);
            cal.set(2, 0);
            cal.set(5, 1);
            this.startDate = cal.getTime();
        }
        this.log.info("date shifting check task started");
        this.log.info("dates: " + this.startDate.toString() + " - " + this.stopDate.toString());
        DateShiftExchangeRequest data = new DateShiftExchangeRequest();
        data.increment("Test");
        this.log.info("checking persons");
        this.checkPersons(this.ignoredUsers, this.startDate, this.stopDate, data);
        this.log.info("checking organizations");
        this.checkOrganizations(this.ignoredUsers, this.startDate, this.stopDate, data);
        this.log.info("checking contracts");
        this.checkContracts(this.ignoredUsers, this.startDate, this.stopDate, data);
        try {
            this.sendData(data);
        }
        catch (Exception ex) {
            this.log.error("", (Throwable)ex);
        }
        finally {
            callback.taskFinished();
            this.log.debug("task finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataExchangeResponse sendData(DateShiftExchangeRequest data) {
        data.setAppId(Environment.getApplicationId());
        data.setIpAddress(this.getIpAddressStr());
        StringBuilder traceString = new StringBuilder();
        SynchronizationResponse<DataExchangeResponse> response = this.processRequest(data);
        DataExchangeResponse dataExchangeResponse = null;
        try {
            for (Message msg : response.getMessages()) {
                if (msg.getType() != MessageType.ERROR) continue;
                this.log.warn("Request to LicenceServer for dates hidting check had errors: " + msg.getMessage());
                traceString.append("\r\nError while sending date shift checking results: " + msg.getMessage());
                Object var7_8 = null;
                return var7_8;
            }
            dataExchangeResponse = response.getData();
            return dataExchangeResponse;
        }
        catch (Exception e) {
            this.log.error("Unable to send tripartite contract usage to licence server", (Throwable)e);
            traceString.append(String.format("\r\nUnable to send tripartite contract usage to licence server:\n %s", TextUtil.getExceptionStackTrace((Throwable)e)));
        }
        finally {
            SynchronizationHelper.log(traceString.toString(), "exchange-date-shift-check");
            return dataExchangeResponse;
        }
    }

    private SynchronizationResponse<DataExchangeResponse> processRequest(DateShiftExchangeRequest data) {
        SynchronizationRequest<DateShiftExchangeRequest> request = new SynchronizationRequest<DateShiftExchangeRequest>();
        request.setClientId(Environment.getApplicationId());
        request.setData(data);
        request.setOperationId("exchange-date-shift-check");
        request.setUser("DateShiftCheckTaskUser");
        ValueHolder trace = new ValueHolder();
        return SynchronizationHelper.execute(request, Address.getSync(), (ValueHolder<String>)trace);
    }

    private String getIpAddressStr() {
        InetAddress ip = this.getIpAddress();
        return ip != null ? ip.getHostAddress() : "";
    }

    private InetAddress getIpAddress() {
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ip;
    }

    private void checkContracts(List<String> ignoredUsers, Date startDate, Date stopDate, DateShiftExchangeRequest data) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)"modified", (Object)startDate), SearchCriterion.le((String)"modified", (Object)stopDate)}));
        List contractIndexes = EntityStorage.get().search(ContractIndex.class, query).getData();
        for (ContractIndex index : contractIndexes) {
            EntityContainer contrCtr = EntityStorage.get().resolve(index.getSource());
            ArrayList<EntityContainer<Contract>> versions = this.collectVerions(contrCtr);
            if (versions == null) continue;
            try {
                this.log.info(index.getName() == null ? "" : index.getName() + versions.get(0).getUid());
                this.log.info("Checking customer info");
                if (this.checkContractCustomerInfos(versions)) {
                    data.increment(ContractCustomerInfo.class.getCanonicalName());
                }
                this.log.info("checking rules");
                if (!this.checkRules(versions)) continue;
                data.increment(ContractCustomerInfo.class.getCanonicalName());
            }
            catch (Exception ex) {
                this.log.error("", (Throwable)ex);
            }
        }
    }

    private boolean checkContractCustomerInfos(ArrayList<EntityContainer<Contract>> versions) {
        HashMap versionsMap = new HashMap();
        for (EntityContainer<Contract> version : versions) {
            for (ContractCustomerInfo info : ((Contract)version.getEntity()).getCustomers()) {
                if (versionsMap.get(info.getNumber()) == null) {
                    ArrayList infos = new ArrayList();
                    versionsMap.put(info.getNumber(), infos);
                }
                ((ArrayList)versionsMap.get(info.getNumber())).add(info);
            }
        }
        boolean dateShifted = false;
        for (Map.Entry entry : versionsMap.entrySet()) {
            DateChecker expirationDate = new DateChecker((String)entry.getKey());
            DateChecker startDateChecker = new DateChecker((String)entry.getKey());
            DateChecker issue = new DateChecker((String)entry.getKey());
            for (ContractCustomerInfo info : (ArrayList)entry.getValue()) {
                expirationDate.check(info.getEndDate());
                startDateChecker.check(info.getStartDate());
                issue.check(info.getIssueDate());
            }
            dateShifted = dateShifted || expirationDate.hasShifted() || startDateChecker.hasShifted() || issue.hasShifted();
        }
        return dateShifted;
    }

    private boolean checkRules(ArrayList<EntityContainer<Contract>> versions) throws Exception {
        HashMap versionsMap = new HashMap();
        for (EntityContainer<Contract> version : versions) {
            for (RuleSettings info : ProfileHelper.getRuleSet(version).getRules()) {
                if (versionsMap.get(info.getName()) == null) {
                    ArrayList infos = new ArrayList();
                    versionsMap.put(info.getName(), infos);
                }
                ((ArrayList)versionsMap.get(info.getName())).add(info);
            }
        }
        boolean dateShifted = false;
        for (Map.Entry entry : versionsMap.entrySet()) {
            DateChecker expirationDate = new DateChecker((String)entry.getKey());
            DateChecker startDateChecker = new DateChecker((String)entry.getKey());
            DateChecker valueDate = new DateChecker((String)entry.getKey());
            for (RuleSettings info : (ArrayList)entry.getValue()) {
                expirationDate.check(info.getPeriodBegin());
                startDateChecker.check(info.getPeriodEnd());
                for (RuleRestriction rr : info.getRestrictions()) {
                    if (!dateConditions.contains(rr.getProperty())) continue;
                    valueDate.check((Date)rr.getValue());
                }
            }
            dateShifted = dateShifted || expirationDate.hasShifted() || startDateChecker.hasShifted() || valueDate.hasShifted();
        }
        return dateShifted;
    }

    private void checkOrganizations(List<String> ignoredUsers, Date startDate, Date stopDate, DateShiftExchangeRequest data) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)"modified", (Object)startDate), SearchCriterion.le((String)"modified", (Object)stopDate)}));
        List organizationIndexes = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        for (OrganizationIndex orgIndex : organizationIndexes) {
            EntityContainer orgCtr = EntityStorage.get().resolve(orgIndex.getSource());
            ArrayList<EntityContainer<Organization>> versions = this.collectVerions(orgCtr);
            if (versions == null) continue;
            try {
                this.log.info(orgIndex.getName() == null ? "" : orgIndex.getName() + " uid:" + versions.get(0).getUid());
                this.log.info("checking creidt cards");
                if (!this.checkOrganizationCreditCard(versions)) continue;
                data.increment(Card.class.getCanonicalName());
            }
            catch (Exception exception) {}
        }
    }

    private boolean checkOrganizationCreditCard(ArrayList<EntityContainer<Organization>> versions) {
        HashMap versionsMap = new HashMap();
        for (EntityContainer<Organization> version : versions) {
            for (Card card : ((Organization)version.getEntity()).getCards()) {
                if (versionsMap.get(card.getNumber()) == null) {
                    ArrayList cards = new ArrayList();
                    versionsMap.put(card.getNumber(), cards);
                }
                ((ArrayList)versionsMap.get(card.getNumber())).add(card);
            }
        }
        boolean dateShifted = false;
        for (Map.Entry entry : versionsMap.entrySet()) {
            DateChecker expirationDate = new DateChecker((String)entry.getKey());
            for (Card card : (ArrayList)entry.getValue()) {
                expirationDate.check(card.getExpiration());
            }
            dateShifted = dateShifted || expirationDate.hasShifted();
        }
        return dateShifted;
    }

    private <T extends BaseEntity> ArrayList<EntityContainer<T>> collectVerions(EntityContainer<T> ctr) {
        if (ctr.getVersionInfo().getVersionNumber() == 0) {
            if (!this.ignoredUsers.contains(ctr.getModifiedBy())) {
                // empty if block
            }
        } else {
            EntityContainer olderCtr;
            ArrayList<EntityContainer<T>> versions = new ArrayList<EntityContainer<T>>(ctr.getVersionsCount());
            versions.add(ctr);
            for (int i = ctr.getVersionsCount() - 1; i > 0 && (olderCtr = EntityStorage.get().load(ctr.getEntityType(), ctr.getUid(), Integer.valueOf(i))).getModified().after(this.startDate); --i) {
                versions.add(olderCtr);
            }
            boolean allIgnored = true;
            for (EntityContainer entityContainer : versions) {
                if (this.ignoredUsers.contains(entityContainer.getModifiedBy())) continue;
                allIgnored = false;
            }
            if (allIgnored) {
                return null;
            }
            return versions;
        }
        return null;
    }

    private void checkPersons(List<String> ignoredUsers, Date startDate, Date stopDate, DateShiftExchangeRequest data) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)"modified", (Object)startDate), SearchCriterion.le((String)"modified", (Object)stopDate)}));
        List personIndexes = EntityStorage.get().search(PersonIndex.class, query).getData();
        for (PersonIndex personIndex : personIndexes) {
            EntityContainer personCtr = EntityStorage.get().resolve(personIndex.getSource());
            ArrayList<EntityContainer<Person>> versions = this.collectVerions(personCtr);
            if (versions == null) continue;
            try {
                this.log.info(personIndex.getName() == null ? "" : personIndex.getName() + " uid:" + versions.get(0).getUid());
                this.log.info("checking cards");
                if (this.checkCards(versions)) {
                    data.increment(Card.class.getCanonicalName());
                }
                this.log.info("checking passports");
                if (this.checkPassport(versions)) {
                    data.increment(Passport.class.getCanonicalName());
                }
                this.log.info("checking visas");
                if (this.checkVisa(versions)) {
                    data.increment(Passport.class.getCanonicalName());
                }
                this.log.info("checking employments");
                if (this.checkEmployments(versions)) {
                    data.increment(PersonEmployment.class.getCanonicalName());
                }
                this.log.info("checking sales points");
                if (this.checkSalesPoints(versions)) {
                    data.increment(PlaceOfSales.class.getCanonicalName());
                }
                this.log.info("checking reservation system references");
                if (!this.checkGdsReferences(versions)) continue;
                data.increment(GdsReference.class.getCanonicalName());
            }
            catch (Exception ex) {
                this.log.error("", (Throwable)ex);
            }
        }
    }

    private boolean checkCards(ArrayList<EntityContainer<Person>> versions) {
        HashMap cardVersionsMap = new HashMap();
        for (EntityContainer<Person> version : versions) {
            for (Card card : ((Person)version.getEntity()).getCards()) {
                if (cardVersionsMap.get(card.getNumber()) == null) {
                    ArrayList cards = new ArrayList();
                    cardVersionsMap.put(card.getNumber(), cards);
                }
                ((ArrayList)cardVersionsMap.get(card.getNumber())).add(card);
            }
        }
        boolean dateShifted = false;
        for (Map.Entry entry : cardVersionsMap.entrySet()) {
            DateChecker expirationDate = new DateChecker((String)entry.getKey() + " expirations");
            for (Card card : (ArrayList)entry.getValue()) {
                expirationDate.check(card.getExpiration());
            }
            dateShifted = dateShifted || expirationDate.hasShifted();
        }
        return dateShifted;
    }

    private boolean checkPassport(ArrayList<EntityContainer<Person>> versions) {
        HashMap versionsMap = new HashMap();
        for (EntityContainer<Person> version : versions) {
            for (Passport passport : ((Person)version.getEntity()).getPassports()) {
                if (versionsMap.get(passport.getNumber()) == null) {
                    ArrayList passports = new ArrayList();
                    versionsMap.put(passport.getNumber(), passports);
                }
                ((ArrayList)versionsMap.get(passport.getNumber())).add(passport);
            }
        }
        boolean dateShifted = false;
        for (Map.Entry entry : versionsMap.entrySet()) {
            DateChecker expirationDate = new DateChecker((String)entry.getKey() + " expiration");
            DateChecker issueDate = new DateChecker((String)entry.getKey() + " issue");
            DateChecker birthDate = new DateChecker((String)entry.getKey() + " birth");
            for (Passport passport : (ArrayList)entry.getValue()) {
                expirationDate.check(passport.getExpired());
                issueDate.check(passport.getIssued());
                birthDate.check(passport.getBirthday());
            }
            dateShifted = dateShifted || expirationDate.hasShifted() || issueDate.hasShifted() || birthDate.hasShifted();
        }
        return dateShifted;
    }

    private boolean checkVisa(ArrayList<EntityContainer<Person>> versions) {
        HashMap versionsMap = new HashMap();
        for (EntityContainer<Person> version : versions) {
            for (Visa visa : ((Person)version.getEntity()).getVisas()) {
                if (versionsMap.get(visa.getNumber()) == null) {
                    ArrayList visas = new ArrayList();
                    versionsMap.put(visa.getNumber(), visas);
                }
                ((ArrayList)versionsMap.get(visa.getNumber())).add(visa);
            }
        }
        boolean dateShifted = false;
        for (Map.Entry entry : versionsMap.entrySet()) {
            DateChecker begin = new DateChecker((String)entry.getKey() + " begin");
            DateChecker expired = new DateChecker((String)entry.getKey() + " expired");
            DateChecker issue = new DateChecker((String)entry.getKey() + " issue");
            for (Visa visa : (ArrayList)entry.getValue()) {
                begin.check(visa.getStartDate());
                expired.check(visa.getEndDate());
                issue.check(visa.getIssueDate());
            }
            dateShifted = dateShifted || begin.hasShifted() || expired.hasShifted() || issue.hasShifted();
        }
        return dateShifted;
    }

    private boolean checkEmployments(ArrayList<EntityContainer<Person>> versions) {
        HashMap versionsMap = new HashMap();
        for (EntityContainer<Person> version : versions) {
            for (PersonEmployment empl : ((Person)version.getEntity()).getEmployments()) {
                if (versionsMap.get(empl.getOrganization()) == null) {
                    ArrayList empls = new ArrayList();
                    versionsMap.put(empl.getOrganization(), empls);
                }
                ((ArrayList)versionsMap.get(empl.getOrganization())).add(empl);
            }
        }
        boolean dateShifted = false;
        for (Map.Entry entry : versionsMap.entrySet()) {
            DateChecker begin = new DateChecker(((EntityReference)entry.getKey()).getCaption() + " begin");
            DateChecker end = new DateChecker(((EntityReference)entry.getKey()).getCaption() + " end");
            for (PersonEmployment empl : (ArrayList)entry.getValue()) {
                begin.check(empl.getOpened());
                end.check(empl.getClosed());
            }
            dateShifted = dateShifted || begin.hasShifted() || end.hasShifted();
        }
        return dateShifted;
    }

    private boolean checkSalesPoints(ArrayList<EntityContainer<Person>> versions) {
        HashMap versionsMap = new HashMap();
        for (EntityContainer<Person> version : versions) {
            for (PlaceOfSales pos : ((Person)version.getEntity()).getSalesPoints()) {
                if (versionsMap.get(pos.getSalesPoint()) == null) {
                    ArrayList poss = new ArrayList();
                    versionsMap.put(pos.getSalesPoint(), poss);
                }
                ((ArrayList)versionsMap.get(pos.getSalesPoint())).add(pos);
            }
        }
        boolean dateShifted = false;
        for (Map.Entry entry : versionsMap.entrySet()) {
            DateChecker begin = new DateChecker(((EntityReference)entry.getKey()).getCaption() + " begin");
            DateChecker end = new DateChecker(((EntityReference)entry.getKey()).getCaption() + " end");
            for (PlaceOfSales pos : (ArrayList)entry.getValue()) {
                begin.check(pos.getOpened());
                end.check(pos.getClosed());
            }
            dateShifted = dateShifted || begin.hasShifted() || end.hasShifted();
        }
        return dateShifted;
    }

    private boolean checkGdsReferences(ArrayList<EntityContainer<Person>> versions) {
        HashMap versionsMap = new HashMap();
        for (EntityContainer<Person> version : versions) {
            for (GdsReference pos : ((Person)version.getEntity()).getGdsReferences()) {
                if (versionsMap.get(pos.getReference()) == null) {
                    ArrayList poss = new ArrayList();
                    versionsMap.put(pos.getReference(), poss);
                }
                ((ArrayList)versionsMap.get(pos.getReference())).add(pos);
            }
        }
        boolean dateShifted = false;
        for (Map.Entry entry : versionsMap.entrySet()) {
            DateChecker begin = new DateChecker((String)entry.getKey() + " begin");
            DateChecker end = new DateChecker((String)entry.getKey() + " end");
            for (GdsReference pos : (ArrayList)entry.getValue()) {
                begin.check(pos.getOpened());
                end.check(pos.getClosed());
            }
            dateShifted = dateShifted || begin.hasShifted() || end.hasShifted();
        }
        return dateShifted;
    }

    static {
        dateConditions.add((RuleProperty)Properties.ARRIVAL);
        dateConditions.add((RuleProperty)Properties.DEPARTURE);
        dateConditions.add((RuleProperty)Properties.ISSUED);
        dateConditions.add((RuleProperty)HotelProperties.CHECK_IN_DATE);
    }

    class DateChecker {
        private final String name;
        private Date firstDate;
        private boolean dateShifted = false;

        public DateChecker(String newName) {
            this.name = newName;
        }

        public void check(Date date) {
            if (this.firstDate == null) {
                this.firstDate = date;
            } else if (date != null && this.firstDate.compareTo(date) != 0) {
                this.dateShifted = true;
                DateShiftCheckTask.this.log.info(this.name + ": date shifted from " + this.firstDate.toString() + " to " + date.toString());
                this.firstDate = date;
            }
        }

        public boolean hasShifted() {
            return this.dateShifted;
        }
    }
}

