/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.standard.helpers.SystemSettingsHelper;
import com.gridnine.xtrip.common.model.system.SecurityAccountPolicySettings;
import com.gridnine.xtrip.common.model.system.SecuritySettings;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import java.util.Date;
import java.util.Optional;

public class DeactivateUserAccountsTask
extends BaseScheduledTask {
    protected void doJob() throws Exception {
        Date now = new Date();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UserAccount.Property.active.name(), (Object)Boolean.TRUE));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)UserAccount.Property.loginName.name(), (Object)AclHelper.system.getId()));
        SearchCriterion expiryDateCriterion = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)UserAccount.Property.expiryDate.name(), null), SearchCriterion.lt((String)UserAccount.Property.expiryDate.name(), (Object)now)});
        Integer days = Optional.ofNullable(SystemSettingsHelper.getSecuritySettings()).map(SecuritySettings::getAccountPolicySettings).map(SecurityAccountPolicySettings::getDeactivateAfterInactivityDays).orElse(null);
        if (days != null) {
            Date activityThreshold = MiscUtil.addDaysToDate((Date)now, (int)(-days.intValue()));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{expiryDateCriterion, SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)UserAccount.Property.lastLoginDate.name(), null), SearchCriterion.lt((String)UserAccount.Property.lastLoginDate.name(), (Object)activityThreshold)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)UserAccount.Property.lastLoginDate.name(), null), SearchCriterion.ne((String)UserAccount.Property.createDate.name(), null), SearchCriterion.lt((String)UserAccount.Property.createDate.name(), (Object)activityThreshold)})}));
        } else {
            query.getCriteria().getCriterions().add(expiryDateCriterion);
        }
        query.getPreferredProperties().add("uid");
        for (UserAccount ua : AssetsStorage.get().search(UserAccount.class, query).getData()) {
            ua = (UserAccount)AssetsStorage.get().load(UserAccount.class, ua.getUid());
            if (ua == null) continue;
            ua.setActive(false);
            AssetsStorage.get().save((BaseAsset)ua);
        }
    }
}

