/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.CardIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.BaseScheduledTask;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DeleteExpiredCardsTask
extends BaseScheduledTask {
    protected void doJob() throws Exception {
        this.log.debug("DeleteExpiredCardsTask started");
        if (!CirHelper.isEnabled()) {
            this.log.debug("Cir is not enabled - cards will not be deleted");
            return;
        }
        Date firstDayOfThisMonth = this.firstDayOfThisMonth();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.lt((String)CardIndex.Property.expiration.name(), (Object)firstDayOfThisMonth));
        List indices = EntityStorage.get().search(CardIndex.class, query).getData();
        this.log.debug(indices.size() + " expired cards found");
        ArrayList<String> processedProfilesUids = new ArrayList<String>();
        for (CardIndex index : indices) {
            if (index.getSource() == null || processedProfilesUids.contains(index.getSource().getUid())) continue;
            processedProfilesUids.add(index.getSource().getUid());
            EntityContainer cont = EntityStorage.get().resolve(index.getSource());
            if (cont == null) continue;
            BaseProfile profile = (BaseProfile)cont.getEntity();
            if (profile instanceof Organization) {
                Organization org = (Organization)profile;
                this.deleteExpiredCards(org.getCards(), firstDayOfThisMonth);
            } else if (profile instanceof Person) {
                Person per = (Person)profile;
                this.deleteExpiredCards(per.getCards(), firstDayOfThisMonth);
            }
            this.save((EntityContainer<BaseProfile>)cont);
            this.log.debug("Cards were deleted from profile with uid: " + profile.getUid());
        }
        this.log.debug("DeleteExpiredCardsTask finished");
    }

    private Date firstDayOfThisMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private void deleteExpiredCards(List<Card> cards, Date date) {
        cards.removeIf(card -> card.getExpiration() != null && card.getExpiration().before(date));
    }

    private void save(EntityContainer<BaseProfile> profile) {
        VersionInfo info = profile.getVersionInfo();
        info.setDataSource("server");
        info.setVersionNotes("DeleteExpiredCardsTask");
        EntityStorage.get().save(profile, true);
    }
}

