/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.OpeningBalance;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.DeleteOldTransactionsTaskConfiguration;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class DeleteOldTransactionsTask
extends BaseLongRunningTask<DeleteOldTransactionsTaskConfiguration> {
    private Date operationDate;
    private Date calculationDate;

    @Override
    public void configure(DeleteOldTransactionsTaskConfiguration configuration) throws Exception {
        this.operationDate = configuration.getOperationDate();
        this.calculationDate = configuration.getCalculationDate();
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeDate((Element)elm, (String)"operationDate", (Date)this.operationDate);
        XHelper.writeDate((Element)elm, (String)"calculationDate", (Date)this.calculationDate);
    }

    public void fromXML(Element elm) throws Exception {
        this.operationDate = XHelper.readDate((Element)elm, (String)"operationDate");
        this.calculationDate = XHelper.readDate((Element)elm, (String)"calculationDate");
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439 (\u043d\u043e\u0432\u043e\u0433\u043e \u0444\u0438\u043d.\u0431\u043b\u043e\u043a\u0430)", (Object[])new Object[0]);
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0414\u0430\u0442\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438: {0}", (Object[])new Object[]{this.operationDate}));
        callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0414\u0430\u0442\u0430 \u0440\u0430\u0441\u0447\u0435\u0442\u0430: {0}", (Object[])new Object[]{this.calculationDate}));
        this.log.debug("task started, operationDate = {}, calculationDate = {}", (Object)this.operationDate, (Object)this.calculationDate);
        SearchQuery balanceQuery = new SearchQuery();
        balanceQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.operationDate.name(), (Object)this.operationDate));
        balanceQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.calculationDate.name(), (Object)this.calculationDate));
        balanceQuery.getCriteria().getCriterions().add(SearchCriterion.ne((String)OpeningBalance.Property.auxiliary.name(), (Object)true));
        List balances = AssetsStorage.get().search(OpeningBalance.class, balanceQuery).getData();
        this.log.debug("found {} balances", (Object)balances.size());
        for (OpeningBalance balance : balances) {
            this.log.debug("deleting transactions for {}/{}/{}/{}/{}", new Object[]{balance.getOrganizationUid(), balance.getAccountUid(), balance.getDimension1(), balance.getDimension2(), balance.getDimension3()});
            SearchQuery transactionQuery = new SearchQuery();
            transactionQuery.getCriteria().getCriterions().add(SearchCriterion.lt((String)TransactionSplitIndex.Property.operationDate.name(), (Object)this.operationDate));
            transactionQuery.getCriteria().getCriterions().add(SearchCriterion.lt((String)TransactionSplitIndex.Property.calculationDate.name(), (Object)this.calculationDate));
            transactionQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.organization.name(), (Object)new EntityReference(balance.getOrganizationUid(), Organization.class, null)));
            transactionQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.accountUid.name(), (Object)balance.getAccountUid()));
            transactionQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension1.name(), (Object)balance.getDimension1()));
            transactionQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension2.name(), (Object)balance.getDimension2()));
            transactionQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension3.name(), (Object)balance.getDimension3()));
            transactionQuery.getPreferredProperties().add(TransactionSplitIndex.Property.bookingUid.name());
            List transactions = EntityStorage.get().search(TransactionSplitIndex.class, transactionQuery).getData();
            this.log.debug("found {} transactions", (Object)transactions.size());
            Map<String, List<TransactionSplitIndex>> groups = transactions.stream().collect(Collectors.groupingBy(TransactionSplitIndex::getBookingUid));
            for (Map.Entry<String, List<TransactionSplitIndex>> group : groups.entrySet()) {
                this.log.debug("analyzing {} transactions for booking uid {}", (Object)group.getValue().size(), (Object)group.getKey());
                if (group.getKey() != null) {
                    SearchQuery bookingCheckQuery = new SearchQuery();
                    bookingCheckQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ArchivedProductIndex.Property.bookingContainerUid.name(), (Object)group.getKey()));
                    bookingCheckQuery.setLimit(1);
                    if (!EntityStorage.get().search(ArchivedProductIndex.class, bookingCheckQuery).getData().isEmpty()) {
                        this.log.debug("booking found for uid {}, {} transactions will not be deleted", (Object)group.getValue().size(), (Object)group.getKey());
                        continue;
                    }
                }
                for (TransactionSplitIndex transaction : group.getValue()) {
                    this.log.debug("deleting transaction {}", (Object)transaction.getSource().getUid());
                    EntityStorage.get().delete(transaction.getSource());
                }
            }
        }
    }
}

