/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryItem;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class DeliveryItemsUpdateTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.DeliveryItemsUpdateTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("delivery items update started");
        SearchQuery query = new SearchQuery();
        Set bookingFileReferences = EntityStorage.get().search(DeliveryIndex.class, query).getData().stream().map(item -> item.getSource()).collect(Collectors.toSet());
        int count = bookingFileReferences.size();
        int n = 0;
        for (EntityReference bookingFileReference : bookingFileReferences) {
            EntityContainer bookingFileContainer;
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            byte progress = (byte)(100 * n / count);
            this.log.debug(String.format("processing booking file %s, %s of %s (%s%%)", bookingFileReference, String.valueOf(n), String.valueOf(count), String.valueOf(progress)));
            if (n % 10 == 0) {
                callback.updateProgress(progress);
            }
            if ((bookingFileContainer = EntityStorage.get().resolve(bookingFileReference)) == null) continue;
            List products = ((BookingFile)bookingFileContainer.getEntity()).getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(item -> item instanceof Delivery).map(item -> (Delivery)item).collect(Collectors.toList());
            boolean save = false;
            for (Delivery product : products) {
                for (DeliveryItem deliveryItem : product.getDeliveryItems()) {
                    if (deliveryItem.getType() != null) continue;
                    if (deliveryItem.getBooking() != null && deliveryItem.getProductUid() != null) {
                        deliveryItem.setType(DeliveryItemType.PRODUCT);
                        deliveryItem.setObject((Object)new NestedEntityReference(deliveryItem.getBooking(), deliveryItem.getProductUid(), BaseProduct.class, deliveryItem.getName()));
                    } else {
                        deliveryItem.setType(DeliveryItemType.SIMPLE);
                        deliveryItem.setObject((Object)deliveryItem.getName());
                    }
                    save = true;
                }
            }
            if (!save) continue;
            bookingFileContainer.getVersionInfo().setDataSource("delivery-items-update-task");
            EntityStorage.get().save(bookingFileContainer, true);
        }
        callback.taskFinished();
        this.log.debug("delivery items update finished");
    }
}

