/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Element;

public class DeliveryUpdateAddresseeTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.DeliveryUpdateAddresseeTask_updateAdressOnDelivery, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        try {
            SearchQuery query = new SearchQuery();
            query.getPreferredProperties().add(DeliveryIndex.Property.issueDate.name());
            query.getCriteria().getOrders().put(DeliveryIndex.Property.issueDate.name(), SortOrder.DESC);
            List data = EntityStorage.get().search(DeliveryIndex.class, query).getData();
            int total = data.size();
            for (int n = 0; n < total; ++n) {
                DeliveryIndex idx = (DeliveryIndex)data.get(n);
                if (this.isToBeStopped()) {
                    this.log.debug("task is interupted");
                    return;
                }
                try {
                    EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
                    Delivery delivery = (Delivery)BookingHelper.findProduct((BookingFile)((BookingFile)ctr.getEntity()), (String)idx.getNavigationKey());
                    if (delivery == null || delivery.getReservation().getBookingFile().getCustomerProfile() == null) continue;
                    EntityReference customer = delivery.getReservation().getBookingFile().getCustomerProfile();
                    delivery.setAddressee(customer);
                    delivery.setAddresseeName(customer.toString());
                    ctr.getVersionInfo().setDataSource("server");
                    ctr.getVersionInfo().setVersionNotes("created by " + MiscUtil.getSimpleClassName(this.getClass()));
                    EntityStorage.get().save(ctr, true);
                    if (n % 10 != 0) continue;
                    callback.updateProgress((byte)((double)n * 100.0 / (double)total));
                    continue;
                }
                catch (Exception e) {
                    this.log.error("unable to update delivery from " + idx.getSource(), (Throwable)e);
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.DeliveryUpdateAddresseeTask_cantUpdateDeliveryFormOrder, (Throwable)e, (Object[])new Object[]{idx.getSource()}));
                }
            }
        }
        catch (Exception e) {
            this.log.error("unable to update deliveries", (Throwable)e);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.DeliveryUpdateAddresseeTask_cantUpdateDelivery, (Throwable)e, (Object[])new Object[0]));
        }
        finally {
            callback.taskFinished();
        }
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }
}

