/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettingsIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.model.notification.service.EmailEventNotificationTask;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Element;

public class EmailEventNotificationFixTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.EmailEventNotificationFixTask_updateName, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        LogicalSession managedSession = null;
        try {
            managedSession = LogicalStorage.get().beginUnitOfWork();
            List settingsIndexs = EntityStorage.get().search(ScheduledTaskSettingsIndex.class, new SearchQuery()).getData();
            int count = 0;
            for (ScheduledTaskSettingsIndex index : settingsIndexs) {
                ScheduledTaskSettings taskSettings;
                EntityContainer entityContainer = EntityStorage.get().resolve(index.getSource());
                if (entityContainer == null || !(taskSettings = (ScheduledTaskSettings)entityContainer.getEntity()).getJobClass().equals(EmailEventNotificationTask.class.getName())) continue;
                taskSettings.setName("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 email \u043d\u0430\u043f\u043e\u043c\u0438\u043d\u0430\u043d\u0438\u0439");
                EntityStorage.get().save(entityContainer, false);
                ++count;
            }
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"Total ScheduledTaskSettings updated count: {0}", (Object[])new Object[]{count}));
        }
        finally {
            if (managedSession != null) {
                LogicalStorage.get().cancelUnitOfWork(managedSession);
            }
            this.log.error(String.format("unable to update ScheduledTaskSettings", new Object[0]));
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"error on update ScheduledTaskSettings", (Object[])new Object[0]));
        }
        callback.taskFinished();
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }
}

