/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class EnhanceClassOfServiceInRulesTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        Map<String, List<List<String>>> data = EnhanceClassOfServiceInRulesTask.findReferences(RuleSet.class.getName());
        int i = 0;
        for (Map.Entry<String, List<List<String>>> entry : data.entrySet()) {
            Class<?> entityClass = Class.forName(entry.getKey());
            List<List<String>> paths = entry.getValue();
            Set<String> uids = EnhanceClassOfServiceInRulesTask.collectUids(entry.getKey());
            int j = 0;
            for (String uid : uids) {
                EntityContainer ctr = EntityStorage.get().resolve(new EntityReference(uid, entityClass, null));
                boolean modified = false;
                for (RuleSet ruleSet : this.getRuleSets(ctr.getEntity(), paths)) {
                    if (ruleSet == null || ruleSet.getRules() == null) continue;
                    for (RuleSettings rs : ruleSet.getRules()) {
                        for (RuleRestriction rr : rs.getRestrictions()) {
                            if (!"SERVICE_CLASSES".equals(rr.getProperty().getId()) || rr.getValue() == null) continue;
                            List value = (List)rr.getValue();
                            if (value.contains(ClassOfService.ECONOMY) && !value.contains(ClassOfService.PREMIUM)) {
                                value.add(ClassOfService.PREMIUM);
                                modified = true;
                            }
                            if (value.contains(ClassOfService.BUSINESS) && !value.contains(ClassOfService.PREMIUM_BUSINESS)) {
                                value.add(ClassOfService.PREMIUM_BUSINESS);
                                modified = true;
                            }
                            if (!value.contains(ClassOfService.FIRST) || value.contains(ClassOfService.PREMIUM_FIRST)) continue;
                            value.add(ClassOfService.PREMIUM_FIRST);
                            modified = true;
                        }
                    }
                }
                if (modified) {
                    ctr.getVersionInfo().setDataSource("EnhanceClassOfServiceInRulesProcessTask");
                    EntityStorage.get().save(ctr, true);
                }
                this.log.debug(String.format("entity %s (%d of %d) uid %s (%d of %d) modified=%s", entry.getKey(), i, data.size(), uid, j, uids.size(), Boolean.toString(modified)));
                ++j;
            }
            ++i;
        }
        callback.taskFinished();
    }

    public void fromXML(Element elm) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u0412\u043d\u0435\u0434\u0440\u0435\u043d\u0438\u0435 \u043f\u0440\u0435\u043c\u0438\u0443\u043c \u043a\u043b\u0430\u0441\u0441\u043e\u0432 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f", (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    private static Map<String, List<List<String>>> findReferences(String entityId) {
        HashMap<String, List<List<String>>> data = new HashMap<String, List<List<String>>>();
        for (EntityType et : MetaRegistry.get().getEntities().values()) {
            Set collections;
            Set<String> entities = EnhanceClassOfServiceInRulesTask.findAllChildren(et.getId());
            entities.add(et.getId());
            Set properties = et.getProperties().values().stream().filter(p -> p.getType().equals(entityId)).collect(Collectors.toSet());
            if (!properties.isEmpty()) {
                for (Property property : properties) {
                    entities.stream().forEach(entity -> {
                        if (MetaRegistryHelper.getEntityType((String)entity).isRoot()) {
                            if (!data.containsKey(entity)) {
                                data.put((String)entity, new ArrayList());
                            }
                            ((List)data.get(entity)).add(new ArrayList<String>(Collections.singletonList(property.getId())));
                        } else {
                            Map<String, List<List<String>>> subdata = EnhanceClassOfServiceInRulesTask.findReferences(entity);
                            for (Map.Entry<String, List<List<String>>> entry : subdata.entrySet()) {
                                if (!data.containsKey(entry.getKey())) {
                                    data.put(entry.getKey(), new ArrayList());
                                }
                                entry.getValue().stream().forEach(path -> {
                                    path.add(property.getId());
                                    ((List)data.get(entry.getKey())).add(path);
                                });
                            }
                        }
                    });
                }
            }
            if ((collections = et.getCollections().values().stream().filter(ec -> ec.getElementType().equals(entityId)).collect(Collectors.toSet())).isEmpty()) continue;
            for (EntityCollection collection : collections) {
                entities.stream().forEach(entity -> {
                    if (MetaRegistryHelper.getEntityType((String)entity).isRoot()) {
                        if (!data.containsKey(entity)) {
                            data.put((String)entity, new ArrayList());
                        }
                        ((List)data.get(entity)).add(new ArrayList<String>(Collections.singletonList(collection.getId())));
                    } else {
                        Map<String, List<List<String>>> subdata = EnhanceClassOfServiceInRulesTask.findReferences(entity);
                        for (Map.Entry<String, List<List<String>>> entry : subdata.entrySet()) {
                            if (!data.containsKey(entry.getKey())) {
                                data.put(entry.getKey(), new ArrayList());
                            }
                            entry.getValue().stream().forEach(path -> {
                                path.add(collection.getId());
                                ((List)data.get(entry.getKey())).add(path);
                            });
                        }
                    }
                });
            }
        }
        return data;
    }

    private static Set<String> findAllChildren(String entityId) {
        Set immediateChildren = MetaRegistry.get().getEntities().values().stream().filter(et -> entityId.equals(et.getExtendsId())).map(et -> et.getId()).collect(Collectors.toSet());
        HashSet<String> result = new HashSet<String>();
        result.addAll(immediateChildren);
        immediateChildren.stream().forEach(child -> result.addAll(EnhanceClassOfServiceInRulesTask.findAllChildren(child)));
        return result;
    }

    private static Set<String> collectUids(String entityId) throws Exception {
        HashSet<String> result = new HashSet<String>();
        for (IndexType indexType : MetaRegistryHelper.getIndexes((EntityType)MetaRegistryHelper.getEntityType((String)entityId))) {
            SearchQuery query = new SearchQuery();
            query.getPreferredProperties().add("containerUid");
            List data = EntityStorage.get().search(Class.forName(indexType.getId()), query).getData();
            for (Object obj : data) {
                EntityIndex idx = (EntityIndex)obj;
                result.add(idx.getSource().getUid());
            }
        }
        return result;
    }

    private Collection<RuleSet> getRuleSets(BaseEntity entity, List<List<String>> paths) {
        HashSet<RuleSet> result = new HashSet<RuleSet>();
        block0: for (List<String> path : paths) {
            Object obj = entity;
            for (String pathElm : path) {
                if ((obj = ((Introspectable)obj).getValue(pathElm)) != null) continue;
                continue block0;
            }
            result.add((RuleSet)obj);
        }
        return result;
    }
}

