/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.erasure.CustomerErasureItem;
import com.gridnine.xtrip.common.model.erasure.ErasureItem;
import com.gridnine.xtrip.common.model.erasure.ErasureRequest;
import com.gridnine.xtrip.common.model.erasure.ErasureRequestStatus;
import com.gridnine.xtrip.common.model.erasure.OrderErasureItem;
import com.gridnine.xtrip.common.model.erasure.PersonErasureItem;
import com.gridnine.xtrip.common.model.erasure.TravellerErasureItem;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.model.helpers.Anonymizer;
import com.gridnine.xtrip.server.model.tasks.AbortException;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.WontDoJobException;
import com.gridnine.xtrip.server.model.tasks.standard.AbstractErasureTask;
import java.util.ArrayList;
import java.util.List;

public class ErasureProcessingTask
extends AbstractErasureTask {
    private static final String SOURCE = "erasure-processing-task";

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        LockUtil.lock((EntityReference)this.ref, ctr -> {
            ErasureRequest request = (ErasureRequest)ctr.getEntity();
            ErasureRequestStatus resultingStatus = ErasureRequestStatus.PROCESSING_DONE;
            this.requestNumber = request.getNumber();
            try {
                this.validate((EntityContainer<ErasureRequest>)ctr);
                this.auditInfo("processing started");
                request.setStatus(ErasureRequestStatus.PROCESSING);
                this.save((EntityContainer<ErasureRequest>)ctr, SOURCE, callback);
                Anonymizer anonymizer = Anonymizer.getInstance();
                List<ErasureItem> items = this.itemsToProcess(request);
                int numOfItems = items.size();
                for (int i = 0; i < numOfItems; ++i) {
                    if (this.isToBeStopped()) {
                        throw new AbortException();
                    }
                    ErasureItem item = items.get(i);
                    switch (item.getType()) {
                        case PERSON: {
                            anonymizer.anonymizePerson((EntityReference<Person>)((PersonErasureItem)item).getReference());
                            item.setProcessed(true);
                            break;
                        }
                        case ORDER: {
                            EntityReference target = ((OrderErasureItem)item).getReference();
                            if (BookingFile.class.equals((Object)target.getType())) {
                                anonymizer.anonymizeOrder((EntityReference<BookingFile>)target);
                            } else {
                                anonymizer.anonymizeOrderInArchive((EntityReference<ArchivedBooking>)target);
                            }
                            item.setProcessed(true);
                            break;
                        }
                        case CUSTOMER: {
                            EntityReference orderRef = ((CustomerErasureItem)item).getOrderReference();
                            if (BookingFile.class.equals((Object)orderRef.getType())) {
                                anonymizer.anonymizeCustomer((EntityReference<BookingFile>)orderRef);
                            } else {
                                anonymizer.anonymizeCustomerInArchive((EntityReference<ArchivedBooking>)orderRef);
                            }
                            item.setProcessed(true);
                            break;
                        }
                        case TRAVELLER: {
                            EntityReference orderRef = ((TravellerErasureItem)item).getOrderReference();
                            int versionNumber = ((TravellerErasureItem)item).getOrderVersion();
                            String travellerUid = ((TravellerErasureItem)item).getTravellerUid();
                            if (BookingFile.class.equals((Object)orderRef.getType())) {
                                anonymizer.anonymizeTraveller((EntityReference<BookingFile>)orderRef, versionNumber, travellerUid);
                            } else {
                                anonymizer.anonymizeTravellerInArchive((EntityReference<ArchivedBooking>)orderRef, versionNumber, travellerUid);
                            }
                            item.setProcessed(true);
                            break;
                        }
                        default: {
                            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)("search result item of unsupported type: " + item.getType().name()), (Object[])new Object[0]));
                        }
                    }
                    callback.updateProgress((byte)((i + 1) * 100 / numOfItems));
                }
                callback.updateProgress((byte)100);
                this.auditInfo("processing finished");
            }
            catch (WontDoJobException e) {
                resultingStatus = request.getStatus();
                this.log(e, callback);
            }
            catch (AbortException e) {
                resultingStatus = ErasureRequestStatus.PROCESSING_INTERRUPTED;
                this.logAbortion(callback);
            }
            catch (Throwable t) {
                resultingStatus = ErasureRequestStatus.PROCESSING_INTERRUPTED;
                this.logError(t, callback);
            }
            finally {
                request.setStatus(resultingStatus);
                ((ErasureRequest)ctr.getEntity()).setActiveTask(null);
                this.save((EntityContainer<ErasureRequest>)ctr, SOURCE, callback);
                callback.taskFinished();
            }
        });
    }

    private List<ErasureItem> itemsToProcess(ErasureRequest request) {
        ArrayList<ErasureItem> result = new ArrayList<ErasureItem>(request.getSearchResult().size());
        for (ErasureItem item : result) {
            if (!item.isIncludedInProcessing() || item.isProcessed()) continue;
            result.add(item);
        }
        return result;
    }

    private void validate(EntityContainer<ErasureRequest> ctr) {
        if (ctr == null) {
            throw new WontDoJobException("erasure request is required");
        }
        ErasureRequest request = (ErasureRequest)ctr.getEntity();
        switch (request.getStatus()) {
            case SEARCH_DONE: 
            case PROCESSING_INTERRUPTED: {
                break;
            }
            default: {
                throw new WontDoJobException("request is in unappropriate status: " + request.getStatus());
            }
        }
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"ErasureProcessingTask_Description", (Object[])new Object[]{this.requestNumber});
    }
}

