/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.PersonPassportIndex;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHelper;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.StorageUtil;
import com.gridnine.xtrip.common.model.erasure.BatchErasureParams;
import com.gridnine.xtrip.common.model.erasure.CompanyCriterion;
import com.gridnine.xtrip.common.model.erasure.Correspondence;
import com.gridnine.xtrip.common.model.erasure.CustomerErasureItem;
import com.gridnine.xtrip.common.model.erasure.EmailCriterion;
import com.gridnine.xtrip.common.model.erasure.ErasureItem;
import com.gridnine.xtrip.common.model.erasure.ErasureRequest;
import com.gridnine.xtrip.common.model.erasure.ErasureRequestStatus;
import com.gridnine.xtrip.common.model.erasure.ErasureSearchCriterion;
import com.gridnine.xtrip.common.model.erasure.ErasureSearchCriterionType;
import com.gridnine.xtrip.common.model.erasure.GenericErasureParams;
import com.gridnine.xtrip.common.model.erasure.IndividualErasureParams;
import com.gridnine.xtrip.common.model.erasure.OrderErasureItem;
import com.gridnine.xtrip.common.model.erasure.PassportCriterion;
import com.gridnine.xtrip.common.model.erasure.PersonErasureItem;
import com.gridnine.xtrip.common.model.erasure.PersonNameCriterion;
import com.gridnine.xtrip.common.model.erasure.PersonRefCriterion;
import com.gridnine.xtrip.common.model.erasure.PhoneCriterion;
import com.gridnine.xtrip.common.model.erasure.TravellerErasureItem;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.helpers.erasure.ErasureHelper;
import com.gridnine.xtrip.server.model.tasks.AbortException;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.WontDoJobException;
import com.gridnine.xtrip.server.model.tasks.standard.AbstractErasureTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

public class ErasureSearchingTask
extends AbstractErasureTask {
    private static final String SOURCE = "erasure-searching-task";
    private static final String STATE = "state";
    private State state;

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        LockUtil.lock((EntityReference)this.ref, ctr -> {
            ErasureRequest request = (ErasureRequest)ctr.getEntity();
            ErasureRequestStatus resultingStatus = ErasureRequestStatus.SEARCH_DONE;
            this.requestNumber = request.getNumber();
            try {
                this.validate((EntityContainer<ErasureRequest>)ctr);
                this.state = this.actualState(request);
                if (this.state.stage != Stage.DONE) {
                    switch (this.state.mode) {
                        case INDIVIDUAL: {
                            this.auditInfo("individual searching started");
                            request.setStatus(ErasureRequestStatus.SEARCHING);
                            this.save((EntityContainer<ErasureRequest>)ctr, SOURCE, callback);
                            this.individualSearch(request);
                            break;
                        }
                        case BATCH: {
                            this.auditInfo("batch searching started");
                            request.setStatus(ErasureRequestStatus.SEARCHING);
                            this.save((EntityContainer<ErasureRequest>)ctr, SOURCE, callback);
                            this.batchSearch(request);
                            break;
                        }
                        default: {
                            throw new WontDoJobException("unsupported state: " + this.state);
                        }
                    }
                    callback.updateProgress((byte)100);
                    this.auditInfo("searching finished");
                }
            }
            catch (WontDoJobException e) {
                resultingStatus = request.getStatus();
                this.log(e, callback);
            }
            catch (AbortException e) {
                resultingStatus = ErasureRequestStatus.SEARCH_INTERRUPTED;
                this.logAbortion(callback);
            }
            catch (Throwable t) {
                resultingStatus = ErasureRequestStatus.SEARCH_INTERRUPTED;
                this.logError(t, callback);
            }
            finally {
                request.setStatus(resultingStatus);
                request.setActiveTask(null);
                this.save((EntityContainer<ErasureRequest>)ctr, SOURCE, callback);
                callback.taskFinished();
            }
        });
    }

    private State actualState(ErasureRequest request) {
        State result = new State();
        GenericErasureParams params = request.getParams();
        switch (params.getType()) {
            case BATCH: {
                result.mode = Mode.BATCH;
                break;
            }
            case INDIVIDUAL: {
                result.mode = Mode.INDIVIDUAL;
                break;
            }
            default: {
                throw new WontDoJobException("unsupported parameter type: " + params.getType());
            }
        }
        switch (request.getStatus()) {
            case INITIAL: 
            case SEARCH_DONE: {
                break;
            }
            case SEARCH_INTERRUPTED: {
                if (this.state == null || this.state.mode != result.mode) break;
                result.stage = this.state.stage;
                break;
            }
            default: {
                throw new WontDoJobException("request is in unappropriate status: " + request.getStatus());
            }
        }
        return result;
    }

    private void individualSearch(ErasureRequest request) {
        IndividualErasureParams params = (IndividualErasureParams)request.getParams();
        this.state.stage = this.state.stage == null ? Stage.SEARCHING_FOR_PERSONS : this.state.stage;
        switch (this.state.stage) {
            case SEARCHING_FOR_PERSONS: {
                ErasureHelper.getInstance().reset(request);
                IndividualPersonSearchResult result = this.searchForPersons(params);
                request.getSearchResult().addAll(result.items);
                request.setParams((GenericErasureParams)this.merge(params, result.extraParams));
                this.state.stage = Stage.SEARCHING_FOR_ORDERS;
                if (this.isToBeStopped()) {
                    throw new AbortException();
                }
                this.individualSearch(request);
                break;
            }
            case SEARCHING_FOR_ORDERS: {
                List<CompanyCriterion> clientCriteria = this.relevantOrderClientCriteria(params);
                List<ErasureItem> items = this.searchForOrders(params, clientCriteria);
                request.getSearchResult().addAll(items);
                items = this.searchForArchivedOrders(params, clientCriteria);
                request.getSearchResult().addAll(items);
                this.state.stage = Stage.DONE;
                break;
            }
            default: {
                throw new RuntimeException("invalid task stage: " + this.state.toString());
            }
        }
    }

    private void batchSearch(ErasureRequest request) {
        BatchErasureParams params = (BatchErasureParams)request.getParams();
        this.state.stage = this.state.stage == null ? Stage.SEARCHING_FOR_PERSONS : this.state.stage;
        switch (this.state.stage) {
            case SEARCHING_FOR_PERSONS: {
                ErasureHelper.getInstance().reset(request);
                List<ErasureItem> items = this.searchForPersons(params.getCompany());
                request.getSearchResult().addAll(items);
                this.state.stage = Stage.SEARCHING_FOR_ORDERS;
                if (this.isToBeStopped()) {
                    throw new AbortException();
                }
                this.batchSearch(request);
                break;
            }
            case SEARCHING_FOR_ORDERS: {
                List<ErasureItem> items = this.searchForOrders(params.getCompany());
                request.getSearchResult().addAll(items);
                if (this.isToBeStopped()) {
                    throw new AbortException();
                }
                items = this.searchForArchivedOrders(params.getCompany());
                request.getSearchResult().addAll(items);
                this.state.stage = Stage.DONE;
                break;
            }
            default: {
                throw new RuntimeException("invalid task stage: " + this.state.toString());
            }
        }
    }

    private IndividualPersonSearchResult searchForPersons(IndividualErasureParams params) {
        IndividualPersonSearchResult result = new IndividualPersonSearchResult();
        List<PassportCriterion> passportCriterions = ErasureHelper.getInstance().criterions(params, ErasureSearchCriterionType.PASSPORT);
        List<EntityReference<Person>> candidates = this.searchByPassport(passportCriterions);
        result.items = new ArrayList<ErasureItem>(candidates.size());
        ErasureHelper helper = ErasureHelper.getInstance();
        for (EntityReference<Person> ref : candidates) {
            List<Correspondence> correspondences;
            EntityContainer ctr = ref != null ? EntityStorage.get().resolve(ref) : null;
            if (ctr == null || (correspondences = helper.compare((EntityContainer<Person>)ctr, params)) == null) continue;
            PersonErasureItem item = new PersonErasureItem();
            item.setReference(ref);
            item.getCorrespondences().addAll(correspondences);
            result.items.add((ErasureItem)item);
            IndividualErasureParams extraParams = this.extraParams((EntityContainer<Person>)ctr);
            result.extraParams = this.merge(result.extraParams, extraParams);
        }
        return result;
    }

    private List<EntityReference<Person>> searchByPassport(List<PassportCriterion> passports) {
        ArrayList<EntityReference<Person>> result = new ArrayList<EntityReference<Person>>();
        for (PassportCriterion passport : passports) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonPassportIndex.Property.passportNumber.name(), (Object)passport.getNumber()));
            List selection = EntityStorage.get().search(PersonPassportIndex.class, query).getData();
            for (PersonPassportIndex idx : selection) {
                result.add((EntityReference<Person>)idx.getSource());
            }
        }
        return result;
    }

    private List<ErasureItem> searchForPersons(CompanyCriterion criterion) {
        EntityReference organization = criterion.getProfile();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)organization.getUid()));
        List selection = EntityStorage.get().search(PersonIndex.class, query).getData();
        ArrayList<ErasureItem> result = new ArrayList<ErasureItem>(selection.size());
        String organizationName = null;
        for (PersonIndex idx : selection) {
            if (idx.getEmploymentsUids().size() > 1) continue;
            PersonErasureItem item = new PersonErasureItem();
            item.setReference(idx.getSource());
            organizationName = organizationName == null ? this.organizationName((EntityReference<Organization>)organization) : organizationName;
            item.getCorrespondences().add(ErasureHelper.newCorrespondence("ErasureItemKey_Employment", organizationName, (ErasureSearchCriterion)criterion));
            result.add((ErasureItem)item);
        }
        return result;
    }

    private String organizationName(EntityReference<Organization> ref) {
        String result = ref.getCaption();
        if (StringUtils.isEmpty((String)result)) {
            Organization organization = (Organization)StorageUtil.getEntity(ref);
            result = ProfileHelper.getFullName((Organization)organization, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
        }
        return result;
    }

    private List<ErasureItem> searchForOrders(IndividualErasureParams params, List<CompanyCriterion> clientCriteria) {
        ArrayList<ErasureItem> result = new ArrayList<ErasureItem>();
        for (CompanyCriterion criterion : clientCriteria) {
            if (this.isToBeStopped()) {
                throw new AbortException();
            }
            List<BookingFileIndex> relevantOrders = this.searchOrdersByClient((EntityReference<Organization>)criterion.getProfile());
            for (BookingFileIndex idx : relevantOrders) {
                if (this.isToBeStopped()) {
                    throw new AbortException();
                }
                EntityReference ref = idx.getSource();
                BookingFile bookingFile = (BookingFile)StorageUtil.getEntity((EntityReference)ref);
                List<ErasureItem> erasureItems = this.compare((EntityReference<? extends BaseEntity>)ref, bookingFile, params);
                result.addAll(erasureItems);
            }
        }
        return result;
    }

    public List<ErasureItem> compare(EntityReference<? extends BaseEntity> orderReference, BookingFile bookingFile, IndividualErasureParams params) {
        ArrayList<Object> result = null;
        ErasureHelper helper = ErasureHelper.getInstance();
        for (Traveller traveller : bookingFile.getTravellers()) {
            List<Correspondence> corrs = helper.compare(traveller, params);
            if (corrs == null) continue;
            result = result == null ? new ArrayList<Object>(1) : result;
            TravellerErasureItem item = new TravellerErasureItem();
            item.setOrderReference(orderReference);
            item.getCorrespondences().addAll(corrs);
            result.add(item);
        }
        List<Correspondence> corrs = helper.compare(bookingFile.getCustomer(), params);
        if (corrs != null) {
            result = result == null ? new ArrayList<Object>(1) : result;
            CustomerErasureItem item = new CustomerErasureItem();
            item.setOrderReference(orderReference);
            item.getCorrespondences().addAll(corrs);
            result.add(item);
        }
        return result == null ? Collections.emptyList() : result;
    }

    private List<CompanyCriterion> relevantOrderClientCriteria(IndividualErasureParams params) {
        ArrayList<CompanyCriterion> result = new ArrayList<CompanyCriterion>(ErasureHelper.getInstance().criterions(params, ErasureSearchCriterionType.COMPANY));
        EntityReference retailClient = ProfileHelper.findRetailProfileReference();
        if (retailClient != null) {
            CompanyCriterion criterion = new CompanyCriterion();
            criterion.setProfile(retailClient);
            result.add(criterion);
        }
        result.add(null);
        return result;
    }

    private List<BookingFileIndex> searchOrdersByClient(EntityReference<Organization> client) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), client));
        List result = EntityStorage.get().search(BookingFileIndex.class, query).getData();
        return result;
    }

    private List<ErasureItem> searchForOrders(CompanyCriterion criterion) {
        EntityReference organization = criterion.getProfile();
        List<BookingFileIndex> selection = this.searchOrdersByClient((EntityReference<Organization>)organization);
        ArrayList<ErasureItem> result = new ArrayList<ErasureItem>(selection.size());
        String organizationName = selection.isEmpty() ? null : this.organizationName((EntityReference<Organization>)organization);
        for (BookingFileIndex idx : selection) {
            OrderErasureItem item = new OrderErasureItem();
            item.setReference(idx.getSource());
            item.getCorrespondences().add(ErasureHelper.newCorrespondence("ErasureItemKey_Client", organizationName, (ErasureSearchCriterion)criterion));
            result.add((ErasureItem)item);
        }
        return result;
    }

    private List<ErasureItem> searchForArchivedOrders(IndividualErasureParams params, List<CompanyCriterion> clientCriteria) {
        ArrayList<ErasureItem> result = new ArrayList<ErasureItem>();
        Iterator<CompanyCriterion> iterator = clientCriteria.iterator();
        if (iterator.hasNext()) {
            CompanyCriterion criterion = iterator.next();
            if (this.isToBeStopped()) {
                throw new AbortException();
            }
            EntityReference organization = criterion.getProfile();
            List<ArchivedProductIndex> selection = this.searchArchivedOrdersByClient((EntityReference<Organization>)organization);
            for (ArchivedProductIndex idx : selection) {
                if (this.isToBeStopped()) {
                    throw new AbortException();
                }
                BookingFile bookingFile = this.bookingFile(idx);
                if (bookingFile == null) continue;
                List<ErasureItem> erasureItems = this.compare((EntityReference<? extends BaseEntity>)idx.getSource(), bookingFile, params);
                result.addAll(erasureItems);
            }
            return result;
        }
        return result;
    }

    private BookingFile bookingFile(ArchivedProductIndex idx) {
        ArchivedBooking archivedBooking = (ArchivedBooking)StorageUtil.getEntity((EntityReference)idx.getSource());
        EntityContainer ctr = archivedBooking != null ? ArchivedBookingHelper.getBookingContainer((ArchivedBooking)archivedBooking) : null;
        return ctr != null ? (BookingFile)ctr.getEntity() : null;
    }

    private List<ErasureItem> searchForArchivedOrders(CompanyCriterion criterion) {
        EntityReference organization = criterion.getProfile();
        List<ArchivedProductIndex> selection = this.searchArchivedOrdersByClient((EntityReference<Organization>)organization);
        ArrayList<ErasureItem> result = new ArrayList<ErasureItem>(selection.size());
        String organizationName = selection.isEmpty() ? null : (organization != null ? this.organizationName((EntityReference<Organization>)organization) : "");
        for (ArchivedProductIndex idx : selection) {
            OrderErasureItem item = new OrderErasureItem();
            item.setReference(idx.getSource());
            item.getCorrespondences().add(ErasureHelper.newCorrespondence("ErasureItemKey_Client", organizationName, (ErasureSearchCriterion)criterion));
            result.add((ErasureItem)item);
        }
        return result;
    }

    private List<ArchivedProductIndex> searchArchivedOrdersByClient(EntityReference<Organization> client) {
        ArrayList<ArchivedProductIndex> result = new ArrayList<ArchivedProductIndex>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ArchivedProductIndex.Property.client.name(), client));
        List selection = EntityStorage.get().search(ArchivedProductIndex.class, query).getData();
        HashSet<String> uids = new HashSet<String>(selection.size());
        for (ArchivedProductIndex idx : selection) {
            String uid = idx.getBookingContainerUid();
            if (uids.contains(uid)) continue;
            uids.add(uid);
            result.add(idx);
        }
        return result;
    }

    private void validate(EntityContainer<ErasureRequest> ctr) {
        if (ctr == null) {
            throw new WontDoJobException("erasure request is required");
        }
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"ErasureSearchingTask_Description", (Object[])new Object[]{this.requestNumber});
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeObject((Element)elm, (String)STATE, (Object)this.state);
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.state = (State)XHelper.readObject((Element)elm, (String)STATE);
    }

    private IndividualErasureParams merge(IndividualErasureParams original, IndividualErasureParams extra) {
        IndividualErasureParams result = new IndividualErasureParams();
        result.getCriteria().addAll(original.getCriteria());
        for (ErasureSearchCriterion x : extra.getCriteria()) {
            if (this.contains(result, x)) continue;
            result.getCriteria().add(x);
        }
        return result;
    }

    private boolean contains(IndividualErasureParams params, ErasureSearchCriterion criterion) {
        ErasureSearchCriterion x;
        boolean result = false;
        Iterator iterator = params.getCriteria().iterator();
        while (iterator.hasNext() && !(result = this.equals(x = (ErasureSearchCriterion)iterator.next(), criterion))) {
        }
        return result;
    }

    private boolean equals(ErasureSearchCriterion c1, ErasureSearchCriterion c2) {
        if (c1.getType() != c2.getType()) {
            return false;
        }
        boolean result = false;
        switch (c1.getType()) {
            case PERSON_NAME: {
                PersonNameCriterion name1 = (PersonNameCriterion)c1;
                PersonNameCriterion name2 = (PersonNameCriterion)c2;
                result = name1 == null ? name2 == null : name2 != null && Objects.equals(name1.getLastName(), name2.getLastName()) && Objects.equals(name1.getFirstName(), name2.getFirstName()) && Objects.equals(name1.getMiddleName(), name2.getMiddleName());
                break;
            }
            case BIRTH_DATE: {
                result = true;
                break;
            }
            case COMPANY: {
                CompanyCriterion company1 = (CompanyCriterion)c1;
                CompanyCriterion company2 = (CompanyCriterion)c2;
                result = Objects.equals(company1.getProfile(), company2.getProfile());
                break;
            }
            case PASSPORT: {
                PassportCriterion passport1 = (PassportCriterion)c1;
                PassportCriterion passport2 = (PassportCriterion)c2;
                result = passport1 == null ? passport2 == null : passport2 != null && Objects.equals(passport1.getNumber(), passport2.getNumber());
                break;
            }
            case EMAIL: {
                EmailCriterion email1 = (EmailCriterion)c1;
                EmailCriterion email2 = (EmailCriterion)c2;
                result = email1 == null ? email2 == null : email2 != null && Objects.equals(email1.getAddress(), email2.getAddress());
                break;
            }
            case PHONE: {
                PhoneCriterion phone1 = (PhoneCriterion)c1;
                PhoneCriterion phone2 = (PhoneCriterion)c2;
                result = phone1 == null ? phone2 == null : phone2 != null && Objects.equals(phone1.getNumber(), phone2.getNumber());
                break;
            }
        }
        return result;
    }

    private IndividualErasureParams extraParams(EntityContainer<Person> ctr) {
        IndividualErasureParams result = new IndividualErasureParams();
        Person person = (Person)ctr.getEntity();
        EntityReference ref = ctr.toReference();
        PersonRefCriterion criterion = new PersonRefCriterion();
        criterion.setProfile(ref);
        result.getCriteria().add(criterion);
        result.getCriteria().addAll(this.newNameCriteria(ctr));
        for (Passport passport : person.getPassports()) {
            result.getCriteria().addAll(this.newNameCriteria(passport, (EntityReference<Person>)ref));
            PassportCriterion criterion2 = this.newPassportCriterion(passport, (EntityReference<Person>)ref);
            if (criterion2 == null) continue;
            result.getCriteria().add(criterion2);
        }
        for (PersonCommunication communication : person.getCommunications()) {
            PhoneCriterion phone = this.newPhoneCriterion(communication, (EntityReference<Person>)ref);
            if (phone != null) {
                result.getCriteria().add(phone);
                continue;
            }
            EmailCriterion email = this.newEmailCriterion(communication, (EntityReference<Person>)ref);
            if (email == null) continue;
            result.getCriteria().add(email);
        }
        List employments = ProfileHelper.getOrganizationForPersonNoTimeCheck((Person)person);
        for (EntityReference employment : employments) {
            CompanyCriterion criterion3 = new CompanyCriterion();
            criterion3.setProfile(employment);
            criterion3.setSource(ref);
            result.getCriteria().add(criterion3);
        }
        return result;
    }

    private PhoneCriterion newPhoneCriterion(PersonCommunication communication, EntityReference<Person> source) {
        PhoneCriterion result = null;
        String number = ErasureHelper.getInstance().phone((Communication)communication);
        if (number != null) {
            result = new PhoneCriterion();
            result.setNumber(number);
            result.setSource(source);
        }
        return result;
    }

    private EmailCriterion newEmailCriterion(PersonCommunication communication, EntityReference<Person> source) {
        EmailCriterion result = null;
        String address = ErasureHelper.getInstance().email((Communication)communication);
        if (address != null) {
            result = new EmailCriterion();
            result.setAddress(address);
            result.setSource(source);
        }
        return result;
    }

    private PassportCriterion newPassportCriterion(Passport passport, EntityReference<Person> source) {
        PassportCriterion result = new PassportCriterion();
        result.setNumber(passport.getNumber());
        try {
            ErasureHelper.getInstance().validate(result);
        }
        catch (Exception e) {
            result = null;
        }
        result.setSource(source);
        return result;
    }

    private List<PersonNameCriterion> newNameCriteria(Passport passport, EntityReference<Person> source) {
        ArrayList<PersonNameCriterion> result = new ArrayList<PersonNameCriterion>(1);
        PersonNameCriterion name = new PersonNameCriterion();
        name.setLastName(passport.getLastName());
        name.setFirstName(passport.getFirstName());
        name.setMiddleName(passport.getMiddleName());
        try {
            ErasureHelper.getInstance().validate(name);
            result.add(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        name = new PersonNameCriterion();
        name.setLastName(passport.getLastName());
        name.setFirstName(passport.getFirstName());
        name.setMiddleName(passport.getSecondName());
        try {
            ErasureHelper.getInstance().validate(name);
            name.setSource(source);
            result.add(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private List<PersonNameCriterion> newNameCriteria(EntityContainer<Person> ctr) {
        Person person = (Person)ctr.getEntity();
        HashSet locales = new HashSet();
        locales.addAll(person.getLastName().getValues().keySet());
        locales.addAll(person.getFirstName().getValues().keySet());
        locales.addAll(person.getMiddleName().getValues().keySet());
        ArrayList<PersonNameCriterion> result = new ArrayList<PersonNameCriterion>(locales.size());
        for (Locale locale : locales) {
            PersonNameCriterion name = new PersonNameCriterion();
            name.setLastName((String)person.getLastName().getValues().get(locale));
            name.setFirstName((String)person.getFirstName().getValues().get(locale));
            name.setMiddleName((String)person.getMiddleName().getValues().get(locale));
            try {
                ErasureHelper.getInstance().validate(name);
            }
            catch (Exception e) {
                continue;
            }
            name.setSource(ctr.toReference());
            result.add(name);
        }
        return result;
    }

    private static enum Stage {
        SEARCHING_FOR_PERSONS,
        SEARCHING_FOR_ORDERS,
        DONE;

    }

    private static enum Mode {
        INDIVIDUAL,
        BATCH;

    }

    private static class State
    implements XSerializable {
        private static final String MODE = "mode";
        private static final String STAGE = "stage";
        Mode mode;
        Stage stage;

        private State() {
        }

        public void toXML(Element elm) throws Exception {
            XHelper.writeEnum((Element)elm, (String)MODE, (Enum)this.mode);
            XHelper.writeEnum((Element)elm, (String)STAGE, (Enum)this.stage);
        }

        public void fromXML(Element elm) throws Exception {
            this.mode = (Mode)XHelper.readEnum((Element)elm, (String)MODE, Mode.class);
            this.stage = (Stage)XHelper.readEnum((Element)elm, (String)STAGE, Stage.class);
        }

        public String toString() {
            return "mode: " + (Object)((Object)this.mode) + ", stage: " + (Object)((Object)this.stage);
        }
    }

    private static class IndividualPersonSearchResult {
        List<ErasureItem> items;
        IndividualErasureParams extraParams = new IndividualErasureParams();

        private IndividualPersonSearchResult() {
        }
    }
}

