/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.entity.misc.EntityStorageThreadContext;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.ExecuteGroovyScriptTaskConfiguration;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.codehaus.groovy.runtime.MethodClosure;
import org.w3c.dom.Element;

public class ExecuteGroovyScriptTask
extends BaseLongRunningTask<ExecuteGroovyScriptTaskConfiguration> {
    private ExecuteGroovyScriptTaskConfiguration config;

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public void configure(ExecuteGroovyScriptTaskConfiguration configuration) throws Exception {
        this.config = configuration;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u0435: \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u043a\u0440\u0438\u043f\u0442\u0430", (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeObject((Element)elm, (String)"config", (Object)this.config);
    }

    public void fromXML(Element elm) throws Exception {
        this.config = (ExecuteGroovyScriptTaskConfiguration)XHelper.readObject((Element)elm, (String)"config");
    }

    @Override
    protected void doJob(final LongRunningTask.EventsCallback callback) throws Exception {
        Binding binding = new Binding();
        final GroovyShell shell = new GroovyShell(binding);
        binding.setVariable("progress", (Object)new MethodClosure((Object)new ProgressClosure(callback), "doAction"));
        binding.setVariable("message", (Object)new MethodClosure((Object)new MessageClosure(callback), "doAction"));
        binding.setVariable("warning", (Object)new MethodClosure((Object)new WarningClosure(callback), "doAction"));
        binding.setVariable("error", (Object)new MethodClosure((Object)new ErrorClosure(callback), "doAction"));
        binding.setVariable("isToBeStopped", (Object)new MethodClosure((Object)new CheckClosure(this), "doAction"));
        binding.setVariable("inputFile", (Object)InputFile.newInstance(this.config));
        EntityStorageThreadContext.execute((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                EntityStorageThreadContext.setDefaultDataSource((String)"groovy-task");
                String script = TextUtil.nonBlank((String)ExecuteGroovyScriptTask.this.config.getScript()) ? ExecuteGroovyScriptTask.this.config.getScript() : new String(ExecuteGroovyScriptTask.this.config.getInputFileBody(), StandardCharsets.UTF_8);
                try {
                    shell.evaluate(script);
                }
                catch (Throwable e) {
                    ExecuteGroovyScriptTask.this.log.error("unable to execute script", e);
                    callback.updateProgress((byte)100);
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u043a\u0440\u0438\u043f\u0442", (Throwable)e, (Object[])new Object[0]));
                }
                return null;
            }
        });
        callback.taskFinished();
    }

    static class CheckClosure {
        final ExecuteGroovyScriptTask task;

        CheckClosure(ExecuteGroovyScriptTask inst) {
            this.task = inst;
        }

        public boolean doAction() {
            return this.task.isToBeStopped();
        }
    }

    static class ErrorClosure {
        final LongRunningTask.EventsCallback callback;

        ErrorClosure(LongRunningTask.EventsCallback clb) {
            this.callback = clb;
        }

        public void doAction(String msg) {
            this.callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)msg, (Object[])new Object[0]));
        }

        public void doAction(String msg, Throwable e) {
            this.callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)msg, (Throwable)e, (Object[])new Object[0]));
        }
    }

    static class WarningClosure {
        final LongRunningTask.EventsCallback callback;

        WarningClosure(LongRunningTask.EventsCallback clb) {
            this.callback = clb;
        }

        public void doAction(String msg) {
            this.callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)msg, (Object[])new Object[0]));
        }

        public void doAction(String msg, Throwable e) {
            this.callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)msg, (Throwable)e, (Object[])new Object[0]));
        }
    }

    static class MessageClosure {
        final LongRunningTask.EventsCallback callback;

        MessageClosure(LongRunningTask.EventsCallback clb) {
            this.callback = clb;
        }

        public void doAction(String msg) {
            this.callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)msg, (Object[])new Object[0]));
        }
    }

    static class ProgressClosure {
        final LongRunningTask.EventsCallback callback;

        ProgressClosure(LongRunningTask.EventsCallback clb) {
            this.callback = clb;
        }

        public void doAction(String msg, int progress) {
            this.callback.updateProgress((byte)progress);
            this.callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)msg, (Object[])new Object[0]));
        }
    }

    public static class InputFile {
        private final String name;
        private final byte[] body;

        private InputFile(String name, byte[] body) {
            this.name = name;
            this.body = body;
        }

        public static InputFile newInstance(ExecuteGroovyScriptTaskConfiguration configuration) {
            Objects.requireNonNull(configuration, "no configuration");
            if (Objects.isNull(configuration.getInputFileName()) || Objects.isNull(configuration.getInputFileBody())) {
                return null;
            }
            return new InputFile(configuration.getInputFileName(), configuration.getInputFileBody());
        }

        public String getName() {
            return this.name;
        }

        public byte[] getBody() {
            return this.body;
        }
    }
}

