/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.PersonPosition;
import com.gridnine.xtrip.common.model.dict.PersonPositionReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentCustomSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Signature;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class FinanceDocumentCustomSettingsMigrationTask
extends BaseLongRunningTask<Serializable> {
    private int count = -1;
    private final Set<String> toProceed = new LinkedHashSet<String>();

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.FinanceDocumentCustomSettingsMigrationTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        Element countElement = XmlUtil.getElement((Element)elm, (String)"count");
        if (countElement != null) {
            this.count = Integer.parseInt(countElement.getAttribute("value"));
        }
        for (Element itemElement : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(itemElement.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        Element countElement = XmlUtil.addElement((Element)elm, (String)"count");
        countElement.setAttribute("value", String.valueOf(this.count));
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("finance documents custom settings migration started");
        this.updateUids();
        if (this.count == -1) {
            this.count = this.toProceed.size();
        }
        int n = this.count - this.toProceed.size();
        this.log.debug(String.format(String.format("uids updated, processed: %s, total: %s", String.valueOf(n), String.valueOf(this.count)), new Object[0]));
        DictionaryCache dictionaryCache = DictionaryCache.get();
        PersonPosition directorPosition = (PersonPosition)dictionaryCache.findByCode(PersonPosition.class, ManagerType.DIRECTOR.name());
        PersonPosition chiefAccountantPosition = (PersonPosition)dictionaryCache.findByCode(PersonPosition.class, ManagerType.CHIEF_ACCOUNTANT.name());
        PersonPositionReference directorPositionReference = directorPosition != null ? directorPosition.toReference() : null;
        PersonPositionReference chiefAccountantPositionReference = chiefAccountantPosition != null ? chiefAccountantPosition.toReference() : null;
        Iterator<String> uidIterator = this.toProceed.iterator();
        while (uidIterator.hasNext()) {
            String uid = uidIterator.next();
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            ++n;
            String organizationTitle = uid;
            try {
                EntityContainer organizationContainer = EntityStorage.get().load(Organization.class, uid);
                if (organizationContainer == null) continue;
                Organization organization = (Organization)organizationContainer.getEntity();
                organizationTitle = organization.toString();
                byte progress = (byte)(100 * n / this.count);
                this.log.debug(String.format("processing organization %s, %s of %s (%s%%)", organizationTitle, String.valueOf(n), String.valueOf(this.count), String.valueOf(progress)));
                if (n % 10 == 0) {
                    callback.updateProgress(progress);
                }
                ArrayList<FinanceDocumentSettings> updatedSettings = new ArrayList<FinanceDocumentSettings>();
                for (FinanceDocumentType type : FinanceDocumentType.values()) {
                    FinanceDocumentSettings settings = null;
                    for (FinanceDocumentSettings sourceSettings : organization.getFinanceDocumentProperties().getFinanceDocumentsSettings()) {
                        if (sourceSettings.getType() == null || !sourceSettings.getType().equals((Object)type)) continue;
                        settings = sourceSettings;
                        break;
                    }
                    if (settings == null) {
                        settings = new FinanceDocumentSettings();
                        settings.setType(type);
                    }
                    settings.setUseDocument(organization.getFinanceDocumentProperties().getFinDocTypeSet().contains(type));
                    for (FinanceDocumentCustomSettings sourceCustomSettings : organization.getFinanceDocumentProperties().getFinDocCustomSettings()) {
                        if (sourceCustomSettings.getType() == null || !sourceCustomSettings.getType().equals((Object)type)) continue;
                        if (!sourceCustomSettings.isActive()) break;
                        settings.setUseSettings(sourceCustomSettings.isActive());
                        if (sourceCustomSettings.getTemplate() != null) {
                            settings.setTemplate(sourceCustomSettings.getTemplate());
                        }
                        settings.setIncludeVat(sourceCustomSettings.isIncludeVAT());
                        settings.setIncludeFees(sourceCustomSettings.isIncludeClientFees());
                        settings.setUseFacsimile(sourceCustomSettings.isAllowStamp());
                        if (sourceCustomSettings.getChiefSignature() != null || sourceCustomSettings.getMainBookerSignature() != null) {
                            Signature directorSignature = null;
                            Signature chiefAccountantSignature = null;
                            if (directorPositionReference != null || chiefAccountantPositionReference != null) {
                                for (Signature signature : settings.getSignatures()) {
                                    if (directorSignature == null && signature.getPosition() != null && signature.getPosition().equals((Object)directorPositionReference)) {
                                        directorSignature = signature;
                                    }
                                    if (chiefAccountantSignature == null && signature.getPosition() != null && signature.getPosition().equals((Object)chiefAccountantPositionReference)) {
                                        chiefAccountantSignature = signature;
                                    }
                                    if (directorSignature == null || chiefAccountantSignature == null) continue;
                                    break;
                                }
                            }
                            if (sourceCustomSettings.getChiefSignature() != null) {
                                if (directorSignature == null) {
                                    directorSignature = new Signature();
                                    directorSignature.setPosition((DictionaryReference)directorPositionReference);
                                    settings.getSignatures().add(directorSignature);
                                }
                                directorSignature.setSignature(sourceCustomSettings.getChiefSignature());
                            }
                            if (sourceCustomSettings.getMainBookerSignature() != null) {
                                if (chiefAccountantSignature == null) {
                                    chiefAccountantSignature = new Signature();
                                    chiefAccountantSignature.setPosition((DictionaryReference)chiefAccountantPositionReference);
                                    settings.getSignatures().add(chiefAccountantSignature);
                                }
                                chiefAccountantSignature.setSignature(sourceCustomSettings.getMainBookerSignature());
                            }
                        }
                        if (sourceCustomSettings.getStamp() == null) break;
                        settings.setStamp(sourceCustomSettings.getStamp());
                        break;
                    }
                    updatedSettings.add(settings);
                }
                organization.getFinanceDocumentProperties().getFinanceDocumentsSettings().clear();
                organization.getFinanceDocumentProperties().getFinanceDocumentsSettings().addAll(updatedSettings);
                organization.getFinanceDocumentProperties().getFinDocTypeSet().clear();
                organization.getFinanceDocumentProperties().getFinDocCustomSettings().clear();
                EntityStorage.get().save(organizationContainer, true);
            }
            catch (Throwable e) {
                this.log.error(String.format("unable to migrate finance documents custom settings of organization file %s", organizationTitle), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.FinanceDocumentCustomSettingsMigrationTask_financeDocumentCustomSettingsMigrationFailed, (Throwable)e, (Object[])new Object[]{organizationTitle}));
            }
            uidIterator.remove();
        }
        callback.taskFinished();
        this.log.debug("finance documents custom settings migration finished");
    }

    private void updateUids() throws Exception {
        if (this.count != -1 && !this.toProceed.isEmpty()) {
            return;
        }
        LogicalStorage storage = LogicalStorage.get();
        LogicalEntityStorage entityStorage = storage.getEntityStorage();
        List uids = entityStorage.getEntityUids(Organization.class, null, null, true, true, SortOrder.DESC, null);
        this.toProceed.addAll(uids);
    }
}

