/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumbers;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Element;

public class FinanceDocumentSequenceNumberDesignatorUpdateTask
extends BaseLongRunningTask<Serializable> {
    final Set<String> toProceed = new LinkedHashSet<String>();
    volatile AtomicInteger n = new AtomicInteger(0);

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.FinanceDocumentSequenceNumberDesignatorUpdateTask_updateDesignator, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        for (Element element : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(element.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("finance document sequence number designator update started");
        this.updateUids();
        int count = this.toProceed.size();
        this.log.debug(String.format("uids updated, remains " + count, new Object[0]));
        String equivalentCurrencyCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null);
        int n = 0;
        ArrayList<String> processed = new ArrayList<String>();
        for (String item : this.toProceed) {
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            ++n;
            String templateDocumentTitle = item;
            try {
                SequenceNumbers sequenceNumber;
                String documentType;
                EntityContainer templateDocumentContainer = EntityStorage.get().load(TemplateDocument.class, item);
                TemplateDocument templateDocument = (TemplateDocument)templateDocumentContainer.getEntity();
                templateDocumentTitle = templateDocument.toString();
                byte progress = (byte)(100 * n / count);
                this.log.debug(String.format("processing template document %s, %s of %s (%s%%)", templateDocumentTitle, String.valueOf(n), String.valueOf(count), String.valueOf(progress)));
                if (n % 2 == 0) {
                    callback.updateProgress(progress);
                }
                if (TextUtil.isBlank((String)(documentType = ProfileHelper.findMetadataStringByCode((List)templateDocument.getMetadata(), (String)MetadataKey.KEY_FINANCE_DOCUMENT_TYPE.name()))) || (sequenceNumber = (SequenceNumbers)AssetsStorage.get().find(SequenceNumbers.class, SequenceNumbers.Property.designator.name(), (Object)templateDocumentContainer.getUid())) == null) continue;
                if (!processed.contains(documentType)) {
                    processed.add(documentType);
                    sequenceNumber.setDesignator(documentType);
                    AssetsStorage.get().save((BaseAsset)sequenceNumber);
                    continue;
                }
                AssetsStorage.get().delete((BaseAsset)sequenceNumber);
            }
            catch (Throwable e) {
                this.log.error(String.format("unable to update sequence number designator for %s", templateDocumentTitle), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u043a\u043b\u044e\u0447\u0430 \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u0434\u043b\u044f {0}", (Throwable)e, (Object[])new Object[]{templateDocumentTitle}));
            }
        }
        callback.taskFinished();
        this.log.debug("finance document sequence number designator update finished");
    }

    private void updateUids() throws Exception {
        if (!this.toProceed.isEmpty()) {
            return;
        }
        List uids = LogicalStorage.get().getEntityStorage().getEntityUids(TemplateDocument.class, null, null, true, true, SortOrder.DESC, null);
        this.toProceed.addAll(uids);
    }
}

