/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentsCreateTaskConfiguration;
import com.gridnine.xtrip.common.model.finance.document.FinanceDocumentsCreateTaskParameters;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.finance.document.FinanceDocumentsCreateTaskHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;

public class FinanceDocumentsCreateTask
extends BaseLongRunningTask<FinanceDocumentsCreateTaskConfiguration> {
    private FinanceDocumentsCreateTaskConfiguration configuration;

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.FinanceDocumentsCreateTask_title, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        this.configuration = (FinanceDocumentsCreateTaskConfiguration)XHelper.readObject((Element)elm, (String)"configuration");
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeObject((Element)elm, (String)"configuration", (Object)this.configuration);
    }

    @Override
    public void configure(FinanceDocumentsCreateTaskConfiguration configuration) throws Exception {
        this.configuration = configuration;
    }

    @Override
    public boolean isIndefinite() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void doJob(final LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("finance documents create started");
        format = LocaleManager.get().getCurrentLocaleData().getDateTimeFormat();
        date = this.configuration.getDate();
        startDate = this.configuration.getStartDate();
        endDate = this.configuration.getEndDate();
        useDelegate = this.configuration.getUseDelegate();
        useFacsimile = this.configuration.getUseFacsimile();
        this.log.debug(String.format("date -> %s", new Object[]{date}));
        this.log.debug(String.format("startDate -> %s", new Object[]{startDate}));
        this.log.debug(String.format("endDate -> %s", new Object[]{endDate}));
        this.log.debug(String.format("useDelegate -> %s", new Object[]{useDelegate}));
        this.log.debug(String.format("useFacsimile -> %s", new Object[]{useFacsimile}));
        if (date == null) {
            this.log.error("unable to create finance documents -> date value missing");
            callback.addEvent(null, MessagesHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)Messages.FinanceDocumentsCreateTask_financeDocumentsCreateFailed, (String)L10nResourcesManager.getStr((String)Messages.FinanceDocumentsCreateTask_dateValueMissing, (Object[])new Object[0]), (Object[])new Object[0]));
            throw new Exception("date value missing");
        }
        if (startDate == null) {
            this.log.error("unable to create finance documents -> start date value missing");
            callback.addEvent(null, MessagesHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)Messages.FinanceDocumentsCreateTask_financeDocumentsCreateFailed, (String)L10nResourcesManager.getStr((String)Messages.FinanceDocumentsCreateTask_startDateValueMissing, (Object[])new Object[0]), (Object[])new Object[0]));
            throw new Exception("start date value missing");
        }
        if (endDate == null) {
            this.log.error("unable to create finance documents -> end date value missing");
            callback.addEvent(null, MessagesHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)Messages.FinanceDocumentsCreateTask_financeDocumentsCreateFailed, (String)L10nResourcesManager.getStr((String)Messages.FinanceDocumentsCreateTask_endDateValueMissing, (Object[])new Object[0]), (Object[])new Object[0]));
            throw new Exception("end date value missing");
        }
        callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.FinanceDocumentsCreateTask_date, (Object[])new Object[]{format.format(date)}));
        callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.FinanceDocumentsCreateTask_startDate, (Object[])new Object[]{format.format(startDate)}));
        callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.FinanceDocumentsCreateTask_endDate, (Object[])new Object[]{format.format(endDate)}));
        callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.FinanceDocumentsCreateTask_useDelegate, (Object[])new Object[]{useDelegate}));
        callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.FinanceDocumentsCreateTask_useFacsimile, (Object[])new Object[]{useFacsimile}));
        query = this.getSearchQuery(startDate, endDate, false);
        products = EntityStorage.get().search(CommonProductIndex.class, query).getData().stream().map((Function<CommonProductIndex, NestedEntityReference>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$doJob$0(com.gridnine.xtrip.common.model.booking.CommonProductIndex ), (Lcom/gridnine/xtrip/common/model/booking/CommonProductIndex;)Lcom/gridnine/xtrip/common/model/NestedEntityReference;)()).distinct().collect(Collectors.toList());
        products.addAll(this.getProductVoidingList(startDate, endDate));
        queryHasShipmentErrors = this.getSearchQuery(startDate, endDate, true);
        productsHasShipmentErrors = EntityStorage.get().search(CommonProductIndex.class, queryHasShipmentErrors).getData();
        clientProducts = new ArrayList<NestedEntityReference>();
        subagentProducts = new ArrayList<NestedEntityReference>();
        entityStorageContext = new EntityStorageContext();
        for (NestedEntityReference productReference : products) {
            product = (BaseProduct)Objects.requireNonNull(EntityStorageHelper.resolve((NestedEntityReference)productReference, (EntityStorageContext)entityStorageContext), (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doJob$1(com.gridnine.xtrip.common.model.NestedEntityReference ), ()Ljava/lang/String;)((NestedEntityReference)productReference));
            if (product.getShipmentsDateSubagent() != null && MiscUtil.isBetween((Date)startDate, (Date)endDate, (Date)product.getShipmentsDateSubagent()) && this.hasFopComponents(product, ContractType.SUBAGENCY)) {
                subagentProducts.add(productReference);
            }
            if (product.getShipmentsDate() == null || !MiscUtil.isBetween((Date)startDate, (Date)endDate, (Date)product.getShipmentsDate()) || !this.hasFopComponents(product, ContractType.CLIENT)) continue;
            clientProducts.add(productReference);
        }
        productsCount = Stream.of(new List[]{clientProducts, subagentProducts}).flatMap((Function<List, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/List;)Ljava/util/stream/Stream;)()).distinct().count();
        this.log.debug(String.format("products found -> %s (%s for client; %s for subagency)", new Object[]{productsCount, clientProducts.size(), subagentProducts.size()}));
        finishedWithError = false;
        if (!productsHasShipmentErrors.isEmpty()) {
            callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.FinanceDocumentsCreateTask_productsHasShipmentErrorsFound, (Object[])new Object[]{String.valueOf(productsHasShipmentErrors.size())}));
        }
        if (productsCount != 0L) {
            callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.FinanceDocumentsCreateTask_products, (Object[])new Object[]{String.valueOf(productsCount)}));
            parameters = new FinanceDocumentsCreateTaskParameters();
            parameters.setDate(date);
            parameters.setUseDelegate(useDelegate);
            parameters.setUseFacsimile(useFacsimile);
            taskMessages = new ArrayList<Message>();
            try {
                if (!clientProducts.isEmpty()) {
                    parameters.getProducts().clear();
                    parameters.getProducts().addAll(clientProducts);
                    parameters.setContractType(ContractType.CLIENT);
                    FinanceDocumentsCreateTaskHelper.create(parameters, new FinanceDocumentsCreateTaskHelper.FinanceDocumentsCreateTaskCallback(){

                        @Override
                        public void setProgress(byte progress, String message) throws Exception {
                            if (subagentProducts.isEmpty()) {
                                callback.updateProgress(progress);
                            } else {
                                callback.updateProgress((byte)(progress / 2));
                            }
                        }

                        @Override
                        public void addMessages(Collection<Message> messages) throws Exception {
                            taskMessages.addAll(messages);
                        }
                    });
                }
                if (subagentProducts.isEmpty()) ** GOTO lbl86
                parameters.getProducts().clear();
                parameters.getProducts().addAll(subagentProducts);
                parameters.setContractType(ContractType.SUBAGENCY);
                FinanceDocumentsCreateTaskHelper.create(parameters, new FinanceDocumentsCreateTaskHelper.FinanceDocumentsCreateTaskCallback(){

                    @Override
                    public void setProgress(byte progress, String message) throws Exception {
                        if (clientProducts.isEmpty()) {
                            callback.updateProgress(progress);
                        } else {
                            callback.updateProgress((byte)(50 + progress / 2));
                        }
                    }

                    @Override
                    public void addMessages(Collection<Message> messages) throws Exception {
                        taskMessages.addAll(messages);
                    }
                });
            }
            finally {
                taskMessages.sort(Comparator.comparing((Function<Message, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$doJob$2(com.gridnine.xtrip.common.model.system.Message ), (Lcom/gridnine/xtrip/common/model/system/Message;)Ljava/lang/Boolean;)()).thenComparing((Function<Message, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$doJob$3(com.gridnine.xtrip.common.model.system.Message ), (Lcom/gridnine/xtrip/common/model/system/Message;)Ljava/lang/Boolean;)()));
                for (Message message : taskMessages) {
                    callback.addEvent(null, message);
                    if (message.getType() != MessageType.ERROR) continue;
                    finishedWithError = true;
                }
            }
        } else {
            this.log.debug("unable to create finance documents -> products not found");
            callback.addEvent(null, MessagesHelper.createMessageWithDetails((MessageType)MessageType.MESSAGE, (String)Messages.FinanceDocumentsCreateTask_financeDocumentsCreateFailed, (String)L10nResourcesManager.getStr((String)Messages.FinanceDocumentsCreateTask_productsNotFound, (Object[])new Object[0]), (Object[])new Object[0]));
        }
lbl86:
        // 3 sources

        if (finishedWithError) {
            callback.taskFinishedWithError(null);
        } else {
            callback.taskFinished();
        }
        this.log.debug("finance documents create finished");
    }

    private boolean hasFopComponents(BaseProduct product, ContractType contractType) {
        return GeneralProductHelper.getFops((BaseProduct)product, (ContractType)contractType).stream().map(fop -> (FopDetalization)product.getFopDetalizations().get(fop.getUid())).filter(Objects::nonNull).flatMap(fopDetalization -> fopDetalization.getComponents().stream()).anyMatch(fopComponent -> fopComponent.getShipment() == null);
    }

    private SearchQuery getSearchQuery(Date startDate, Date endDate, boolean hasShipmentErrors) {
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(CommonProductIndex.Property.firstSystemNumber.name());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.hasShipmentErrors.name(), (Object)hasShipmentErrors));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])FinanceDocumentsHelper.allowedProductStatusesShipment.stream().map(item -> SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)item)).toArray(SearchCriterion[]::new))));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)CommonProductIndex.Property.shipmentsDate.name(), (Object)startDate), SearchCriterion.le((String)CommonProductIndex.Property.shipmentsDate.name(), (Object)endDate)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)CommonProductIndex.Property.shipmentsDateSubagent.name(), (Object)startDate), SearchCriterion.le((String)CommonProductIndex.Property.shipmentsDateSubagent.name(), (Object)endDate)})}));
        return query;
    }

    private List<NestedEntityReference<BookingFile, BaseProduct>> getProductVoidingList(Date startDate, Date endDate) {
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(CommonProductIndex.Property.productVoidingUid.name());
        query.getPreferredProperties().add(CommonProductIndex.Property.firstSystemNumber.name());
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.productVoidingUid.name(), null));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.productVoidingFopComponentsAllUsed.name(), (Object)Boolean.FALSE), SearchCriterion.eq((String)CommonProductIndex.Property.productVoidingFopComponentsAllUsed.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)CommonProductIndex.Property.productVoidingShipmentsDate.name(), (Object)startDate), SearchCriterion.le((String)CommonProductIndex.Property.productVoidingShipmentsDate.name(), (Object)endDate)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)CommonProductIndex.Property.productVoidingShipmentsDateSubagent.name(), (Object)startDate), SearchCriterion.le((String)CommonProductIndex.Property.productVoidingShipmentsDateSubagent.name(), (Object)endDate)})}));
        return EntityStorage.get().search(CommonProductIndex.class, query).getData().stream().map(item -> new NestedEntityReference(item.getSource(), item.getProductVoidingUid(), BaseProduct.class, item.getFirstSystemNumber())).distinct().collect(Collectors.toList());
    }

    private static /* synthetic */ Boolean lambda$doJob$3(Message message) {
        return message.getType() != MessageType.WARNING;
    }

    private static /* synthetic */ Boolean lambda$doJob$2(Message message) {
        return message.getType() != MessageType.ERROR;
    }

    private static /* synthetic */ String lambda$doJob$1(NestedEntityReference productReference) {
        return String.format("Product %s (uid %s, booking file uid %s) is not found in database", productReference.getCaption(), productReference.getNestedEntityUid(), productReference.getUid());
    }

    private static /* synthetic */ NestedEntityReference lambda$doJob$0(CommonProductIndex item) {
        return new NestedEntityReference(item.getSource(), item.getNavigationKey(), BaseProduct.class, item.getFirstSystemNumber());
    }
}

