/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentIndex;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class FinanceDocumentsUpdateTask
extends BaseLongRunningTask<Serializable> {
    private int count = -1;
    private final Set<String> toProceed = new LinkedHashSet<String>();

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.FinanceDocumentsUpdateTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        Element countElement = XmlUtil.getElement((Element)elm, (String)"count");
        if (countElement != null) {
            this.count = Integer.parseInt(countElement.getAttribute("value"));
        }
        for (Element itemElement : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(itemElement.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        Element countElement = XmlUtil.addElement((Element)elm, (String)"count");
        countElement.setAttribute("value", String.valueOf(this.count));
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("finance documents update started");
        this.updateUids();
        if (this.count == -1) {
            this.count = this.toProceed.size();
        }
        int n = this.count - this.toProceed.size();
        this.log.debug(String.format(String.format("uids updated, processed: %s, total: %s", String.valueOf(n), String.valueOf(this.count)), new Object[0]));
        Iterator<String> uidIterator = this.toProceed.iterator();
        while (uidIterator.hasNext()) {
            String uid = uidIterator.next();
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            ++n;
            String bookingFileTitle = uid;
            try {
                EntityContainer bookingFileContainer = EntityStorage.get().load(BookingFile.class, uid);
                if (bookingFileContainer == null) continue;
                BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
                bookingFileTitle = bookingFile.toString();
                byte progress = (byte)(100 * n / this.count);
                this.log.debug(String.format("processing booking file %s, %s of %s (%s%%)", bookingFileTitle, String.valueOf(n), String.valueOf(this.count), String.valueOf(progress)));
                if (n % 10 == 0) {
                    callback.updateProgress(progress);
                }
                boolean save = false;
                for (Payment payment : bookingFile.getPayments()) {
                    for (FinanceDocument document : payment.getFinanceDocuments()) {
                        this.log.debug(String.format("processing finance document %s", TextUtil.buildFullNumber((CompositeNumber)document)));
                        if (document.getPayment() != null) continue;
                        document.setPayment(payment);
                        save = true;
                    }
                }
                if (save) {
                    EntityStorage.get().save(bookingFileContainer, true);
                }
            }
            catch (Throwable e) {
                this.log.error(String.format("unable to update finance documents of booking file %s", bookingFileTitle), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.FinanceDocumentsUpdateTask_financeDocumentsUpdateFailed, (Throwable)e, (Object[])new Object[]{bookingFileTitle}));
            }
            uidIterator.remove();
        }
        callback.taskFinished();
        this.log.debug("finance documents update finished");
    }

    private void updateUids() throws Exception {
        if (this.count != -1 && !this.toProceed.isEmpty()) {
            return;
        }
        LogicalEntityStorage entityStorage = LogicalStorage.get().getEntityStorage();
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add("uid");
        for (FinanceDocumentIndex index : entityStorage.search(FinanceDocumentIndex.class, query).getData()) {
            String uid = index.getSource().getUid();
            if (this.toProceed.contains(uid)) continue;
            this.toProceed.add(uid);
        }
    }
}

