/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cache.asset.ModifiedObjectReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.FindDifferentsTask2Configuration;
import com.gridnine.xtrip.common.model.tasks.standard.DeletedObjectReference;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryMetadata;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionMetadataData;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;

public class FindDifferentsTask2
extends BaseLongRunningTask<FindDifferentsTask2Configuration> {
    protected FindDifferentsTask2Configuration config;
    private List<Part> partList = null;
    private int totalCount = -1;
    private int doneCount = 0;
    protected Date doneTo;
    protected volatile boolean isDBPropertiesStorageProcessed = false;
    protected volatile boolean isBulkDictionaryStorageProcessed = false;
    protected final AtomicInteger entityStorageResultCount = new AtomicInteger();
    protected final AtomicInteger indexStorageResultCount = new AtomicInteger();
    protected final AtomicInteger dictionaryStorageResultCount = new AtomicInteger();
    protected final AtomicInteger assetStorageResultCount = new AtomicInteger();
    protected final AtomicInteger bulkDictionaryStorageResultCount = new AtomicInteger();
    protected final AtomicInteger dbPropertiesStorageResultCount = new AtomicInteger();
    private final List<Result> entityStorageResult = new CopyOnWriteArrayList<Result>();
    private final List<Result> indexStorageResult = new CopyOnWriteArrayList<Result>();
    private final List<Result> dictionaryStorageResult = new CopyOnWriteArrayList<Result>();
    private final List<Result> assetStorageResult = new CopyOnWriteArrayList<Result>();
    private final List<String> bulkDictionaryStorageResult = new CopyOnWriteArrayList<String>();
    private final List<String> dbPropertiesStorageResult = new CopyOnWriteArrayList<String>();
    protected AtomicInteger errorCount = new AtomicInteger();

    @Override
    public void configure(FindDifferentsTask2Configuration configuration) throws Exception {
        this.config = configuration;
    }

    protected PhysicalStorage getPrimaryStorage() {
        LogicalStorageRegistry registry = LogicalStorageRegistry.get();
        String uid = this.config.getPrimaryStorageUid();
        if (uid == null) {
            throw new IllegalStateException("Primary storage not defined");
        }
        PhysicalStorage storage = registry.getStorage(uid);
        if (storage == null) {
            throw new IllegalStateException("Primary storage not found: " + uid);
        }
        return storage;
    }

    protected PhysicalStorage getSecondaryStorage() {
        LogicalStorageRegistry registry = LogicalStorageRegistry.get();
        String uid = this.config.getSecondaryStorageUid();
        if (uid == null) {
            throw new IllegalStateException("Secondary storage not defined");
        }
        PhysicalStorage storage = registry.getStorage(uid);
        if (storage == null) {
            throw new IllegalStateException("Secondary storage not found: " + uid);
        }
        return storage;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.FindDifferentsTask2_description, (Object[])new Object[0]);
    }

    protected List<Part> getPartList(Date date, boolean isUsedCreateDate, LongRunningTask.EventsCallback callback) throws Exception {
        ArrayList<Part> result = new ArrayList<Part>();
        Date configDate = this.config.getDate();
        if (configDate == null) {
            configDate = this.getDate(isUsedCreateDate, callback);
        }
        if (configDate == null) {
            return result;
        }
        int ch = this.config.getHours();
        int hours = ch > 0 ? ch : (ch != -1 ? 24 : Integer.MAX_VALUE);
        Calendar current = Calendar.getInstance();
        if (date != null) {
            current.setTime(date);
        }
        Calendar next = Calendar.getInstance();
        while (current.getTimeInMillis() > configDate.getTime()) {
            next.setTimeInMillis(current.getTimeInMillis());
            next.add(10, -hours);
            if (next.getTimeInMillis() < configDate.getTime()) {
                next.setTimeInMillis(configDate.getTime());
            }
            result.add(new Part(next.getTime(), current.getTime()));
            current.add(10, -hours);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getDate(final boolean isUsedCreateDate, final LongRunningTask.EventsCallback callback) throws Exception {
        Collection<Class<?>> entityTypeList = this.getEntityTypeList();
        entityTypeList.remove(PhysicalBulkDictionaryData.class);
        entityTypeList.remove(FindDifferentsTask2Configuration.DBPropertiesType.class);
        final PhysicalStorage primaryPhysicalStorage = this.getPrimaryStorage();
        final PhysicalStorage secondaryPhysicalStorage = this.getSecondaryStorage();
        Date result = null;
        final LinkedBlockingDeque dateList = new LinkedBlockingDeque();
        ExecutorServiceFacade service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool(this.getClass().getName(), this.config.getThreadCount() > 0 ? this.config.getThreadCount() : 1);
        final CountDownLatch countDown = new CountDownLatch(entityTypeList.size());
        try {
            for (final Class<?> entityType : entityTypeList) {
                service.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block16: {
                            block15: {
                                if (!FindDifferentsTask2.this.isToBeStopped()) break block15;
                                countDown.countDown();
                                return;
                            }
                            try {
                                try (PhysicalStorageSession primarySession = primaryPhysicalStorage.createSession(null);
                                     PhysicalStorageSession secondarySession = secondaryPhysicalStorage.createSession(null);){
                                    Date typeDate = FindDifferentsTask2.this.getEntityTypeDate(primaryPhysicalStorage, primarySession, secondaryPhysicalStorage, secondarySession, entityType, isUsedCreateDate);
                                    if (typeDate != null) {
                                        dateList.add(typeDate);
                                    }
                                }
                                catch (Throwable t) {
                                    FindDifferentsTask2.this.errorCount.incrementAndGet();
                                    FindDifferentsTask2.this.log.error("error in task", t);
                                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}: {1}", (Throwable)t, (Object[])new Object[]{entityType.getName(), t.toString()}));
                                    if (!FindDifferentsTask2.this.config.isStopOnError() || FindDifferentsTask2.this.isToBeStopped()) break block16;
                                    FindDifferentsTask2.this.log.debug("stop task");
                                    try {
                                        FindDifferentsTask2.this.stop();
                                    }
                                    catch (Exception e) {
                                        FindDifferentsTask2.this.log.error("unable to stop task", (Throwable)e);
                                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Throwable)e, (Object[])new Object[0]));
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                countDown.countDown();
                            }
                        }
                    }
                });
            }
            countDown.await();
        }
        finally {
            service.dispose();
        }
        for (Date typeDate : dateList) {
            if (typeDate == null || result != null && !result.after(typeDate)) continue;
            result = typeDate;
        }
        return result;
    }

    protected Date getEntityTypeDate(PhysicalStorage primaryPhysicalStorage, PhysicalStorageSession primarySession, PhysicalStorage secondaryPhysicalStorage, PhysicalStorageSession secondarySession, Class<?> clazz, boolean isUsedCreateDate) throws Exception {
        if (BaseDictionary.class.isAssignableFrom(clazz)) {
            return this.getDictionaryStorageDate(primaryPhysicalStorage, primarySession, secondaryPhysicalStorage, secondarySession, clazz, isUsedCreateDate);
        }
        if (BaseEntity.class.isAssignableFrom(clazz)) {
            return this.getEntityStorageDate(primaryPhysicalStorage, primarySession, secondaryPhysicalStorage, secondarySession, clazz, isUsedCreateDate);
        }
        if (BaseAsset.class.isAssignableFrom(clazz)) {
            return this.getAssetStorageDate(primaryPhysicalStorage, primarySession, secondaryPhysicalStorage, secondarySession, clazz);
        }
        throw new IllegalArgumentException("Wrong class: " + String.valueOf(clazz));
    }

    protected <T extends BaseEntity> Date getEntityStorageDate(PhysicalStorage primaryPhysicalStorage, PhysicalStorageSession primarySession, PhysicalStorage secondaryPhysicalStorage, PhysicalStorageSession secondarySession, Class<T> clazz, boolean isUsedCreateDate) throws Exception {
        EntityPhysicalStorage primaryEntityPhysicalStorage = primaryPhysicalStorage.getEntityStorage();
        List uidList1 = primaryEntityPhysicalStorage.getEntityUids(clazz, null, null, this.config.isUsedCreateDate(), false, SortOrder.DESC, Integer.valueOf(1), primarySession);
        Date date1 = null;
        if (uidList1.size() >= 1) {
            PhysicalEntityData entity1 = primaryEntityPhysicalStorage.loadEntity(clazz, (String)uidList1.get(0), null, primarySession);
            date1 = entity1 != null ? (isUsedCreateDate ? entity1.getCreated() : entity1.getModified()) : null;
        }
        EntityPhysicalStorage secondaryEntityPhysicalStorage = secondaryPhysicalStorage.getEntityStorage();
        List uidList2 = secondaryEntityPhysicalStorage.getEntityUids(clazz, null, null, this.config.isUsedCreateDate(), false, SortOrder.DESC, Integer.valueOf(1), secondarySession);
        Date date2 = null;
        if (uidList2.size() >= 1) {
            PhysicalEntityData entity2 = secondaryEntityPhysicalStorage.loadEntity(clazz, (String)uidList2.get(0), null, secondarySession);
            Date date = entity2 != null ? (isUsedCreateDate ? entity2.getCreated() : entity2.getModified()) : (date2 = null);
        }
        return date1 == null ? date2 : (date2 == null ? date1 : (date1.before(date2) ? date1 : date2));
    }

    protected <D extends BaseDictionary> Date getDictionaryStorageDate(PhysicalStorage primaryPhysicalStorage, PhysicalStorageSession primarySession, PhysicalStorage secondaryPhysicalStorage, PhysicalStorageSession secondarySession, Class<D> clazz, boolean isUsedCreateDate) throws Exception {
        DictionaryPhysicalStorage primaryDictionaryPhysicalStorage = primaryPhysicalStorage.getDictionaryStorage();
        List uidList1 = primaryDictionaryPhysicalStorage.getDictionaryUids(clazz, null, null, this.config.isUsedCreateDate(), false, SortOrder.DESC, Integer.valueOf(1), primarySession);
        Date date1 = null;
        if (uidList1.size() >= 1) {
            PhysicalDictionaryData dictionary1 = primaryDictionaryPhysicalStorage.findDictionaryByUid(clazz, (String)uidList1.get(0), false, primarySession);
            date1 = dictionary1 != null ? (isUsedCreateDate ? dictionary1.getCreated() : dictionary1.getModified()) : null;
        }
        DictionaryPhysicalStorage secondaryDictionaryPhysicalStorage = secondaryPhysicalStorage.getDictionaryStorage();
        List uidList2 = secondaryDictionaryPhysicalStorage.getDictionaryUids(clazz, null, null, this.config.isUsedCreateDate(), false, SortOrder.DESC, Integer.valueOf(1), secondarySession);
        Date date2 = null;
        if (uidList2.size() >= 1) {
            PhysicalDictionaryData dictionary2 = secondaryDictionaryPhysicalStorage.findDictionaryByUid(clazz, (String)uidList2.get(0), false, secondarySession);
            Date date = dictionary2 != null ? (isUsedCreateDate ? dictionary2.getCreated() : dictionary2.getModified()) : (date2 = null);
        }
        return date1 == null ? date2 : (date2 == null ? date1 : (date1.before(date2) ? date1 : date2));
    }

    protected <A extends BaseAsset> Date getAssetStorageDate(PhysicalStorage primaryPhysicalStorage, PhysicalStorageSession primarySession, PhysicalStorage secondaryPhysicalStorage, PhysicalStorageSession secondarySession, Class<A> clazz) throws Exception {
        AssetPhysicalStorage primaryAssetPhysicalStorage = primaryPhysicalStorage.getAssetStorage();
        List uidList1 = primaryAssetPhysicalStorage.getAssetUids(clazz, null, null, SortOrder.DESC, Integer.valueOf(1), primarySession);
        Date date1 = null;
        if (uidList1.size() >= 1) {
            PhysicalAssetData asset1 = primaryAssetPhysicalStorage.loadAsset(clazz, (String)uidList1.get(0), primarySession);
            date1 = asset1.getAsset().getModified();
        }
        AssetPhysicalStorage secondaryAssetPhysicalStorage = secondaryPhysicalStorage.getAssetStorage();
        List uidList2 = secondaryAssetPhysicalStorage.getAssetUids(clazz, null, null, SortOrder.DESC, Integer.valueOf(1), secondarySession);
        Date date2 = null;
        if (uidList2.size() >= 1) {
            PhysicalAssetData asset2 = secondaryAssetPhysicalStorage.loadAsset(clazz, (String)uidList2.get(0), secondarySession);
            date2 = asset2.getAsset().getModified();
        }
        return date1 == null ? date2 : (date2 == null ? date1 : (date1.before(date2) ? date1 : date2));
    }

    protected Collection<Class<?>> getEntityTypeList() throws Exception {
        Set typeList;
        HashSet result = new HashSet();
        result.add(PhysicalBulkDictionaryData.class);
        result.add(FindDifferentsTask2Configuration.DBPropertiesType.class);
        MetaRegistry metaRegistry = MetaRegistry.get();
        for (Object value : metaRegistry.getEntities().values()) {
            if (!MetaRegistryHelper.isRoot((EntityType)value) || value.isAbstract()) continue;
            result.add(Class.forName(value.getId()));
        }
        for (Object value : metaRegistry.getDictionaries().values()) {
            if (value.isAbstract()) continue;
            result.add(Class.forName(value.getId()));
        }
        HibernatePhysicalStorageRegistry hpsr = null;
        try {
            hpsr = (HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class);
        }
        catch (IllegalArgumentException value) {
            // empty catch block
        }
        if (hpsr != null) {
            for (Class assetClass : hpsr.getAssetDataClasses().keySet()) {
                result.add(assetClass);
            }
        }
        if ((typeList = this.config.getTypeList()) != null && typeList.size() > 0) {
            for (Class type : new ArrayList(result)) {
                if (typeList.contains(type.getName())) continue;
                result.remove(type);
            }
        }
        result.remove(ModifiedObjectReference.class);
        result.remove(DeletedObjectReference.class);
        return result;
    }

    protected int getMaxResultCount() {
        return this.config.getMaxResultCount() > 0 ? this.config.getMaxResultCount() : 10;
    }

    protected DateFormat createDateFormat() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:sss.SSS");
    }

    protected String formatDate(Date date) {
        return date != null ? this.createDateFormat().format(date) : "(empty)";
    }

    protected <T extends BaseEntity> void addEntity(Part part, PhysicalEntityData<T> entity1, PhysicalEntityData<T> entity2) {
        if (this.entityStorageResult.size() <= this.getMaxResultCount()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = entity1 != null ? entity1.getUid() : entity2.getUid();
            Object object = objectArray[1] = entity1 != null ? MiscUtil.getSimpleClassName((Class)entity1.getEntityType()) : MiscUtil.getSimpleClassName((Class)entity2.getEntityType());
            Object object2 = entity1 != null ? (entity2 != null ? "in primary: " + this.formatDate(entity1.getModified()) + ", in secondary: " + this.formatDate(entity2.getModified()) : this.formatDate(entity1.getModified())) : (objectArray[2] = this.formatDate(entity2.getModified()));
            objectArray[3] = entity1 != null ? (entity2 != null ? "differents" : "new") : "unnecessary";
            this.entityStorageResult.add(new Result(String.format("UID: %s (type: %s, modified: %s), %s", objectArray), part));
        }
        this.entityStorageResultCount.incrementAndGet();
        part.getEntityStorageResultCount().incrementAndGet();
    }

    protected <T extends BaseEntity> void addEntity2(Part part, String uid, Class clazz) {
        if (this.entityStorageResult.size() <= this.getMaxResultCount()) {
            this.entityStorageResult.add(new Result(String.format("UID: %s, type: %s, unnecessary", uid, MiscUtil.getSimpleClassName((Class)clazz)), part));
        }
        this.entityStorageResultCount.incrementAndGet();
        part.getEntityStorageResultCount().incrementAndGet();
    }

    protected <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void addIndex(Part part, D index1, D index2) {
        if (this.indexStorageResult.size() <= this.getMaxResultCount()) {
            Object[] objectArray = new Object[2];
            Object object = objectArray[0] = index1 != null ? index1.getUid() : index2.getUid();
            objectArray[1] = index1 != null ? (index2 != null ? "differents" : "new") : "unnecessary";
            this.indexStorageResult.add(new Result(String.format("UID: %s, %s", objectArray), part));
        }
        this.indexStorageResultCount.incrementAndGet();
        part.getIndexStorageResultCount().incrementAndGet();
    }

    protected <D extends BaseDictionary> void addDictionary(Part part, PhysicalDictionaryData<D> dictionary1, PhysicalDictionaryData<D> dictionary2, Class<?> dictionaryClass) {
        if (this.dictionaryStorageResult.size() <= this.getMaxResultCount()) {
            Object[] objectArray = new Object[3];
            Object object = objectArray[0] = dictionary1 != null ? dictionary1.getUid() : dictionary2.getUid();
            objectArray[1] = dictionary1 != null ? (dictionary2 != null ? "differents" : "new") : "unnecessary";
            objectArray[2] = dictionaryClass.getName();
            this.dictionaryStorageResult.add(new Result(String.format("UID: %s, %s, CLASS: %s", objectArray), part));
        }
        this.dictionaryStorageResultCount.incrementAndGet();
        part.getDictionaryStorageResultCount().incrementAndGet();
    }

    protected <D extends BaseDictionary> void addDictionary2(Part part, String uid) {
        if (this.dictionaryStorageResult.size() <= this.getMaxResultCount()) {
            this.dictionaryStorageResult.add(new Result(String.format("UID: %s, unnecessary", uid), part));
        }
        this.dictionaryStorageResultCount.incrementAndGet();
        part.getDictionaryStorageResultCount().incrementAndGet();
    }

    protected <A extends BaseAsset> void addAsset(Part part, PhysicalAssetData<A> asset1, PhysicalAssetData<A> asset2) {
        if (this.assetStorageResult.size() <= this.getMaxResultCount()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = asset1 != null ? asset1.getAsset().getUid() : asset2.getAsset().getUid();
            Object object = objectArray[1] = asset1 != null ? MiscUtil.getSimpleClassName(asset1.getAsset().getClass()) : MiscUtil.getSimpleClassName(asset2.getAsset().getClass());
            Object object2 = asset1 != null ? (asset2 != null ? "in primary: " + this.formatDate(asset1.getAsset().getModified()) + ", in secondary: " + this.formatDate(asset2.getAsset().getModified()) : this.formatDate(asset1.getAsset().getModified())) : (objectArray[2] = this.formatDate(asset2.getAsset().getModified()));
            objectArray[3] = asset1 != null ? (asset2 != null ? "differents" : "new") : "unnecessary";
            this.assetStorageResult.add(new Result(String.format("UID: %s (type: %s, modified: %s), %s", objectArray), part));
        }
        this.assetStorageResultCount.incrementAndGet();
        part.getAssetStorageResultCount().incrementAndGet();
    }

    protected <A extends BaseAsset> void addAsset2(Part part, String uid) {
        if (this.assetStorageResult.size() <= this.getMaxResultCount()) {
            this.assetStorageResult.add(new Result(String.format("UID: %s, unnecessary", uid), part));
        }
        this.assetStorageResultCount.incrementAndGet();
        part.getAssetStorageResultCount().incrementAndGet();
    }

    protected <D extends BaseDictionary> void addBulkDictionary(PhysicalBulkDictionaryData<D> bulkDictionary1, PhysicalBulkDictionaryData<D> bulkDictionary2) {
        if (this.bulkDictionaryStorageResult.size() <= this.getMaxResultCount()) {
            Object[] objectArray = new Object[2];
            Object object = objectArray[0] = bulkDictionary1 != null ? bulkDictionary1.getDictionaryType().getName() : bulkDictionary2.getDictionaryType().getName();
            objectArray[1] = bulkDictionary1 != null ? (bulkDictionary2 != null ? "differents" : "new") : "unnecessary";
            this.bulkDictionaryStorageResult.add(String.format("UID: %s, %s", objectArray));
        }
        this.bulkDictionaryStorageResultCount.incrementAndGet();
    }

    protected <D extends BaseDictionary> void addBulkDictionary2(Class<?> dictType) {
        if (this.bulkDictionaryStorageResult.size() <= this.getMaxResultCount()) {
            this.bulkDictionaryStorageResult.add(String.format("Dictionary type: %s, unnecessary", dictType.getName()));
        }
        this.bulkDictionaryStorageResultCount.incrementAndGet();
    }

    protected void addDBProperty(String key, String value1, String value2) {
        if (this.dbPropertiesStorageResult.size() <= this.getMaxResultCount()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = String.valueOf(key);
            objectArray[1] = value1 != null ? (value2 != null ? String.format("differents \"%s\" != \"%s\"", String.valueOf(value1), String.valueOf(value2)) : "new \"" + String.valueOf(value1) + "\"") : "unnecessary \"" + String.valueOf(value2) + "\"";
            this.dbPropertiesStorageResult.add(String.format("key: %s, %s", objectArray));
        }
        this.dbPropertiesStorageResultCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends BaseEntity> void processEntityStorage(PhysicalStorage primaryPhysicalStorage, PhysicalStorage secondaryPhysicalStorage, Part part, Class<T> entityClass, LongRunningTask.EventsCallback callback) throws Throwable {
        List uidList2;
        List uidList;
        EntityPhysicalStorage primaryEntityPhysicalStorage = primaryPhysicalStorage.getEntityStorage();
        EntityPhysicalStorage secondaryEntityPhysicalStorage = secondaryPhysicalStorage.getEntityStorage();
        LogicalStorageRegistry storageRegistry = LogicalStorageRegistry.get();
        try (PhysicalStorageSession primaryUidsSession = primaryPhysicalStorage.createSession(null);){
            uidList = primaryEntityPhysicalStorage.getEntityUids(entityClass, part.getFrom(), part.getTo(), this.config.isUsedCreateDate(), false, SortOrder.DESC, null, primaryUidsSession);
        }
        for (String uid : uidList) {
            try {
                if (this.isToBeStopped()) {
                    return;
                }
                try (PhysicalStorageSession primarySession = primaryPhysicalStorage.createSession(null);){
                    EntityReference entityRef = new EntityReference(uid, entityClass, null);
                    PhysicalEntityData entity1 = primaryEntityPhysicalStorage.loadEntity(entityClass, uid, null, primarySession);
                    if (entity1 == null) {
                        this.log.warn(String.format("entity not found: class %s, uid %s", entityClass.getName(), uid));
                        continue;
                    }
                    List versionsMetadata1 = primaryEntityPhysicalStorage.getVersionsMetadata(entityRef, primarySession);
                    if (versionsMetadata1 == null || versionsMetadata1.size() == 0) {
                        this.log.warn(String.format("entity versions meta data not found: class %s, uid %s", entityClass.getName(), uid));
                        continue;
                    }
                    try (PhysicalStorageSession secondarySession = secondaryPhysicalStorage.createSession(null);){
                        boolean isVersionsDifferent;
                        PhysicalEntityData entity2 = secondaryEntityPhysicalStorage.loadEntity(entityClass, uid, null, secondarySession);
                        List versionsMetadata2 = secondaryEntityPhysicalStorage.getVersionsMetadata(entityRef, secondarySession);
                        boolean bl = isVersionsDifferent = versionsMetadata2 == null || entity2 == null || !this.isObjectsEquals(entity1.getModified(), entity2.getModified()) || versionsMetadata2.size() != versionsMetadata1.size();
                        if (!isVersionsDifferent && versionsMetadata2 != null) {
                            for (PhysicalVersionMetadataData version1 : versionsMetadata1) {
                                PhysicalVersionMetadataData version2 = null;
                                for (PhysicalVersionMetadataData version : versionsMetadata2) {
                                    if (version.getVersionNumber() != version1.getVersionNumber()) continue;
                                    version2 = version;
                                    break;
                                }
                                if (version2 != null && this.isVersionsEquals(version1, version2)) continue;
                                isVersionsDifferent = true;
                                break;
                            }
                        }
                        if (isVersionsDifferent) {
                            this.addEntity(part, entity1, entity2);
                            if (!this.config.isSearchOverMax() && this.entityStorageResult.size() >= this.getMaxResultCount()) {
                                return;
                            }
                        }
                        Collection handlers = storageRegistry.getIndexHandlers(entityClass);
                        for (IndexHandler handler : handlers) {
                            Class indexClass = handler.getIndexClass();
                            if (indexClass == null) {
                                throw new Exception(String.format("Internal error: No index class defined in handler %s for entity %s", handler.getClass().getName(), entityClass.getName()));
                            }
                            try {
                                this.processEntityIndexStorage(primaryEntityPhysicalStorage, primarySession, secondaryEntityPhysicalStorage, secondarySession, part, indexClass, uid);
                            }
                            catch (Throwable t) {
                                if (this.config.isStopOnError()) {
                                    throw t;
                                }
                                this.log.error(String.format("error in task (class %s, index %s, uid %s): %s", entityClass.getName(), indexClass.getName(), uid, t.toString()), t);
                                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, index {1}, uid {2}: {3}", (Throwable)t, (Object[])new Object[]{entityClass.getName(), indexClass.getName(), uid, t.toString()}));
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (this.config.isStopOnError()) {
                    throw t;
                }
                this.errorCount.incrementAndGet();
                this.log.error(String.format("error in task (class %s, uid %s): %s", entityClass.getName(), uid, t.toString()), t);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, uid {1}: {2}", (Throwable)t, (Object[])new Object[]{entityClass.getName(), uid, t.toString()}));
            }
        }
        uidList.clear();
        try (PhysicalStorageSession secondaryUidsSession = secondaryPhysicalStorage.createSession(null);){
            if (this.log.isDebugEnabled()) {
                this.log.debug("Entity pass two getEntityUids params: entityClass=" + MiscUtil.getSimpleClassName(entityClass) + ", part.from=" + (part.getFrom() != null ? part.getFrom().toString() + " (" + Long.toString(part.getFrom().getTime()) + ")" : "null") + ", part.to=" + (part.getTo() != null ? part.getTo().toString() + " (" + Long.toString(part.getTo().getTime()) + ")" : "null") + ", useCreateDate=" + Boolean.toString(this.config.isUsedCreateDate()) + ", SortOrder.DESC, null");
            }
            uidList2 = secondaryEntityPhysicalStorage.getEntityUids(entityClass, part.getFrom(), part.getTo(), this.config.isUsedCreateDate(), false, SortOrder.DESC, null, secondaryUidsSession);
        }
        for (String uid : uidList2) {
            try {
                if (this.isToBeStopped()) {
                    return;
                }
                this.log.debug("Entity pass two uid details: entityClass=" + MiscUtil.getSimpleClassName(entityClass) + ", uid=" + String.valueOf(uid));
                try (PhysicalStorageSession primarySession = primaryPhysicalStorage.createSession(null);){
                    PhysicalEntityData entity1 = primaryEntityPhysicalStorage.loadEntity(entityClass, uid, null, primarySession);
                    if (entity1 != null) continue;
                    this.addEntity2(part, uid, entityClass);
                    if (this.config.isSearchOverMax() || this.entityStorageResult.size() < this.getMaxResultCount()) continue;
                    return;
                }
            }
            catch (Throwable t) {
                if (this.config.isStopOnError()) {
                    throw t;
                }
                this.errorCount.incrementAndGet();
                this.log.error(String.format("error in task (class %s, uid %s): %s", entityClass.getName(), uid, t.toString()), t);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, uid {1}: {2}", (Throwable)t, (Object[])new Object[]{entityClass.getName(), uid, t.toString()}));
            }
        }
    }

    protected <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void processEntityIndexStorage(EntityPhysicalStorage primaryEntityPhysicalStorage, PhysicalStorageSession primarySession, EntityPhysicalStorage secondaryEntityPhysicalStorage, PhysicalStorageSession secondarySession, Part part, Class<I> indexClass, String uid) throws Exception {
        if (!this.config.isSearchOverMax() && this.indexStorageResult.size() >= this.getMaxResultCount()) {
            return;
        }
        Map data1 = primaryEntityPhysicalStorage.getIndexes(indexClass, uid, primarySession);
        Map data2 = secondaryEntityPhysicalStorage.getIndexes(indexClass, uid, secondarySession);
        List indexes1 = data1.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List indexes2 = data2.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        HashMap<String, BaseIndexData> map1 = new HashMap<String, BaseIndexData>();
        HashMap<String, BaseIndexData> map2 = new HashMap<String, BaseIndexData>();
        Collection<String> indexProperties = this.getIndexProperties(indexClass);
        for (BaseIndexData index2 : indexes2) {
            map2.put(index2.getUid(), index2);
        }
        for (BaseIndexData index1 : indexes1) {
            map1.put(index1.getUid(), index1);
            BaseIndexData index2 = (BaseIndexData)map2.get(index1.getUid());
            if (index2 != null && this.isEqualIndexDatas(index1, index2, indexProperties)) continue;
            this.addIndex(part, index1, index2);
            if (this.config.isSearchOverMax() || this.indexStorageResult.size() < this.getMaxResultCount()) continue;
            return;
        }
        map2.clear();
        for (BaseIndexData index2 : indexes2) {
            if (map1.get(index2.getUid()) != null) continue;
            this.addIndex(part, null, index2);
            if (this.config.isSearchOverMax() || this.indexStorageResult.size() < this.getMaxResultCount()) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <D extends BaseDictionary> void processDictionaryStorage(PhysicalStorage primaryPhysicalStorage, PhysicalStorage secondaryPhysicalStorage, Part part, Class<D> dictionaryClass, LongRunningTask.EventsCallback callback) throws Throwable {
        primarySession = primaryPhysicalStorage.createSession(null);
        try {
            block24: {
                block23: {
                    primaryDictionaryPhysicalStorage = primaryPhysicalStorage.getDictionaryStorage();
                    secondarySession = secondaryPhysicalStorage.createSession(null);
                    try {
                        secondaryEntityPhysicalStorage = secondaryPhysicalStorage.getDictionaryStorage();
                        uidList = primaryDictionaryPhysicalStorage.getDictionaryUids(dictionaryClass, part.getFrom(), part.getTo(), this.config.isUsedCreateDate(), false, SortOrder.DESC, null, primarySession);
lbl8:
                        // 4 sources

                        for (String uid : uidList) {
                            try {
                                if (this.isToBeStopped()) {
                                    break block23;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable t) {
                                if (this.config.isStopOnError()) {
                                    throw t;
                                }
                                this.errorCount.incrementAndGet();
                                this.log.error(String.format("error in task (class %s, uid %s): %s", new Object[]{dictionaryClass.getName(), uid, t.toString()}), t);
                                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, uid {1}: {2}", (Throwable)t, (Object[])new Object[]{dictionaryClass.getName(), uid, t.toString()}));
                            }
                        }
                        break block24;
                    }
                    catch (Throwable var15_17) {
                        secondarySession.close();
                        throw var15_17;
                    }
                }
                secondarySession.close();
                return;
lbl-1000:
                // 1 sources

                {
                    dictionary1 = primaryDictionaryPhysicalStorage.findDictionaryByUid(dictionaryClass, uid, false, primarySession);
                    if (this.isDictionariesEqual(dictionary1, dictionary2 = secondaryEntityPhysicalStorage.findDictionaryByUid(dictionaryClass, uid, false, secondarySession))) ** GOTO lbl8
                    this.addDictionary(part, dictionary1, dictionary2, dictionaryClass);
                    if (this.config.isSearchOverMax() || this.dictionaryStorageResult.size() < this.getMaxResultCount()) ** GOTO lbl8
                }
                secondarySession.close();
                return;
            }
            uidList.clear();
            uidList2 = secondaryEntityPhysicalStorage.getDictionaryUids(dictionaryClass, part.getFrom(), part.getTo(), this.config.isUsedCreateDate(), false, SortOrder.DESC, null, secondarySession);
            for (String uid : uidList2) {
                if (this.isToBeStopped()) {
                }
                ** GOTO lbl-1000
                {
                    catch (Throwable t) {
                        if (this.config.isStopOnError()) {
                            throw t;
                        }
                        this.errorCount.incrementAndGet();
                        this.log.error(String.format("error in task (class %s, uid %s): %s", new Object[]{dictionaryClass.getName(), uid, t.toString()}), t);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, uid {1}: {2}", (Throwable)t, (Object[])new Object[]{dictionaryClass.getName(), uid, t.toString()}));
                        continue;
                    }
                    secondarySession.close();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        dictionary1 = primaryDictionaryPhysicalStorage.findDictionaryByUid(dictionaryClass, uid, false, primarySession);
                        if (dictionary1 != null) continue;
                        this.addDictionary2(part, uid);
                        if (this.config.isSearchOverMax() || this.dictionaryStorageResult.size() < this.getMaxResultCount()) continue;
                    }
                    secondarySession.close();
                    return;
                }
            }
            secondarySession.close();
            return;
        }
        finally {
            primarySession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <A extends BaseAsset> void processAssetStorage(PhysicalStorage primaryPhysicalStorage, PhysicalStorage secondaryPhysicalStorage, Part part, Class<A> assetClass, LongRunningTask.EventsCallback callback) throws Throwable {
        primarySession = primaryPhysicalStorage.createSession(null);
        try {
            block27: {
                block26: {
                    primaryAssetPhysicalStorage = primaryPhysicalStorage.getAssetStorage();
                    secondarySession = secondaryPhysicalStorage.createSession(null);
                    try {
                        secondaryAssetPhysicalStorage = secondaryPhysicalStorage.getAssetStorage();
                        uidList = primaryAssetPhysicalStorage.getAssetUids(assetClass, part.getFrom(), part.getTo(), SortOrder.DESC, null, primarySession);
lbl8:
                        // 5 sources

                        for (String uid : uidList) {
                            try {
                                if (this.isToBeStopped()) {
                                    break block26;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable t) {
                                if (this.config.isStopOnError()) {
                                    throw t;
                                }
                                this.errorCount.incrementAndGet();
                                this.log.error(String.format("error in task (class %s, uid %s): %s", new Object[]{assetClass.getName(), uid, t.toString()}), t);
                                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, uid {1}: {2}", (Throwable)t, (Object[])new Object[]{assetClass.getName(), uid, t.toString()}));
                            }
                        }
                        break block27;
                    }
                    catch (Throwable var15_17) {
                        secondarySession.close();
                        throw var15_17;
                    }
                }
                secondarySession.close();
                return;
lbl-1000:
                // 1 sources

                {
                    block28: {
                        asset1 = primaryAssetPhysicalStorage.loadAsset(assetClass, uid, primarySession);
                        if (asset1 != null && asset1.getAsset() == null) {
                            throw new Exception(String.format("Internal error: PhysicalAssetData<%s>.getAsset() == null, uid = %s", new Object[]{assetClass.getName(), uid}));
                        }
                        if (asset1 != null) break block28;
                        this.log.warn(String.format("asset not found: class %s, uid %s", new Object[]{assetClass.getName(), uid}));
                        ** GOTO lbl8
                    }
                    asset2 = secondaryAssetPhysicalStorage.loadAsset(assetClass, uid, secondarySession);
                    if (asset2 != null && asset2.getAsset() == null) {
                        throw new Exception(String.format("Internal error: PhysicalAssetData<%s>.getAsset() == null, uid = %s", new Object[]{assetClass.getName(), uid}));
                    }
                    if (this.isAssetsEquals(asset1, asset2)) ** GOTO lbl8
                    this.log.warn(String.format("asset modified date is null: class %s, uid %s", new Object[]{assetClass.getName(), uid}));
                    this.addAsset(part, asset1, asset2);
                    if (this.config.isSearchOverMax() || this.assetStorageResult.size() < this.getMaxResultCount()) ** GOTO lbl8
                }
                secondarySession.close();
                return;
            }
            uidList.clear();
            uidList2 = secondaryAssetPhysicalStorage.getAssetUids(assetClass, part.getFrom(), part.getTo(), SortOrder.DESC, null, secondarySession);
            for (String uid : uidList2) {
                if (this.isToBeStopped()) {
                }
                ** GOTO lbl-1000
                {
                    catch (Throwable t) {
                        if (this.config.isStopOnError()) {
                            throw t;
                        }
                        this.errorCount.incrementAndGet();
                        this.log.error(String.format("error in task (class %s, uid %s): %s", new Object[]{assetClass.getName(), uid, t.toString()}), t);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, uid {1}: {2}", (Throwable)t, (Object[])new Object[]{assetClass.getName(), uid, t.toString()}));
                        continue;
                    }
                    secondarySession.close();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        asset1 = primaryAssetPhysicalStorage.loadAsset(assetClass, uid, primarySession);
                        if (asset1 != null && asset1.getAsset() == null) {
                            throw new Exception(String.format("Internal error: PhysicalAssetData<%s>.getAsset() == null, uid = %s", new Object[]{assetClass.getName(), uid}));
                        }
                        if (asset1 != null) continue;
                        this.addAsset2(part, uid);
                        if (this.config.isSearchOverMax() || this.assetStorageResult.size() < this.getMaxResultCount()) continue;
                    }
                    secondarySession.close();
                    return;
                }
            }
            secondarySession.close();
            return;
        }
        finally {
            primarySession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processBulkDictionaryStorage(PhysicalStorage primaryPhysicalStorage, PhysicalStorage secondaryPhysicalStorage, LongRunningTask.EventsCallback callback) throws Throwable {
        primarySession = primaryPhysicalStorage.createSession(null);
        try {
            block24: {
                block23: {
                    primaryBulkDictionaryPhysicalStorage = primaryPhysicalStorage.getBulkDictionaryStorage();
                    secondarySession = secondaryPhysicalStorage.createSession(null);
                    try {
                        secondaryBulkDictionaryPhysicalStorage = secondaryPhysicalStorage.getBulkDictionaryStorage();
                        metadataList1 = primaryBulkDictionaryPhysicalStorage.loadMetadata(primarySession);
lbl8:
                        // 4 sources

                        for (PhysicalBulkDictionaryMetadata metadata1 : metadataList1) {
                            try {
                                if (this.isToBeStopped()) {
                                    break block23;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable t) {
                                if (this.config.isStopOnError()) {
                                    throw t;
                                }
                                this.errorCount.incrementAndGet();
                                this.log.error(String.format("error in task (class %s, dictType %s): %s", new Object[]{"PhysicalBulkDictionaryMetadata", metadata1.getDictionaryType() != null ? metadata1.getDictionaryType().getName() : "null", t.toString()}), t);
                                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, dictType {1}: {2}", (Throwable)t, (Object[])new Object[]{"PhysicalBulkDictionaryMetadata", metadata1.getDictionaryType() != null ? metadata1.getDictionaryType().getName() : "null", t.toString()}));
                            }
                        }
                        break block24;
                    }
                    catch (Throwable var13_15) {
                        secondarySession.close();
                        throw var13_15;
                    }
                }
                secondarySession.close();
                return;
lbl-1000:
                // 1 sources

                {
                    data1 = primaryBulkDictionaryPhysicalStorage.loadData(metadata1.getDictionaryType(), primarySession);
                    if (this.isBulkDictionariesEquals(data1, data2 = secondaryBulkDictionaryPhysicalStorage.loadData(metadata1.getDictionaryType(), secondarySession))) ** GOTO lbl8
                    this.addBulkDictionary(data1, data2);
                    if (this.config.isSearchOverMax() || this.bulkDictionaryStorageResult.size() < this.getMaxResultCount()) ** GOTO lbl8
                }
                secondarySession.close();
                return;
            }
            metadataList2 = secondaryBulkDictionaryPhysicalStorage.loadMetadata(secondarySession);
            for (PhysicalBulkDictionaryMetadata metadata2 : metadataList2) {
                if (this.isToBeStopped()) {
                }
                ** GOTO lbl-1000
                {
                    catch (Throwable t) {
                        if (this.config.isStopOnError()) {
                            throw t;
                        }
                        this.errorCount.incrementAndGet();
                        this.log.error(String.format("error in task (class %s, dictType %s): %s", new Object[]{"PhysicalBulkDictionaryMetadata", metadata2.getDictionaryType() != null ? metadata2.getDictionaryType().getName() : "null", t.toString()}), t);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, dictType {1}: {2}", (Throwable)t, (Object[])new Object[]{"PhysicalBulkDictionaryMetadata", metadata2.getDictionaryType() != null ? metadata2.getDictionaryType().getName() : "null", t.toString()}));
                        continue;
                    }
                    secondarySession.close();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        data1 = primaryBulkDictionaryPhysicalStorage.loadData(metadata2.getDictionaryType(), primarySession);
                        if (data1 != null) continue;
                        this.addBulkDictionary2(metadata2.getDictionaryType());
                        if (this.config.isSearchOverMax() || this.bulkDictionaryStorageResult.size() < this.getMaxResultCount()) continue;
                    }
                    secondarySession.close();
                    return;
                }
            }
            secondarySession.close();
            return;
        }
        finally {
            primarySession.close();
        }
    }

    protected <D extends BaseDictionary> void processDBPropertiesStorage(PhysicalStorage primaryPhysicalStorage, PhysicalStorage secondaryPhysicalStorage, LongRunningTask.EventsCallback callback) throws Throwable {
        String key;
        DBPropertiesPhysicalStorage primaryDBPropertiesPhysicalStorage = primaryPhysicalStorage.getDBPropertiesStorage();
        DBPropertiesPhysicalStorage secondaryDBPropertiesPhysicalStorage = secondaryPhysicalStorage.getDBPropertiesStorage();
        Map keys1 = primaryDBPropertiesPhysicalStorage.getAllKeys();
        Map keys2 = secondaryDBPropertiesPhysicalStorage.getAllKeys();
        for (Map.Entry entity : keys1.entrySet()) {
            key = (String)entity.getKey();
            String value1 = (String)entity.getValue();
            try {
                String value2 = (String)keys2.get(key);
                if (this.isObjectsEquals(value1, value2)) continue;
                this.addDBProperty(key, value1, value2);
                if (this.config.isSearchOverMax() || this.dbPropertiesStorageResult.size() < this.getMaxResultCount()) continue;
                return;
            }
            catch (Throwable t) {
                if (this.config.isStopOnError()) {
                    throw t;
                }
                this.errorCount.incrementAndGet();
                this.log.error(String.format("error in task (class %s, key %s, value %s): %s", "DBProperties", String.valueOf(key), String.valueOf(value1), String.valueOf(t)), t);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, key {1}, value {2}: {3}", (Throwable)t, (Object[])new Object[]{"PhysicalBulkDictionaryMetadata", String.valueOf(key), String.valueOf(value1), String.valueOf(t)}));
            }
        }
        for (Map.Entry entity : keys2.entrySet()) {
            key = (String)entity.getKey();
            try {
                if (keys1.containsKey(key)) continue;
                this.addDBProperty(key, null, (String)entity.getValue());
                if (this.config.isSearchOverMax() || this.dbPropertiesStorageResult.size() < this.getMaxResultCount()) continue;
                return;
            }
            catch (Throwable t) {
                if (this.config.isStopOnError()) {
                    throw t;
                }
                this.errorCount.incrementAndGet();
                this.log.error(String.format("error in task (class %s, key %s): %s", "DBProperties", String.valueOf(key), String.valueOf(t)), t);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, key {1}: {2}", (Throwable)t, (Object[])new Object[]{"PhysicalBulkDictionaryMetadata", String.valueOf(key), String.valueOf(t)}));
            }
        }
    }

    protected void processEntityType(PhysicalStorage primaryStorage, PhysicalStorage secondaryStorage, Class<?> clazz, Part part, LongRunningTask.EventsCallback callback) throws Throwable {
        if (BaseDictionary.class.isAssignableFrom(clazz)) {
            if (!this.config.isSearchOverMax() && this.dictionaryStorageResult.size() >= this.getMaxResultCount()) {
                return;
            }
            this.processDictionaryStorage(primaryStorage, secondaryStorage, part, clazz, callback);
        } else if (BaseEntity.class.isAssignableFrom(clazz)) {
            if (!this.config.isSearchOverMax() && this.entityStorageResult.size() >= this.getMaxResultCount()) {
                return;
            }
            this.processEntityStorage(primaryStorage, secondaryStorage, part, clazz, callback);
        } else if (BaseAsset.class.isAssignableFrom(clazz)) {
            if (!this.config.isSearchOverMax() && this.assetStorageResult.size() >= this.getMaxResultCount()) {
                return;
            }
            this.processAssetStorage(primaryStorage, secondaryStorage, part, clazz, callback);
        } else {
            throw new IllegalArgumentException("Wrong class: " + String.valueOf(clazz));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(final LongRunningTask.EventsCallback callback) throws Exception {
        Collection<Class<?>> entityTypeList;
        this.log.debug("task started");
        final PhysicalStorage primaryStorage = this.getPrimaryStorage();
        final PhysicalStorage secondaryStorage = this.getSecondaryStorage();
        if (this.doneTo != null) {
            this.partList = this.getPartList(this.doneTo, this.config.isUsedCreateDate(), callback);
        }
        if (this.partList == null) {
            this.partList = this.getPartList(null, this.config.isUsedCreateDate(), callback);
        }
        boolean isDbPropertiesProcess = (entityTypeList = this.getEntityTypeList()).contains(FindDifferentsTask2Configuration.DBPropertiesType.class) && !this.isDBPropertiesStorageProcessed;
        entityTypeList.remove(FindDifferentsTask2Configuration.DBPropertiesType.class);
        boolean isBulkDictionaryProcess = entityTypeList.contains(PhysicalBulkDictionaryData.class) && !this.isBulkDictionaryStorageProcessed;
        entityTypeList.remove(PhysicalBulkDictionaryData.class);
        int typeCount = entityTypeList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("part count %d, type count %d", this.partList.size(), typeCount));
        }
        ExecutorServiceFacade service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool(this.getClass().getName(), this.config.getThreadCount() > 0 ? this.config.getThreadCount() : 1);
        try {
            final int maxCount = this.partList.size() * typeCount + (isDbPropertiesProcess ? 1 : 0) + (isBulkDictionaryProcess ? 1 : 0);
            this.doneCount += this.totalCount == -1 ? 0 : this.totalCount - maxCount;
            final int resumeDelta = this.doneCount;
            this.totalCount = maxCount;
            final CountDownLatch countDown = new CountDownLatch(maxCount);
            if (isDbPropertiesProcess) {
                service.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block9: {
                            try {
                                if (FindDifferentsTask2.this.isToBeStopped()) {
                                    return;
                                }
                                try {
                                    FindDifferentsTask2.this.processDBPropertiesStorage(primaryStorage, secondaryStorage, callback);
                                    long current = (long)maxCount - countDown.getCount() + 1L;
                                    byte progress = (byte)(100L * (current + (long)resumeDelta) / (long)(maxCount + resumeDelta));
                                    callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u0438\u0437 {1}", (Object[])new Object[]{current + (long)resumeDelta, maxCount + resumeDelta}));
                                    callback.updateProgress(progress);
                                }
                                catch (Throwable t) {
                                    FindDifferentsTask2.this.errorCount.incrementAndGet();
                                    FindDifferentsTask2.this.log.error("error in task", t);
                                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 DBProperties: {0}", (Throwable)t, (Object[])new Object[]{t.toString()}));
                                    if (!FindDifferentsTask2.this.config.isStopOnError() || FindDifferentsTask2.this.isToBeStopped()) break block9;
                                    FindDifferentsTask2.this.log.debug("stop task");
                                    try {
                                        FindDifferentsTask2.this.stop();
                                    }
                                    catch (Exception e) {
                                        FindDifferentsTask2.this.log.error("unable to stop task", (Throwable)e);
                                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Throwable)t, (Object[])new Object[0]));
                                    }
                                }
                            }
                            finally {
                                FindDifferentsTask2.this.isDBPropertiesStorageProcessed = true;
                                countDown.countDown();
                            }
                        }
                    }
                });
            }
            if (isBulkDictionaryProcess) {
                service.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block9: {
                            try {
                                if (FindDifferentsTask2.this.isToBeStopped()) {
                                    return;
                                }
                                try {
                                    FindDifferentsTask2.this.processBulkDictionaryStorage(primaryStorage, secondaryStorage, callback);
                                    long current = (long)maxCount - countDown.getCount() + 1L;
                                    byte progress = (byte)(100L * (current + (long)resumeDelta) / (long)(maxCount + resumeDelta));
                                    callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u0438\u0437 {1}", (Object[])new Object[]{current + (long)resumeDelta, maxCount + resumeDelta}));
                                    callback.updateProgress(progress);
                                }
                                catch (Throwable t) {
                                    FindDifferentsTask2.this.errorCount.incrementAndGet();
                                    FindDifferentsTask2.this.log.error("error in task", t);
                                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 PhysicalBulkDictionaryData: {0}", (Throwable)t, (Object[])new Object[]{t.toString()}));
                                    if (!FindDifferentsTask2.this.config.isStopOnError() || FindDifferentsTask2.this.isToBeStopped()) break block9;
                                    FindDifferentsTask2.this.log.debug("stop task");
                                    try {
                                        FindDifferentsTask2.this.stop();
                                    }
                                    catch (Exception e) {
                                        FindDifferentsTask2.this.log.error("unable to stop task", (Throwable)e);
                                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Throwable)t, (Object[])new Object[0]));
                                    }
                                }
                            }
                            finally {
                                FindDifferentsTask2.this.isBulkDictionaryStorageProcessed = true;
                                countDown.countDown();
                            }
                        }
                    }
                });
            }
            final int pd = Math.max(maxCount / 20, 1);
            for (final Part part : this.partList) {
                part.getDownCount().set(typeCount);
                for (final Class<?> entityType : entityTypeList) {
                    service.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block10: {
                                try {
                                    if (FindDifferentsTask2.this.isToBeStopped()) {
                                        return;
                                    }
                                    try {
                                        FindDifferentsTask2.this.processEntityType(primaryStorage, secondaryStorage, entityType, part, callback);
                                        long current = (long)maxCount - countDown.getCount() + 1L;
                                        byte progress = (byte)(100L * (current + (long)resumeDelta) / (long)(maxCount + resumeDelta));
                                        if ((current + (long)resumeDelta) % (long)pd == 0L || progress >= 100 || FindDifferentsTask2.this.isToBeStopped()) {
                                            callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u0438\u0437 {1}", (Object[])new Object[]{current + (long)resumeDelta, maxCount + resumeDelta}));
                                            callback.updateProgress(progress);
                                        }
                                    }
                                    catch (Throwable t) {
                                        FindDifferentsTask2.this.errorCount.incrementAndGet();
                                        FindDifferentsTask2.this.log.error("error in task", t);
                                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}: {1}", (Throwable)t, (Object[])new Object[]{entityType.getName(), t.toString()}));
                                        if (!FindDifferentsTask2.this.config.isStopOnError() || FindDifferentsTask2.this.isToBeStopped()) break block10;
                                        FindDifferentsTask2.this.log.debug("stop task");
                                        try {
                                            FindDifferentsTask2.this.stop();
                                        }
                                        catch (Exception e) {
                                            FindDifferentsTask2.this.log.error("unable to stop task", (Throwable)e);
                                            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Throwable)t, (Object[])new Object[0]));
                                        }
                                    }
                                }
                                finally {
                                    part.getDownCount().decrementAndGet();
                                    countDown.countDown();
                                }
                            }
                        }
                    });
                }
            }
            countDown.await();
        }
        finally {
            service.dispose();
        }
        if (!this.isToBeStopped()) {
            if (this.entityStorageResultCount.get() > 0 || this.indexStorageResultCount.get() > 0 || this.dictionaryStorageResultCount.get() > 0 || this.assetStorageResultCount.get() > 0 || this.bulkDictionaryStorageResultCount.get() > 0 || this.dbPropertiesStorageResultCount.get() > 0) {
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043d\u0435\u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u044f \u043d\u0430\u0439\u0434\u0435\u043d\u044b.", (Object[])new Object[0]));
                Document doc = this.buildDocument();
                EntityContainer container = EntityContainer.create((BaseEntity)doc);
                LogicalStorage storage = LogicalStorage.get();
                storage.getEntityStorage().save(container, false);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0441 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430\u043c\u0438 \u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d.", (Object[])new Object[0]));
            } else {
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u0435\u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.", (Object[])new Object[0]));
            }
        }
        callback.taskFinished();
        this.log.debug("task finished");
    }

    protected Document buildDocument() {
        Document doc = new Document();
        doc.setCreated(new Date());
        doc.setType(DocumentType.OTHER);
        doc.setName("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u044f.txt");
        doc.setTitle("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u044f");
        doc.setContentType(ContentType.TEXT);
        StringBuilder sb = new StringBuilder();
        sb.append("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u044f\n\n");
        sb.append("\u041f\u0435\u0440\u0432\u0438\u0447\u043d\u043e\u0435 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435: ").append(this.config.getPrimaryStorageUid()).append("\n");
        sb.append("\u0412\u0442\u043e\u0440\u0438\u0447\u043d\u043e\u0435 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435: ").append(this.config.getSecondaryStorageUid()).append("\n");
        sb.append("\u0414\u0430\u0442\u0430: ").append(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(doc.getCreated())).append("\n");
        sb.append("\n");
        this.addSection(sb, "Entity storage", this.getResultText(this.entityStorageResult), this.entityStorageResultCount.get());
        this.addSection(sb, "Index storage", this.getResultText(this.indexStorageResult), this.indexStorageResultCount.get());
        this.addSection(sb, "Dictionary storage", this.getResultText(this.dictionaryStorageResult), this.dictionaryStorageResultCount.get());
        this.addSection(sb, "Asset storage", this.getResultText(this.assetStorageResult), this.assetStorageResultCount.get());
        this.addSection(sb, "Bulk dictionary storage", this.bulkDictionaryStorageResult, this.bulkDictionaryStorageResultCount.get());
        this.addSection(sb, "DB properties storage", this.dbPropertiesStorageResult, this.dbPropertiesStorageResultCount.get());
        doc.setContent(sb.toString().getBytes(Charset.forName("UTF-8")));
        if (this.showDocument()) {
            this.log.info("Document:\n" + sb.toString());
        } else {
            this.log.debug("Document:\n" + sb.toString());
        }
        return doc;
    }

    protected boolean showDocument() {
        return false;
    }

    protected void addSection(StringBuilder sb, String title, Iterable<String> results, int count) {
        sb.append(title).append("\n");
        if (count > 0) {
            for (String line : results) {
                sb.append("  ").append(line).append("\n");
            }
            sb.append("  ").append(String.format("\u0412\u0441\u0435\u0433\u043e: %d", count)).append("\n");
        } else {
            sb.append("  ").append("\u0420\u0430\u0437\u043b\u0438\u0447\u0438\u0439 \u043d\u0435\u0442\n");
        }
        sb.append("\n");
    }

    protected Iterable<String> getResultText(final Iterable<Result> delegate) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                final Iterator ownerIterator = delegate.iterator();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return ownerIterator.hasNext();
                    }

                    @Override
                    public String next() {
                        Result next = (Result)ownerIterator.next();
                        return next != null ? next.getText() : null;
                    }

                    @Override
                    public void remove() {
                        ownerIterator.remove();
                    }
                };
            }
        };
    }

    public void toXML(Element elm) throws Exception {
        this.config.toXML(elm);
        XHelper.writeInt((Element)elm, (String)"totalCount", (int)this.totalCount);
        XHelper.writeInt((Element)elm, (String)"doneCount", (int)this.doneCount);
        XHelper.writeBoolean((Element)elm, (String)"isdbpropertiesstorageprocessed", (boolean)this.isDBPropertiesStorageProcessed);
        if (this.isDBPropertiesStorageProcessed) {
            XHelper.writeInt((Element)elm, (String)"dbpropertiesstorageresultcount", (int)this.dbPropertiesStorageResultCount.get());
            for (String string : this.dbPropertiesStorageResult) {
                XHelper.writeString((Element)elm, (String)"dbpropertiesstorageresult/item", (String)string);
            }
        }
        XHelper.writeBoolean((Element)elm, (String)"isbulkdictionarystorageprocessed", (boolean)this.isBulkDictionaryStorageProcessed);
        if (this.isBulkDictionaryStorageProcessed) {
            XHelper.writeInt((Element)elm, (String)"bulkdictionarystorageresultcount", (int)this.bulkDictionaryStorageResultCount.get());
            for (String string : this.bulkDictionaryStorageResult) {
                XHelper.writeString((Element)elm, (String)"bulkdictionarystorageresult/item", (String)string);
            }
        }
        if (this.entityStorageResultCount.get() > 0 && this.partList != null) {
            for (Result result : this.entityStorageResult) {
                if (result.getPart() != null) continue;
                XHelper.writeString((Element)elm, (String)"entitystorageresult/item", (String)result.getText());
            }
            int _entityStorageResultCount = 0;
            for (Part part : this.partList) {
                if (part.getDownCount().get() != 0) continue;
                _entityStorageResultCount += part.getAssetStorageResultCount().get();
                for (Result result : this.entityStorageResult) {
                    if (result.getPart() != part) continue;
                    XHelper.writeString((Element)elm, (String)"entitystorageresult/item", (String)result.getText());
                }
            }
            XHelper.writeInt((Element)elm, (String)"entityStorageResultCount", (int)_entityStorageResultCount);
        }
        if (this.indexStorageResultCount.get() > 0 && this.partList != null) {
            for (Result result : this.indexStorageResult) {
                if (result.getPart() != null) continue;
                XHelper.writeString((Element)elm, (String)"indexstorageresult/item", (String)result.getText());
            }
            int _indexStorageResultCount = 0;
            for (Part part : this.partList) {
                if (part.getDownCount().get() != 0) continue;
                _indexStorageResultCount += part.getIndexStorageResultCount().get();
                for (Result result : this.indexStorageResult) {
                    if (result.getPart() != part) continue;
                    XHelper.writeString((Element)elm, (String)"indexstorageresult/item", (String)result.getText());
                }
            }
            XHelper.writeInt((Element)elm, (String)"indexStorageResultCount", (int)_indexStorageResultCount);
        }
        if (this.dictionaryStorageResultCount.get() > 0 && this.partList != null) {
            for (Result result : this.dictionaryStorageResult) {
                if (result.getPart() != null) continue;
                XHelper.writeString((Element)elm, (String)"dictionarystorageresult/item", (String)result.getText());
            }
            int _dictionaryStorageResultCount = 0;
            for (Part part : this.partList) {
                if (part.getDownCount().get() != 0) continue;
                _dictionaryStorageResultCount += part.getDictionaryStorageResultCount().get();
                for (Result result : this.dictionaryStorageResult) {
                    if (result.getPart() != part) continue;
                    XHelper.writeString((Element)elm, (String)"dictionarystorageresult/item", (String)result.getText());
                }
            }
            XHelper.writeInt((Element)elm, (String)"dictionaryStorageResultCount", (int)_dictionaryStorageResultCount);
        }
        if (this.assetStorageResultCount.get() > 0 && this.partList != null) {
            for (Result result : this.assetStorageResult) {
                if (result.getPart() != null) continue;
                XHelper.writeString((Element)elm, (String)"assetstorageresult/item", (String)result.getText());
            }
            int _assetStorageResultCount = 0;
            for (Part part : this.partList) {
                if (part.getDownCount().get() != 0) continue;
                _assetStorageResultCount += part.getAssetStorageResultCount().get();
                for (Result result : this.assetStorageResult) {
                    if (result.getPart() != part) continue;
                    XHelper.writeString((Element)elm, (String)"assetstorageresult/item", (String)result.getText());
                }
            }
            XHelper.writeInt((Element)elm, (String)"assetStorageResultCount", (int)_assetStorageResultCount);
        }
        if (this.partList != null) {
            Date date = null;
            for (Part part : this.partList) {
                if (part.getDownCount().get() != 0) break;
                date = part.getFrom();
            }
            if (date != null) {
                XHelper.writeDate((Element)elm, (String)"doneto", date);
            }
        }
    }

    public void fromXML(Element elm) throws Exception {
        String line;
        this.config = new FindDifferentsTask2Configuration();
        this.config.fromXML(elm);
        this.totalCount = XHelper.readInt((Element)elm, (String)"totalCount", (int)-1);
        this.doneCount = XHelper.readInt((Element)elm, (String)"doneCount", (int)0);
        this.isDBPropertiesStorageProcessed = XHelper.readBoolean((Element)elm, (String)"isdbpropertiesstorageprocessed", (boolean)false);
        this.dbPropertiesStorageResultCount.set(0);
        this.dbPropertiesStorageResult.clear();
        if (this.isDBPropertiesStorageProcessed) {
            this.dbPropertiesStorageResultCount.set(XHelper.readInt((Element)elm, (String)"dbpropertiesstorageresultcount", (int)0));
            for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"dbpropertiesstorageresult/item")) {
                line = XHelper.readString((Element)itemElm, (String)".");
                this.dbPropertiesStorageResult.add(line);
            }
        }
        this.isBulkDictionaryStorageProcessed = XHelper.readBoolean((Element)elm, (String)"isbulkdictionarystorageprocessed", (boolean)false);
        this.bulkDictionaryStorageResultCount.set(0);
        this.bulkDictionaryStorageResult.clear();
        if (this.isBulkDictionaryStorageProcessed) {
            this.bulkDictionaryStorageResultCount.set(XHelper.readInt((Element)elm, (String)"bulkdictionarystorageresultcount", (int)0));
            for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"bulkdictionarystorageresult/item")) {
                line = XHelper.readString((Element)itemElm, (String)".");
                this.bulkDictionaryStorageResult.add(line);
            }
        }
        this.entityStorageResult.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"entitystorageresult/item")) {
            line = XHelper.readString((Element)itemElm, (String)".");
            this.entityStorageResult.add(new Result(line, null));
        }
        this.entityStorageResultCount.set(XHelper.readInt((Element)elm, (String)"entityStorageResultCount", (int)0));
        this.indexStorageResult.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"indexstorageresult/item")) {
            line = XHelper.readString((Element)itemElm, (String)".");
            this.indexStorageResult.add(new Result(line, null));
        }
        this.indexStorageResultCount.set(XHelper.readInt((Element)elm, (String)"indexStorageResultCount", (int)0));
        this.dictionaryStorageResult.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"dictionarystorageresult/item")) {
            line = XHelper.readString((Element)itemElm, (String)".");
            this.dictionaryStorageResult.add(new Result(line, null));
        }
        this.dictionaryStorageResultCount.set(XHelper.readInt((Element)elm, (String)"dictionaryStorageResultCount", (int)0));
        this.assetStorageResult.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"assetstorageresult/item")) {
            line = XHelper.readString((Element)itemElm, (String)".");
            this.assetStorageResult.add(new Result(line, null));
        }
        this.assetStorageResultCount.set(XHelper.readInt((Element)elm, (String)"assetStorageResultCount", (int)0));
        this.doneTo = XHelper.readDate((Element)elm, (String)"doneto");
    }

    protected <D extends BaseDictionary> boolean isBulkDictionariesEquals(PhysicalBulkDictionaryData<D> first, PhysicalBulkDictionaryData<D> second) throws Exception {
        if (first == null) {
            return second == null;
        }
        return second != null && this.isObjectsEquals(first.getDictionaryType(), second.getDictionaryType()) && this.isObjectsEquals(first.getModified(), second.getModified()) && this.isObjectsEquals(first.getData(), second.getData());
    }

    protected <A extends BaseAsset> boolean isAssetsEquals(PhysicalAssetData<A> first, PhysicalAssetData<A> second) throws Exception {
        return first != null ? second != null && this.isObjectsEquals(first.getAsset().getModified(), second.getAsset().getModified()) : second == null;
    }

    protected <E extends BaseEntity, I extends EntityIndex<E>> Collection<String> getIndexProperties(Class<I> clazz) {
        ArrayList<String> properties = new ArrayList<String>();
        LogicalStorageRegistry storageRegistry = LogicalStorageRegistry.get();
        IndexHandler handler = storageRegistry.getIndexHandler(clazz);
        if (handler == null) {
            throw new IllegalStateException("No handler found for index: " + clazz.getName());
        }
        Class indexClass = handler.getIndexClass();
        MetaRegistry metaRegistry = MetaRegistry.get();
        IndexType indexType = (IndexType)metaRegistry.getIndexes().get(indexClass.getName());
        if (indexType == null) {
            throw new IllegalStateException("No meta information found for index: " + indexClass.getName() + ", handler is " + handler.getClass().getName());
        }
        properties.addAll(indexType.getProperties().keySet());
        return properties;
    }

    protected <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> boolean isEqualIndexDatas(D first, D second, Collection<String> properties) throws Exception {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        return this.isObjectsEquals(first, second, properties);
    }

    protected <D extends BaseDictionary> boolean isDictionariesEqual(PhysicalDictionaryData<D> first, PhysicalDictionaryData<D> second) throws Exception {
        if (first == null) {
            return second == null;
        }
        return second != null && this.isObjectsEquals(first.getUid(), second.getUid()) && this.isObjectsEquals(first.getCreated(), second.getCreated()) && this.isObjectsEquals(first.getModified(), second.getModified()) && this.isObjectsEquals(first.getDictionaryType(), second.getDictionaryType()) && this.isObjectsEquals(first.getCode(), second.getCode()) && this.isObjectsEquals(first.isDeleted(), second.isDeleted()) && this.isObjectsEquals(first.getData(), second.getData());
    }

    protected boolean isVersionsEquals(PhysicalVersionMetadataData first, PhysicalVersionMetadataData second) throws Exception {
        if (first == null) {
            return second == null;
        }
        return second != null && this.isObjectsEquals(first.getModified(), second.getModified());
    }

    protected boolean isObjectsEquals(Object first, Object second, Collection<String> properties) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (first == null) {
            return second == null;
        }
        if (second == null || !first.getClass().equals(second.getClass())) {
            return false;
        }
        Class<?> clazz = first.getClass();
        for (String property : properties) {
            String methodName = FindDifferentsTask2.getGetterMethodName(property);
            Method method = FindDifferentsTask2.getDeclaredMethod(clazz, methodName);
            if (method == null) {
                methodName = FindDifferentsTask2.getGetterMethodName2(property);
                method = FindDifferentsTask2.getDeclaredMethod(clazz, methodName);
            }
            if (method != null) {
                Object secondValue;
                Object firstValue;
                if (!Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                }
                if (this.isObjectsEquals(firstValue = method.invoke(first, new Object[0]), secondValue = method.invoke(first, new Object[0]))) continue;
                return false;
            }
            Field field = FindDifferentsTask2.getDeclaredField(clazz, property);
            if (field != null) {
                Object secondValue;
                Object firstValue;
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                if (this.isObjectsEquals(firstValue = field.get(first), secondValue = field.get(first))) continue;
                return false;
            }
            throw new IllegalArgumentException("Getter for property " + property + " not found");
        }
        return true;
    }

    private static String getGetterMethodName(String propertyName) {
        return "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private static String getGetterMethodName2(String propertyName) {
        return "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private static Method getDeclaredMethod(Class<?> clazz, String methodName) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!methodName.equals(method.getName()) || method.getReturnType() == Void.TYPE || method.getParameterTypes().length != 0) continue;
            return method;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null) {
            return null;
        }
        return FindDifferentsTask2.getDeclaredMethod(superclass, methodName);
    }

    private static Field getDeclaredField(Class<?> clazz, String fieldName) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null) {
            return null;
        }
        return FindDifferentsTask2.getDeclaredField(superclass, fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isXSerializablesEquals(XSerializable first, XSerializable second) throws Exception {
        String secondXML;
        String firstXML;
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        org.w3c.dom.Document document1 = DocumentBuilderHelper.newDocument();
        Element element1 = document1.createElement("object");
        document1.appendChild(element1);
        org.w3c.dom.Document document2 = DocumentBuilderHelper.newDocument();
        Element element2 = document2.createElement("object");
        document2.appendChild(element2);
        first.toXML(element1);
        second.toXML(element2);
        try (StringWriter out1 = new StringWriter();){
            XUtil.newTransformer().transform(new DOMSource(document1), new StreamResult(out1));
            firstXML = ((Object)out1).toString();
        }
        try (StringWriter out2 = new StringWriter();){
            XUtil.newTransformer().transform(new DOMSource(document2), new StreamResult(out2));
            secondXML = ((Object)out2).toString();
        }
        return this.isObjectsEquals(firstXML, secondXML);
    }

    protected boolean isObjectsEquals(Object first, Object second) {
        if (first == null) {
            return second == null;
        }
        Class<?> firstClass = first.getClass();
        if (second == null || !firstClass.equals(second.getClass())) {
            return false;
        }
        if (firstClass.getComponentType() != null) {
            return this.isArraysEquals(first, second);
        }
        if (Collection.class.isAssignableFrom(firstClass)) {
            return this.isCollectionsEquals((Collection)first, (Collection)second);
        }
        return first.equals(second);
    }

    protected boolean isArraysEquals(Object first, Object second) {
        if (first == null) {
            return second == null;
        }
        if (second == null || !first.getClass().equals(second.getClass())) {
            return false;
        }
        int firstLength = Array.getLength(first);
        if (firstLength != Array.getLength(second)) {
            return false;
        }
        for (int i = 0; i < firstLength; ++i) {
            if (this.isObjectsEquals(Array.get(first, i), Array.get(second, i))) continue;
            return false;
        }
        return true;
    }

    protected boolean isCollectionsEquals(Collection<?> first, Collection<?> second) {
        if (first == null) {
            return second == null;
        }
        if (second == null || !first.getClass().equals(second.getClass())) {
            return false;
        }
        int firstLength = first.size();
        if (firstLength != second.size()) {
            return false;
        }
        for (Object element : first) {
            boolean f = false;
            for (Object element2 : second) {
                if (!this.isObjectsEquals(element, element2)) continue;
                f = true;
                break;
            }
            if (f) continue;
            return false;
        }
        return true;
    }

    protected static class Result {
        private final String text;
        private final Part part;

        public Result(String text, Part part) {
            this.text = text;
            this.part = part;
        }

        public String getText() {
            return this.text;
        }

        public Part getPart() {
            return this.part;
        }
    }

    protected static class Part {
        private final Date from;
        private final Date to;
        private final AtomicInteger downCount = new AtomicInteger(-1);
        private final AtomicInteger entityStorageResultCount = new AtomicInteger();
        private final AtomicInteger indexStorageResultCount = new AtomicInteger();
        private final AtomicInteger dictionaryStorageResultCount = new AtomicInteger();
        private final AtomicInteger assetStorageResultCount = new AtomicInteger();

        public Part(Date from, Date to) {
            this.from = from;
            this.to = to;
        }

        public Date getFrom() {
            return this.from;
        }

        public Date getTo() {
            return this.to;
        }

        public AtomicInteger getDownCount() {
            return this.downCount;
        }

        public AtomicInteger getEntityStorageResultCount() {
            return this.entityStorageResultCount;
        }

        public AtomicInteger getIndexStorageResultCount() {
            return this.indexStorageResultCount;
        }

        public AtomicInteger getDictionaryStorageResultCount() {
            return this.dictionaryStorageResultCount;
        }

        public AtomicInteger getAssetStorageResultCount() {
            return this.assetStorageResultCount;
        }
    }
}

