/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.model.helpers.HotelUnholdHelper;
import java.util.Date;
import java.util.HashSet;

public class HotelUnholdTask
extends BaseScheduledTask {
    protected void doJob() throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.onHold.name(), (Object)Boolean.TRUE));
        query.getCriteria().getCriterions().add(SearchCriterion.lt((String)CommonProductIndex.Property.hotelCheckOutDate.name(), (Object)new Date()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.travelSubject.name(), (Object)TravelSubject.HOTEL_RESERVATION));
        HashSet<String> uids = new HashSet<String>();
        for (CommonProductIndex idx : EntityStorage.get().search(CommonProductIndex.class, query).getData()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (uids.contains(idx.getSource().getUid())) continue;
            uids.add(idx.getSource().getUid());
            String bookingFileUid = idx.getSource().getUid();
            this.log.info("found booking file to unhold: " + bookingFileUid);
            try {
                LockUtil.lock((EntityReference)idx.getSource(), bfCtr -> {
                    if (bfCtr == null) {
                        return;
                    }
                    String bookingFileNumber = ((BookingFile)bfCtr.getEntity()).getNumber();
                    this.log.info("trying to unhold booking file " + bookingFileNumber + " (UID=" + bookingFileUid + ")");
                    HotelUnholdHelper.unhold((EntityContainer<BookingFile>)bfCtr, this.log);
                });
            }
            catch (Exception e) {
                this.log.error("failed to unhold booking file " + bookingFileUid, (Throwable)e);
            }
        }
    }
}

