/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBusInvokerTask
extends BaseScheduledTask {
    private String adapterId;
    private String routeId;
    private boolean async;
    private final Map<String, Object> data = new HashMap<String, Object>();
    private String loggerName;

    protected void configure(Properties properties) throws Exception {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if ("adapterId".equals(entry.getKey())) {
                this.adapterId = (String)entry.getValue();
                this.data.put("adapterId", this.adapterId);
                continue;
            }
            if ("routeId".equals(entry.getKey())) {
                this.routeId = (String)entry.getValue();
                this.data.put("routeId", this.routeId);
                continue;
            }
            if ("async".equals(entry.getKey())) {
                this.async = Boolean.parseBoolean((String)entry.getValue());
                continue;
            }
            if ("loggerName".equals(entry.getKey())) {
                this.loggerName = (String)entry.getValue();
                continue;
            }
            this.data.put((String)entry.getKey(), entry.getValue());
        }
        if (this.adapterId == null && this.routeId == null) {
            throw Xeption.forAdmin((String)"\u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 'adapterId' \u0438\u043b\u0438 'routeId'", (Object[])new Object[0]);
        }
    }

    protected String getMetricKey() {
        return this.adapterId;
    }

    protected String getLockName(Properties properties) {
        return super.getLockName(properties) + ":" + (this.routeId != null ? this.routeId : MiscUtil.guarded((String)this.adapterId));
    }

    protected void doJob() throws Exception {
        Logger logger;
        Logger logger2 = TextUtil.isBlank((String)this.loggerName) ? LoggerFactory.getLogger((String)String.format("%s.%s", IBusInvokerTask.class.getName(), this.routeId == null ? this.adapterId : this.routeId)) : (logger = LoggerFactory.getLogger((String)this.loggerName));
        if (this.async) {
            logger.debug("route execution started in async mode");
            if (this.routeId != null) {
                IntegrationBusFacade.get().sendRouteAsync(this.routeId, this.data);
            } else {
                IntegrationBusFacade.get().getRequestReplyAdapter(this.adapterId).sendAsync(this.data);
            }
        } else {
            logger.debug("route execution started in sync mode");
            if (this.routeId != null) {
                IntegrationBusFacade.get().processRouteSync(this.routeId, this.data);
            } else {
                IntegrationBusFacade.get().getRequestReplyAdapter(this.adapterId).processSync(this.data);
            }
            logger.debug("route execution finished");
            Map messages = (Map)this.data.get("messages");
            if (messages != null) {
                block5: for (Map.Entry entry : messages.entrySet()) {
                    Date date = (Date)entry.getKey();
                    Message message = (Message)entry.getValue();
                    switch (message.getType()) {
                        case MESSAGE: {
                            logger.debug(String.format("%s %s", date, message.getMessage().toString()));
                            continue block5;
                        }
                        case WARNING: {
                            logger.warn(String.format("%s %s", date, message.getMessage().toString()));
                            continue block5;
                        }
                        case ERROR: {
                            logger.error(String.format("%s %s", date, message.getMessage().toString()));
                            continue block5;
                        }
                    }
                    logger.debug(String.format("%s %s", date, message.getMessage().toString()));
                }
            }
        }
    }
}

