/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public class IbusPollingConsumersLaunchTask
extends BaseScheduledTask {
    private final Set<String> consumerIds = new LinkedHashSet<String>();

    protected void configure(Properties properties) throws Exception {
        super.configure(properties);
        String consumers = properties.getProperty("consumers");
        this.consumerIds.clear();
        if (TextUtil.isBlank((String)consumers)) {
            return;
        }
        for (String item : consumers.split(",")) {
            if (TextUtil.isBlank((String)item)) continue;
            this.consumerIds.add(item.trim());
        }
    }

    protected void doJob() throws Exception {
        if (!Environment.isPublished(IntegrationBusFacade.class)) {
            return;
        }
        IntegrationBusFacade engine = IntegrationBusFacade.get();
        for (String item : this.consumerIds) {
            try {
                engine.startConsumer(item);
            }
            catch (Throwable t) {
                this.log.error("error while polling consumer " + item, t);
            }
        }
    }
}

