/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.InitializeUserAccountCreateDateTaskConfiguration;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseQueryObjectsTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class InitializeUserAccountCreateDateTask
extends BaseQueryObjectsTask<InitializeUserAccountCreateDateTaskConfiguration> {
    private int threadCount;
    private Date createDate;

    @Override
    public void configure(InitializeUserAccountCreateDateTaskConfiguration configuration) throws Exception {
        super.configure(configuration);
        this.threadCount = Math.max(configuration.getThreadCount(), 1);
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)MetaRegistryHelper.getDisplayName(InitializeUserAccountCreateDateTaskConfiguration.class), (Object[])new Object[0]);
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.createDate = new Date();
        int totalCount = this.count(this.createCallback(0, callback), UserAccount.class);
        this.processObjects(UserAccount.class.getName(), callback, this.createCallback(totalCount, callback));
        callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430, \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432", (Object[])new Object[]{totalCount}));
        callback.taskFinished();
    }

    private BaseQueryObjectsTask.ProcessCallback createCallback(final int count, final LongRunningTask.EventsCallback callback) {
        return new BaseQueryObjectsTask.ProcessCallback(){
            private static final String UID_ALIAS = "uidAlias";

            @Override
            public int getThreadsCount() {
                return InitializeUserAccountCreateDateTask.this.threadCount;
            }

            @Override
            public int getTotalCount() {
                return count;
            }

            @Override
            public void processObject(Class<?> objectClass, Map<String, String> obj) {
                String uid = obj.get(UID_ALIAS);
                UserAccount userAccount = (UserAccount)LogicalStorage.get().getAssetStorage().load(UserAccount.class, uid);
                try {
                    if (userAccount == null) {
                        InitializeUserAccountCreateDateTask.this.log.warn("unable to load user account with uid {}", (Object)uid);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0443\u0447\u0435\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c {0}", (Object[])new Object[]{uid}));
                        return;
                    }
                    if (userAccount.getCreateDate() != null) {
                        InitializeUserAccountCreateDateTask.this.log.warn("user account with uid {} had non-null create date", (Object)uid);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0443\u0447\u0435\u0442\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c {0} \u0438\u043c\u0435\u043b\u0430 \u043d\u0435\u043d\u0443\u043b\u0435\u0432\u0443\u044e \u0434\u0430\u0442\u0443 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", (Object[])new Object[]{uid}));
                        return;
                    }
                    userAccount.setCreateDate(InitializeUserAccountCreateDateTask.this.createDate);
                    LogicalStorage.get().getAssetStorage().save((BaseAsset)userAccount);
                    InitializeUserAccountCreateDateTask.this.log.debug("processed {}", (Object)userAccount);
                }
                catch (Exception e) {
                    InitializeUserAccountCreateDateTask.this.log.error("unable to process {}", (Object)userAccount);
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0443\u0447\u0435\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c {0}", (Object[])new Object[]{userAccount}));
                }
            }

            @Override
            public String getUid(Map<String, String> obj) {
                return obj.get(UID_ALIAS);
            }

            @Override
            public Collection<? extends Projection> getProjections(Class<?> cls) {
                ArrayList<Projection> result = new ArrayList<Projection>(1);
                result.add(Projection.property((String)"uid", (String)UID_ALIAS));
                return result;
            }

            @Override
            public String getThreadPrefix() {
                return "InitializeUserAccountCreateDateTask";
            }

            @Override
            public List<SearchCriterion> getCriterions(Class<?> cls) {
                ArrayList<SearchCriterion> result = new ArrayList<SearchCriterion>(1);
                result.add(SearchCriterion.eq((String)UserAccount.Property.createDate.name(), null));
                return result;
            }
        };
    }
}

