/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class KeyContactsTransformTask
extends BaseLongRunningTask<Serializable> {
    private final List<EntityReference<Organization>> orgs = new ArrayList<EntityReference<Organization>>();

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.KeyContactsTransformTask_transferringDataKeyContact, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        Element orgsElem = XmlUtil.addElement((Element)elm, (String)"organizations");
        orgsElem.setAttribute("className", "com.gridnine.xtrip.common.model.profile.Organization");
        for (EntityReference<Organization> orgRef : this.orgs) {
            Element uidElm = XmlUtil.addElement((Element)orgsElem, (String)"organization");
            uidElm.setAttribute("caption", orgRef.getCaption());
            XmlUtil.setValue((Element)uidElm, (String)orgRef.getUid());
        }
    }

    public void fromXML(Element elm) throws Exception {
        Element orgsElem = XmlUtil.getElement((Element)elm, (String)"organizations");
        String type = orgsElem.getAttribute("className");
        for (Element element : XmlUtil.getElements((Element)orgsElem, (String)"organization")) {
            String caption = element.getAttribute("caption");
            String value = XmlUtil.getValue((Element)element);
            try {
                Class<?> orgClass = Class.forName(type);
                EntityReference orgRef = new EntityReference(value, orgClass, caption);
                this.orgs.add((EntityReference<Organization>)orgRef);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("BEGIN Key contacts transform task");
        this.updateOrganizations();
        int count = this.orgs.size();
        int n = 0;
        try {
            for (EntityReference<Organization> orgRef : this.orgs) {
                if (this.isToBeStopped()) {
                    this.log.debug("task is interrupted");
                    return;
                }
                ++n;
                EntityContainer orgCont = EntityStorage.get().resolve(orgRef);
                if (orgCont == null) continue;
                Organization org = (Organization)orgCont.getEntity();
                String title = org.getShortName().getStringValue();
                byte progress = (byte)(100 * n / count);
                this.log.debug(String.format("processing organization %s: %s of %s (%s%%)", title, n, String.valueOf(count), String.valueOf(progress)));
                if (n % 20 == 0) {
                    callback.updateProgress(progress);
                }
                ArrayList<EntityReference> persons = new ArrayList<EntityReference>();
                Iterator metadataIterator = org.getMetadata().iterator();
                while (metadataIterator.hasNext()) {
                    Metadata m = (Metadata)metadataIterator.next();
                    if (m.getKey() == null || !m.getKey().getCode().equals("KEY_ORGANIZATION_KEY_CONTACT") || m.getValue() == null || !(m.getValue() instanceof EntityReference)) continue;
                    EntityReference perRef = (EntityReference)m.getValue();
                    persons.add(perRef);
                    metadataIterator.remove();
                }
                SabreProfileLineType lineType = persons.size() > 1 ? SabreProfileLineType.O : SabreProfileLineType.A;
                for (EntityReference perRef : persons) {
                    if (this.hasContact(org.getKeyContacts(), (EntityReference<Person>)perRef)) continue;
                    ProfileKeyContactPerson keyContact = new ProfileKeyContactPerson();
                    keyContact.setLineType(lineType);
                    keyContact.setPerson(perRef);
                    org.getKeyContacts().add(keyContact);
                }
                EntityStorage.get().save(orgCont, true);
            }
        }
        catch (Throwable e) {
            this.log.error("unable to process key contact data transforming of %s", e);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.KeyContactsTransformTask_errorOnMoveDataKeyContact, (Throwable)e, (Object[])new Object[0]));
        }
        finally {
            this.log.debug("END Cost Codes renaming task");
            callback.updateProgress((byte)100);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.CtfStatisticsTransformTask_completedTransferDataKeyContact, (Object[])new Object[0]));
            callback.taskFinished();
        }
    }

    private boolean hasContact(List<ProfileKeyContactPerson> keyContacts, EntityReference<Person> perRef) {
        for (ProfileKeyContactPerson k : keyContacts) {
            if (k.getPerson() == null || !k.getPerson().equals(perRef)) continue;
            return true;
        }
        return false;
    }

    private void updateOrganizations() throws Exception {
        if (!this.orgs.isEmpty()) {
            return;
        }
        List orgIndexes = EntityStorage.get().search(OrganizationIndex.class, new SearchQuery()).getData();
        for (OrganizationIndex orgIndex : orgIndexes) {
            this.orgs.add((EntityReference<Organization>)orgIndex.getSource());
        }
    }
}

