/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.LongRunningTaskDeleteTaskConfiguration;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.List;
import org.w3c.dom.Element;

public class LongRunningTaskDeleteTask
extends BaseLongRunningTask<LongRunningTaskDeleteTaskConfiguration> {
    private LongRunningTaskDeleteTaskConfiguration configuration;

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.LongRunningTaskDeleteTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        this.configuration = (LongRunningTaskDeleteTaskConfiguration)XHelper.readObject((Element)elm, (String)"configuration");
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeObject((Element)elm, (String)"configuration", (Object)this.configuration);
    }

    @Override
    public void configure(LongRunningTaskDeleteTaskConfiguration configuration) throws Exception {
        this.configuration = configuration;
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("long running task delete started");
        String jobClass = this.configuration.getJobClass();
        this.log.debug(String.format("jobClass -> %s", jobClass));
        callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key(Messages.LongRunningTaskDeleteTask_jobClass).parameters(new Object[]{jobClass}).build());
        if (TextUtil.isBlank((String)jobClass)) {
            this.log.error("unable to delete long running task -> job class value missing");
            callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.LongRunningTaskDeleteTask_longRunningTaskDeleteFailed).details(L10nResourcesManager.getStr((String)Messages.LongRunningTaskDeleteTask_jobClassValueMissing, (Object[])new Object[0])).build());
            throw new Exception("job class value missing");
        }
        int progressStart = 0;
        int progressEnd = 100;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)LongRunningTaskInfo.Property.taskClassName.name(), (Object)jobClass));
        List longRunningTaskInfos = AssetsStorage.get().search(LongRunningTaskInfo.class, query).getData();
        this.log.debug(String.format("long running task infos found -> %s", String.valueOf(longRunningTaskInfos.size())));
        callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key(Messages.LongRunningTaskDeleteTask_longRunningTaskInfosFound).parameters(new Object[]{String.valueOf(longRunningTaskInfos.size())}).build());
        int count = 0;
        int totalCount = longRunningTaskInfos.size();
        int deleteCount = 0;
        for (LongRunningTaskInfo longRunningTaskInfo : longRunningTaskInfos) {
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            this.handleProgress(callback, progressStart, progressEnd, count, totalCount);
            AssetsStorage.get().delete((BaseAsset)longRunningTaskInfo);
            this.log.debug(String.format("long running task info delete -> %s (%s)", longRunningTaskInfo, longRunningTaskInfo.getUid()));
            ++deleteCount;
            ++count;
        }
        this.log.debug(String.format("long running task infos deleted -> %s", String.valueOf(deleteCount)));
        callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key(Messages.LongRunningTaskDeleteTask_longRunningTaskInfosDeleted).parameters(new Object[]{String.valueOf(deleteCount)}).build());
        callback.taskFinished();
        this.log.debug("long running task delete finished");
    }

    private void handleProgress(LongRunningTask.EventsCallback callback, int progressStart, int progressEnd, int count, int total) {
        byte progress = (byte)(progressStart + (progressEnd - progressStart) * count / total);
        this.log.debug("long running task delete progress -> " + progress);
        callback.updateProgress(progress);
    }
}

