/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class MetadataBasedLongRunningTask<T extends BaseEntity>
extends BaseLongRunningTask<T> {
    private T config;
    private Object data;
    private EntityType ett;
    private final Map<String, Object> map = new HashMap<String, Object>();

    @Override
    public void configure(T configuration) throws Exception {
        this.config = configuration;
        this.ett = (EntityType)MetaRegistry.get().getEntities().get(configuration.getClass().getName());
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)this.ett.getDisplayName(), (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeObject((Element)elm, (String)"config", this.config);
        XHelper.writeObject((Element)elm, (String)"data", (Object)this.data);
    }

    public void fromXML(Element elm) throws Exception {
        this.config = (BaseEntity)XHelper.readObject((Element)elm, (String)"config");
        this.ett = (EntityType)MetaRegistry.get().getEntities().get(this.config.getClass().getName());
        this.data = XHelper.readObject((Element)elm, (String)"data");
    }

    @Override
    protected void doJob(final LongRunningTask.EventsCallback callback) throws Exception {
        this.map.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION.name(), this.config);
        this.map.put(IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK.name(), new LongRunningTaskCallback(){

            @Override
            public void updateProgress(byte progress) {
                callback.updateProgress(progress);
            }

            @Override
            public boolean isToBeStopped() {
                return MetadataBasedLongRunningTask.this.isToBeStopped();
            }

            @Override
            public void addEvent(String eventId, Message description) {
                callback.addEvent(eventId, description);
            }
        });
        this.map.put(IBusStandardContextKeys.LONG_RUNNING_TASK_DATA.name(), this.data);
        String routeId = (String)this.ett.getParameters().get("route-id");
        if (TextUtil.nonBlank((String)routeId)) {
            IntegrationBusFacade.get().processRouteSync(routeId, this.map);
        } else {
            IntegrationBusFacade.get().getRequestReplyAdapter((String)this.ett.getParameters().get("adapter-id")).processSync(this.map);
        }
        if (!this.isToBeStopped()) {
            callback.updateProgress((byte)100);
            callback.taskFinished();
        }
        this.data = this.map.get(IBusStandardContextKeys.LONG_RUNNING_TASK_DATA.name());
    }
}

