/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.MigrateCostCodeCategoryTaskConfiguration;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class MigrateCostCodeCategoryTask
extends BaseLongRunningTask<MigrateCostCodeCategoryTaskConfiguration> {
    private MigrateCostCodeCategoryTaskConfiguration config;

    @Override
    public void configure(MigrateCostCodeCategoryTaskConfiguration configuration) throws Exception {
        this.config = configuration;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u041c\u0438\u0433\u0440\u0430\u0446\u0438\u044f \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u043a\u043e\u0441\u0442-\u043a\u043e\u0434\u0430", (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeObject((Element)elm, (String)"config", (Object)this.config);
    }

    public void fromXML(Element elm) throws Exception {
        this.config = (MigrateCostCodeCategoryTaskConfiguration)XHelper.readObject((Element)elm, (String)"config");
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), (Object)this.config.getClient()));
        query.getCriteria().getCriterions().add(SearchCriterion.between((String)CommonProductIndex.Property.issueDate.name(), (Object)this.config.getIssueDateStart(), (Object)this.config.getIssueDateEnd()));
        query.getPreferredProperties().add(CommonProductIndex.Property.bookingNumber.name());
        Set refs = EntityStorage.get().search(CommonProductIndex.class, query).getData().stream().map(idx -> idx.getSource()).distinct().collect(Collectors.toSet());
        int total = refs.size();
        int current = 1;
        byte progress = 0;
        for (EntityReference ref : refs) {
            EntityContainer ctr = EntityStorage.get().resolve(ref);
            boolean modified = false;
            for (Reservation reservation : ((BookingFile)ctr.getEntity()).getReservations()) {
                for (BaseProduct bp : reservation.getProducts()) {
                    ProductHandler ph = HandlersRegistry.get().findProductHandler(bp.getClass());
                    StatisticalData sd = ph.getStatisticalData(bp);
                    if (sd == null) continue;
                    for (TravellerCostCodes tcc : sd.getTravellerCostCodes()) {
                        for (CostCode cc : tcc.getCostCodes()) {
                            if (cc.getCostCodeProperties() == null || !this.config.getOldCategory().equals((Object)cc.getCostCodeProperties().getCategory())) continue;
                            cc.getCostCodeProperties().setCategory(this.config.getNewCategory());
                            modified = true;
                        }
                    }
                }
            }
            if (modified) {
                ctr.getVersionInfo().setDataSource("\u043c\u0438\u0433\u0440\u0430\u0446\u0438\u044f \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u043a\u043e\u0441\u0442-\u043a\u043e\u0434\u0430");
                EntityStorage.get().save(ctr, true);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0432 \u0437\u0430\u043a\u0430\u0437\u0435 {0} \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0430 \u0437\u0430\u043c\u0435\u043d\u0430", (Object[])new Object[]{((BookingFile)ctr.getEntity()).getNumber()}));
            } else {
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0432 \u0437\u0430\u043a\u0430\u0437\u0435 {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043a\u043e\u0441\u0442-\u043a\u043e\u0434\u044b \u043d\u0443\u0436\u043d\u043e\u0439 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438", (Object[])new Object[]{((BookingFile)ctr.getEntity()).getNumber()}));
            }
            byte newProgress = (byte)(current * 100 / total);
            if (progress != newProgress) {
                progress = newProgress;
                callback.updateProgress(progress);
            }
            ++current;
        }
    }
}

