/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeDisplayType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.MigrateCostCodeValuesTaskConfiguration;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class MigrateCostCodeValuesTask
extends BaseLongRunningTask<MigrateCostCodeValuesTaskConfiguration> {
    private MigrateCostCodeValuesTaskConfiguration config;
    final Set<String> toProceed = new LinkedHashSet<String>();
    private int count = -1;

    @Override
    public void configure(MigrateCostCodeValuesTaskConfiguration configuration) throws Exception {
        this.config = configuration;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.MigrateCostCodeValuesTask_description, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeObject((Element)elm, (String)"config", (Object)this.config);
        Element countElement = XmlUtil.addElement((Element)elm, (String)"count");
        countElement.setAttribute("value", String.valueOf(this.count));
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    public void fromXML(Element elm) throws Exception {
        this.config = (MigrateCostCodeValuesTaskConfiguration)XHelper.readObject((Element)elm, (String)"config");
        Element countElement = XmlUtil.getElement((Element)elm, (String)"count");
        if (countElement != null) {
            this.count = Integer.parseInt(countElement.getAttribute("value"));
        }
        for (Element element : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(element.getAttribute("uid"));
        }
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("Migrate cost code values task started");
        Locale currentLocale = LocaleHelper.getCurrentLocale();
        EntityReference client = this.config.getClient();
        DictionaryReference category = this.config.getCategory();
        String newValue = this.config.getNewValue();
        String newLocalValue = this.config.getNewLocalValue();
        String newEnglishValue = this.config.getNewEnglishValue();
        EntityContainer clientCtr = EntityStorage.get().resolve(client);
        List costCodes = ((Organization)clientCtr.getEntity()).getCostCodes().stream().filter(costCode -> costCode.getCostCodeProperties() != null && MiscUtil.equals((Object)category, (Object)costCode.getCostCodeProperties().getCategory())).collect(Collectors.toList());
        if (!costCodes.isEmpty()) {
            List values = costCodes.stream().map(CostCode::getValue).collect(Collectors.toList());
            if (TextUtil.nonBlank((String)newValue) && !values.contains(newValue)) {
                values = costCodes.stream().map(cc -> ProfileHelper.getCostCodeValue((CostCode)cc, (CostCodeDisplayType)cc.getCostCodeProperties().getDisplayType())).collect(Collectors.toList());
            }
            if (TextUtil.nonBlank((String)newValue) && !values.contains(newValue)) {
                this.log.error(String.format("unable to migrate cost code value -> client does not contain cost code value %s for category %s", newValue, category));
                callback.addEvent(null, MessagesHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)Messages.MigrateCostCodeValuesTask_costCodeValueMigrationFailed, (String)L10nResourcesManager.getStr((String)Messages.MigrateCostCodeValuesTask_clientDoesNotContainCostCodeValue, (Object[])new Object[]{client.getCaption(), category.toString(currentLocale), newValue}), (Object[])new Object[0]));
                throw new Exception(String.format("client does not contain cost code value %s for category %s", newValue, category.toString(currentLocale)));
            }
            List localValues = costCodes.stream().map(CostCode::getLocalValue).collect(Collectors.toList());
            if (TextUtil.nonBlank((String)newLocalValue) && !localValues.contains(newLocalValue)) {
                this.log.error(String.format("unable to migrate cost code value -> client does not contain cost code local value %s for category %s", newLocalValue, category));
                callback.addEvent(null, MessagesHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)Messages.MigrateCostCodeValuesTask_costCodeValueMigrationFailed, (String)L10nResourcesManager.getStr((String)Messages.MigrateCostCodeValuesTask_clientDoesNotContainCostCodeLocalValue, (Object[])new Object[]{client.getCaption(), category.toString(currentLocale), newLocalValue}), (Object[])new Object[0]));
                throw new Exception(String.format("client does not contain cost code local value %s for category %s", newLocalValue, category.toString(currentLocale)));
            }
            List englishValues = costCodes.stream().map(CostCode::getEnglishValue).collect(Collectors.toList());
            if (TextUtil.nonBlank((String)newEnglishValue) && !englishValues.contains(newEnglishValue)) {
                this.log.error(String.format("unable to migrate cost code value -> client does not contain cost code english value %s for category %s", newEnglishValue, category));
                callback.addEvent(null, MessagesHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)Messages.MigrateCostCodeValuesTask_costCodeValueMigrationFailed, (String)L10nResourcesManager.getStr((String)Messages.MigrateCostCodeValuesTask_clientDoesNotContainCostCodeEnglishValue, (Object[])new Object[]{client.getCaption(), category.toString(currentLocale), newEnglishValue}), (Object[])new Object[0]));
                throw new Exception(String.format("client does not contain cost code english value %s for category %s", newEnglishValue, category.toString(currentLocale)));
            }
        }
        this.updateUids();
        if (this.count == -1) {
            this.count = this.toProceed.size();
        }
        int n = this.count - this.toProceed.size();
        Iterator<String> iterator = this.toProceed.iterator();
        while (iterator.hasNext()) {
            EntityContainer bfCtr;
            ++n;
            String uid = iterator.next();
            if (this.isToBeStopped()) {
                this.log.debug(String.format("task is interrupted while processing bookingFile %s", uid));
                return;
            }
            byte progress = (byte)(100 * n / this.count);
            if (n % 10 == 0) {
                callback.updateProgress(progress);
            }
            if ((bfCtr = EntityStorage.get().load(BookingFile.class, uid)) == null) continue;
            boolean modified = false;
            for (Reservation reservation : ((BookingFile)bfCtr.getEntity()).getReservations()) {
                for (BaseProduct product : reservation.getProducts()) {
                    boolean productModified = false;
                    boolean costCodeCategoryFound = false;
                    String systemNumber = GeneralProductHelper.getSystemNumber((BaseProduct)product);
                    List clientFops = GeneralProductHelper.getClientFops((BaseProduct)product);
                    Set fopsUids = clientFops.stream().map(BaseIdentity::getUid).collect(Collectors.toSet());
                    List shipmentCostCodes = product.getFopDetalizations().entrySet().stream().filter(it -> fopsUids.contains(it.getKey())).flatMap(it -> ((FopDetalization)it.getValue()).getComponents().stream()).map(FopComponent::getShipment).filter(Objects::nonNull).distinct().map(item -> EntityStorage.get().resolve(item)).filter(Objects::nonNull).map(EntityContainer::getEntity).flatMap(item -> item.getCostCodes().stream()).collect(Collectors.toList());
                    if (shipmentCostCodes.stream().anyMatch(item -> item.getCostCodeProperties() != null && category.equals((Object)item.getCostCodeProperties().getCategory()))) {
                        callback.addEvent(null, MessagesHelper.createMessageWithDetails((MessageType)MessageType.MESSAGE, (String)L10nResourcesManager.getStr((String)Messages.MigrateCostCodeValuesTask_costCodeValueMigrationForProductUnable, (Object[])new Object[]{systemNumber}), (String)L10nResourcesManager.getStr((String)Messages.MigrateCostCodeValuesTask_productHasShipmentWithCostCodeCategory, (Object[])new Object[]{systemNumber, category.toString(currentLocale)}), (Object[])new Object[0]));
                        continue;
                    }
                    ProductHandler handler = ProductHandler.of((BaseProduct)product);
                    StatisticalData statisticalData = handler.getStatisticalData(product);
                    if (statisticalData != null) {
                        for (TravellerCostCodes tcc : statisticalData.getTravellerCostCodes()) {
                            for (CostCode cc2 : tcc.getCostCodes()) {
                                if (cc2.getCostCodeProperties() == null || !category.equals((Object)cc2.getCostCodeProperties().getCategory())) continue;
                                costCodeCategoryFound = true;
                                if (TextUtil.nonBlank((String)newValue) && TextUtil.nonBlank((String)this.config.getOldValue()) && this.config.getOldValue().equals(cc2.getValue())) {
                                    cc2.setValue(newValue);
                                    productModified = true;
                                    modified = true;
                                }
                                if (TextUtil.nonBlank((String)newLocalValue) && TextUtil.nonBlank((String)this.config.getOldLocalValue()) && this.config.getOldLocalValue().equals(cc2.getLocalValue())) {
                                    cc2.setLocalValue(newLocalValue);
                                    productModified = true;
                                    modified = true;
                                }
                                if (!TextUtil.nonBlank((String)newEnglishValue) || !TextUtil.nonBlank((String)this.config.getOldEnglishValue()) || !this.config.getOldEnglishValue().equals(cc2.getEnglishValue())) continue;
                                cc2.setEnglishValue(newEnglishValue);
                                productModified = true;
                                modified = true;
                            }
                        }
                    }
                    if (!costCodeCategoryFound || productModified) continue;
                    callback.addEvent(null, MessagesHelper.createMessageWithDetails((MessageType)MessageType.MESSAGE, (String)L10nResourcesManager.getStr((String)Messages.MigrateCostCodeValuesTask_costCodeValueMigrationForProductUnable, (Object[])new Object[]{systemNumber}), (String)L10nResourcesManager.getStr((String)Messages.MigrateCostCodeValuesTask_costCodeValuesNotFound, (Object[])new Object[]{systemNumber, category.toString(currentLocale), String.format("%s, %s, %s", this.config.getOldValue(), this.config.getOldLocalValue(), this.config.getOldEnglishValue())}), (Object[])new Object[0]));
                }
            }
            if (modified) {
                bfCtr.getVersionInfo().setDataSource("MigrateCostCodeValuesTask");
                EntityStorage.get().save(bfCtr, true);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.MigrateCostCodeValuesTask_costCodeValuesMigrateInBookingFile, (Object[])new Object[]{((BookingFile)bfCtr.getEntity()).getNumber(), category.toString(currentLocale)}));
            }
            iterator.remove();
        }
        this.log.debug("Migrate cost code values task finished");
        callback.taskFinished();
    }

    private void updateUids() {
        if (!this.toProceed.isEmpty()) {
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), (Object)this.config.getClient()));
        query.getCriteria().getCriterions().add(SearchCriterion.between((String)CommonProductIndex.Property.issueDate.name(), (Object)this.config.getIssueDateStart(), (Object)this.config.getIssueDateEnd()));
        query.getPreferredProperties().add(CommonProductIndex.Property.bookingNumber.name());
        EntityStorage entityStorage = EntityStorage.get();
        Set uids = entityStorage.search(CommonProductIndex.class, query).getData().stream().map(item -> entityStorage.resolve(item.getSource())).filter(Objects::nonNull).map(BaseIdentity::getUid).collect(Collectors.toSet());
        this.toProceed.addAll(uids);
    }
}

