/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.MigrateEntitiesTaskConfiguration;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.migration.DataMigrationRequest;
import com.gridnine.xtrip.server.model.synchronization.migration.DataMigrationSynchronizationHandler;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseEntityUpdateTask;

public class MigrateEntitiesTask
extends BaseEntityUpdateTask<MigrateEntitiesTaskConfiguration> {
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        try {
            DataMigrationRequest data = new DataMigrationRequest();
            data.setCheckOnly(true);
            SynchronizationRequest<DataMigrationRequest> request = new SynchronizationRequest<DataMigrationRequest>();
            request.setData(data);
            request.setOperationId(DataMigrationSynchronizationHandler.OPERATION_ID);
            SynchronizationResponse response = SynchronizationHelper.execute(request, ((MigrateEntitiesTaskConfiguration)this.config).getUrl(), null);
            for (Message msg : response.getMessages()) {
                if (msg.getType() != MessageType.ERROR) continue;
                callback.addEvent(null, msg);
                return;
            }
        }
        catch (Exception e) {
            callback.addEvent(null, MessageHelper.createErrorMessage((String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0432\u044f\u0437\u0430\u0442\u044c\u0441\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", (Object[])new Object[]{e}));
        }
        super.doJob(callback);
    }

    @Override
    protected <E extends BaseEntity> void processContainer(EntityContainer<E> ctr, LogicalEntityStorage storage, Object data) throws Exception {
        DataMigrationRequest rData = new DataMigrationRequest();
        rData.setObject((XSerializable)ctr);
        SynchronizationRequest<DataMigrationRequest> request = new SynchronizationRequest<DataMigrationRequest>();
        request.setData(rData);
        request.setOperationId(DataMigrationSynchronizationHandler.OPERATION_ID);
        SynchronizationResponse response = SynchronizationHelper.execute(request, ((MigrateEntitiesTaskConfiguration)this.config).getUrl(), null);
        boolean hasErrors = response.getMessages().stream().anyMatch(message -> message.getType() == MessageType.ERROR);
        if (hasErrors) {
            throw Xeption.forEndUser((String)("\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442 " + ctr), (Object[])new Object[0]);
        }
    }

    @Override
    protected Class<MigrateEntitiesTaskConfiguration> getConfigurationClass() {
        return MigrateEntitiesTaskConfiguration.class;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u0435: \u043f\u0435\u0440\u0435\u043d\u043e\u0441 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0434\u0440\u0443\u0433\u043e\u0439 \u041c\u041e\u041c", (Object[])new Object[0]);
    }
}

